/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.material.Material;
import gregtech.api.util.TextFormattingUtil;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.api.worldgen.config.BedrockFluidDepositDefinition;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.ConfigHolder;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.adapter.GTBoilerCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTMetalCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 _2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001_B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u0012\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0017J\b\u0010$\u001a\u00020!H\u0015J5\u0010%\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0012\u0010*\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010,\u0018\u00010+H\u0016\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u00020\u0018H\u0014J\b\u0010/\u001a\u00020\u0018H\u0002J\b\u00100\u001a\u00020\u0010H\u0002J\u000e\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u0010J\u0006\u00103\u001a\u000204J\u0018\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0010H\u0002J\u0010\u00107\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u0010H\u0002J\u0010\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020:H\u0014J4\u0010;\u001a\u00020\u00182\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010>\u001a\u0004\u0018\u00010?2\u000e\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010B0A2\u0006\u0010C\u001a\u00020\u0010H\u0016J\b\u0010D\u001a\u00020\u0007H\u0016J\b\u0010E\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010F\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u0010H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010H\u001a\u00020\u00182\u0006\u0010I\u001a\u00020\u0010J\u0012\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020KH\u0016J\u0010\u0010M\u001a\u00020\u00182\u0006\u0010L\u001a\u00020KH\u0016J\u0010\u0010N\u001a\u00020\u00182\u0006\u0010O\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\u00182\u0006\u0010O\u001a\u00020PH\u0016J\u0018\u0010R\u001a\u00020\u00182\u0006\u0010S\u001a\u00020\u00072\u0006\u0010O\u001a\u00020PH\u0016J5\u0010T\u001a\u0004\u0018\u0001HU\"\n\b\u0000\u0010U*\u0004\u0018\u00010V2\u000e\u0010W\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HU0X2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0016\u00a2\u0006\u0002\u0010[J\b\u0010\\\u001a\u00020\u0010H\u0016J\b\u0010]\u001a\u00020\u0010H\u0016J\b\u0010^\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockHydraulicFracker;", "Lgregtech/api/metatileentity/multiblock/MultiblockWithDisplayBase;", "Lgregtech/api/capability/IWorkable;", "Lgregtech/api/metatileentity/ITieredMetaTileEntity;", "id", "Lnet/minecraft/util/ResourceLocation;", "tier", "", "<init>", "(Lnet/minecraft/util/ResourceLocation;I)V", "inputFluidInventory", "Lgregtech/api/capability/IMultipleTankHandler;", "energyContainer", "Lgregtech/api/capability/IEnergyContainer;", "progressTime", "isActive", "", "isWorkingEnabled", "wasActiveAndNeedsUpdate", "hasNotEnoughEnergy", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "initializeAbilities", "resetTileAbilities", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "renderMetaTileEntity", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "updateFormedValid", "updateLogic", "checkCanDrain", "drainEnergy", "simulate", "getEnergyInputPerSecond", "", "drainTanks", "amount", "replenishVein", "configureDisplayText", "builder", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIBuilder;", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "getProgress", "getMaxProgress", "setWorkingEnabled", "workingStatus", "setActive", "active", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "data", "readFromNBT", "writeInitialSyncData", "buf", "Lnet/minecraft/network/PacketBuffer;", "receiveInitialSyncData", "receiveCustomData", "dataId", "getCapability", "T", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "side", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "hasMaintenanceMechanics", "shouldShowVoidingModeButton", "getTier", "Companion", "gtlitecore"})
public final class MultiblockHydraulicFracker
extends MultiblockWithDisplayBase
implements IWorkable,
ITieredMetaTileEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int tier;
    @Nullable
    private IMultipleTankHandler inputFluidInventory;
    @Nullable
    private IEnergyContainer energyContainer;
    private int progressTime;
    private boolean isActive;
    private boolean isWorkingEnabled;
    private boolean wasActiveAndNeedsUpdate;
    private boolean hasNotEnoughEnergy;
    private static final int FLUID_USE_AMOUNT = 1000;
    private static final int MAX_PROGRESS = 100;
    @NotNull
    private static final IBlockState casingState = MetalCasing.WATERTIGHT_STEEL.getState();
    @NotNull
    private static final IBlockState secondCasingState = GTMetalCasing.STAINLESS_CLEAN.getState();
    @NotNull
    private static final IBlockState pipeCasingState = GTBoilerCasing.STEEL_PIPE.getState();

    public MultiblockHydraulicFracker(@NotNull ResourceLocation id, int tier) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id);
        this.tier = tier;
        this.isActive = true;
        this.isWorkingEnabled = true;
    }

    @NotNull
    public MultiblockHydraulicFracker createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockHydraulicFracker(resourceLocation, this.tier);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.initializeAbilities();
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
    }

    private final void initializeAbilities() {
        this.inputFluidInventory = (IMultipleTankHandler)new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.energyContainer = (IEnergyContainer)new EnergyContainerList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
    }

    private final void resetTileAbilities() {
        this.inputFluidInventory = (IMultipleTankHandler)new FluidTankList(true, new IFluidTank[0]);
        this.energyContainer = (IEnergyContainer)new EnergyContainerList((List)new ArrayList());
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"F    F", "F    F", "F  CCC", "F  CCC", "F  CCC", "FFFCCC", "   CCC", "   CCC"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"    P ", "    P ", "   CPC", "   CPC", "   CPC", "F  CPC", " PPPPC", "   CCC"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"      ", "      ", "   CCC", "XXXCCC", "XXXCCC", "XXXCCC", " P CCC", "   CCC"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"      ", "      ", "     F", "XXXX  ", "X##X  ", "XXXX F", " P    ", "      "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"      ", "      ", "     F", "XXXX  ", "XP#X  ", "XPXX F", " P    ", "      "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"F    F", "F    F", "F    F", "XXXX F", "XSXX F", "XXXXFF", "      ", "      "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = MultiblockWithDisplayBase.states((IBlockState[])stringArray).or(this.autoAbilities());
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY};
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setExactLimit(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.where('X', traceabilityPredicate2.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setMinGlobalLimited(1)));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.where('C', MultiblockWithDisplayBase.states((IBlockState[])stringArray));
        stringArray = new Material[]{GTLiteMaterials.INSTANCE.getHSLASteel()};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.where('F', MultiblockWithDisplayBase.frames((Material[])stringArray));
        stringArray = new IBlockState[]{pipeCasingState};
        BlockPattern blockPattern = factoryBlockPattern9.where('P', MultiblockWithDisplayBase.states((IBlockState[])stringArray)).where('#', MultiblockWithDisplayBase.air()).where(' ', MultiblockWithDisplayBase.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.WATERTIGHT_STEEL_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.LARGE_BREWERY_OVERLAY;
    }

    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.frontFacing, this.isActive, this.isWorkingEnabled);
    }

    protected void updateFormedValid() {
        if (!this.getWorld().field_72995_K) {
            this.updateLogic();
            if (this.wasActiveAndNeedsUpdate) {
                this.wasActiveAndNeedsUpdate = false;
                this.setActive(false);
            }
        }
    }

    private final void updateLogic() {
        if (!this.replenishVein(true)) {
            return;
        }
        if (!this.isWorkingEnabled()) {
            return;
        }
        if (!this.checkCanDrain()) {
            return;
        }
        this.drainEnergy(false);
        if (!this.isActive()) {
            this.setActive(true);
        }
        int n = this.progressTime;
        this.progressTime = n + 1;
        if (this.progressTime % 100 != 0) {
            return;
        }
        this.progressTime = 0;
        if (this.drainTanks(1000, true)) {
            this.drainTanks(1000, false);
            this.replenishVein(false);
        }
    }

    private final boolean checkCanDrain() {
        if (!this.drainEnergy(true)) {
            if (this.progressTime >= 2) {
                this.progressTime = ConfigHolder.machines.recipeProgressLowEnergy ? 1 : Math.max(1, this.progressTime - 2);
                this.hasNotEnoughEnergy = true;
            }
            return false;
        }
        if (this.drainTanks(1000, true)) {
            return true;
        }
        if (this.hasNotEnoughEnergy && this.getEnergyInputPerSecond() > 19L * (long)GTValues.VA[this.tier]) {
            this.hasNotEnoughEnergy = false;
        }
        if (this.isActive()) {
            this.setActive(false);
            this.wasActiveAndNeedsUpdate = true;
        }
        return false;
    }

    public final boolean drainEnergy(boolean simulate) {
        long energyToDrain = GTValues.VA[this.tier];
        IEnergyContainer iEnergyContainer = this.energyContainer;
        Intrinsics.checkNotNull((Object)iEnergyContainer);
        long resultEnergy = iEnergyContainer.getEnergyStored() - energyToDrain;
        if (resultEnergy >= 0L) {
            IEnergyContainer iEnergyContainer2 = this.energyContainer;
            Intrinsics.checkNotNull((Object)iEnergyContainer2);
            if (resultEnergy <= iEnergyContainer2.getEnergyCapacity()) {
                if (!simulate) {
                    IEnergyContainer iEnergyContainer3 = this.energyContainer;
                    Intrinsics.checkNotNull((Object)iEnergyContainer3);
                    iEnergyContainer3.changeEnergy(-energyToDrain);
                }
                return true;
            }
        }
        return false;
    }

    public final long getEnergyInputPerSecond() {
        IEnergyContainer iEnergyContainer = this.energyContainer;
        Intrinsics.checkNotNull((Object)iEnergyContainer);
        return iEnergyContainer.getInputPerSec();
    }

    private final boolean drainTanks(int amount, boolean simulate) {
        IMultipleTankHandler iMultipleTankHandler = this.inputFluidInventory;
        Intrinsics.checkNotNull((Object)iMultipleTankHandler);
        FluidStack stack = iMultipleTankHandler.drain(amount, !simulate);
        return stack != null && stack.isFluidEqual(GTLiteMaterials.INSTANCE.getFracturingFluid().getFluid(1)) && stack.amount == 1000;
    }

    private final boolean replenishVein(boolean simulate) {
        BedrockFluidVeinHandler.FluidVeinWorldEntry entry = BedrockFluidVeinHandler.getFluidVeinWorldEntry((World)this.getWorld(), (int)(this.getPos().func_177958_n() / 16), (int)(this.getPos().func_177952_p() / 16));
        if (entry == null) {
            return false;
        }
        BedrockFluidDepositDefinition definition = entry.getDefinition();
        if (definition == null) {
            return false;
        }
        int amount = entry.getOperationsRemaining() + definition.getDepletionAmount();
        if (amount <= 100000) {
            if (simulate) {
                return true;
            }
            entry.setOperationsRemaining(amount);
        }
        return true;
    }

    protected void configureDisplayText(@NotNull MultiblockUIBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.addEnergyUsageLine(this.energyContainer).addWorkingStatusLine().addProgressLine(this.getProgress(), this.getMaxProgress()).addLowPowerLine(this.hasNotEnoughEnergy);
    }

    public void addInformation(@Nullable ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.hydraulic_fracker.tooltip.1", (Object[])new Object[0]));
        Object[] objectArray = new Object[]{TextFormattingUtil.formatNumbers((Object)GTValues.VA[this.tier])};
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.hydraulic_fracker.tooltip.2", (Object[])objectArray));
    }

    public int getProgress() {
        return this.progressTime;
    }

    public int getMaxProgress() {
        return 100;
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public void setWorkingEnabled(boolean workingStatus) {
        if (this.isWorkingEnabled != workingStatus) {
            this.isWorkingEnabled = workingStatus;
            this.markDirty();
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, arg_0 -> MultiblockHydraulicFracker.setWorkingEnabled$lambda$0(this, arg_0));
            }
        }
    }

    public boolean isActive() {
        return super.isActive() && this.isActive;
    }

    public final void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.markDirty();
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, arg_0 -> MultiblockHydraulicFracker.setActive$lambda$1(this, arg_0));
            }
        }
    }

    @Nullable
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.writeToNBT(data);
        data.func_74757_a("isActive", this.isActive);
        data.func_74757_a("isWorkingEnabled", this.isWorkingEnabled);
        data.func_74757_a("wasActiveAndNeedsUpdate", this.wasActiveAndNeedsUpdate);
        data.func_74768_a("progressTime", this.progressTime);
        return data;
    }

    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.readFromNBT(data);
        this.isActive = data.func_74767_n("isActive");
        this.isWorkingEnabled = data.func_74767_n("isWorkingEnabled");
        this.wasActiveAndNeedsUpdate = data.func_74767_n("wasActiveAndNeedsUpdate");
        this.progressTime = data.func_74762_e("progressTime");
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.isWorkingEnabled);
        buf.writeBoolean(this.wasActiveAndNeedsUpdate);
        buf.writeInt(this.progressTime);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
        this.isWorkingEnabled = buf.readBoolean();
        this.wasActiveAndNeedsUpdate = buf.readBoolean();
        this.progressTime = buf.readInt();
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing side) {
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, (Object)GregtechTileCapabilities.CAPABILITY_WORKABLE)) {
            return (T)GregtechTileCapabilities.CAPABILITY_WORKABLE.cast((Object)this);
        }
        if (Intrinsics.areEqual(capability, (Object)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE)) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    public int getTier() {
        return this.tier;
    }

    private static final void setWorkingEnabled$lambda$0(MultiblockHydraulicFracker this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.isWorkingEnabled);
    }

    private static final void setActive$lambda$1(MultiblockHydraulicFracker this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.isActive);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockHydraulicFracker$Companion;", "", "<init>", "()V", "FLUID_USE_AMOUNT", "", "MAX_PROGRESS", "casingState", "Lnet/minecraft/block/state/IBlockState;", "secondCasingState", "pipeCasingState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

