/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIFactory;
import gregtech.api.metatileentity.multiblock.ui.TemplateBarBuilder;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.logic.OCParams;
import gregtech.api.recipes.properties.RecipeProperty;
import gregtech.api.recipes.properties.RecipePropertyStorage;
import gregtech.api.recipes.properties.impl.FusionEUToStartProperty;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.interpolate.Eases;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.IRenderSetup;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.client.shader.postprocessing.BloomType;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.EffectRenderContext;
import gregtech.client.utils.IBloomEffect;
import gregtech.client.utils.RenderBufferHelper;
import gregtech.client.utils.RenderUtil;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityEnergyHatch;
import gregtechlite.gtlitecore.api.gui.GTLiteMuiTextures;
import gregtechlite.gtlitecore.api.gui.template.FusionReactorUITemplate;
import gregtechlite.gtlitecore.client.renderer.handler.FusionBloomSetup;
import gregtechlite.gtlitecore.common.block.variant.fusion.FusionCasing;
import gregtechlite.gtlitecore.common.block.variant.fusion.FusionCoil;
import gregtechlite.gtlitecore.common.metatileentity.GTLiteMetaTileEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\\B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0016\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0014J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\bH\u0002J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020$H\u0002J\u0012\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0017J\b\u0010+\u001a\u00020(H\u0015J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0016J\b\u0010/\u001a\u00020\u001aH\u0014J\u0010\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u001a2\u0006\u00101\u001a\u000202H\u0016J\u0018\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\b2\u0006\u00101\u001a\u000202H\u0016J4\u00106\u001a\u00020\u001a2\b\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010:2\u000e\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010<0-2\u0006\u0010=\u001a\u00020\u0015H\u0016J\n\u0010>\u001a\u0004\u0018\u00010?H\u0014J\b\u0010@\u001a\u00020\bH\u0016J$\u0010A\u001a\u00020\u001a2\u0012\u0010B\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0C0-2\u0006\u0010E\u001a\u00020FH\u0016J(\u0010G\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020I2\u0006\u0010L\u001a\u00020MH\u0017J\b\u0010N\u001a\u00020OH\u0002J\u0018\u0010P\u001a\u00020\u001a2\u0006\u0010Q\u001a\u00020R2\u0006\u0010\u001b\u001a\u00020SH\u0017J\u0010\u0010T\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020SH\u0017J\b\u0010U\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020\u00152\u0006\u0010X\u001a\u00020\bH\u0016J\b\u0010Y\u001a\u00020\u0015H\u0016J\b\u0010Z\u001a\u00020\u0015H\u0016J\b\u0010[\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockFusionReactor;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "Lgregtech/api/metatileentity/IFastRenderMetaTileEntity;", "Lgregtech/client/utils/IBloomEffect;", "Lgregtech/api/metatileentity/multiblock/ProgressBarMultiblock;", "id", "Lnet/minecraft/util/ResourceLocation;", "tier", "", "<init>", "(Lnet/minecraft/util/ResourceLocation;I)V", "emptyColor", "value", "fusionRingColor", "setFusionRingColor", "(I)V", "energyContainers", "Lgregtech/api/capability/impl/EnergyContainerList;", "heat", "", "registeredBloomRenderTicket", "", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "initializeAbilities", "calculateEnergyStorageFactor", "energyInputAmount", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getCasingState", "Lnet/minecraft/block/state/IBlockState;", "getGlassState", "getCoilState", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "getMatchingShapes", "", "Lgregtech/api/pattern/MultiblockShapeInfo;", "updateFormedValid", "writeInitialSyncData", "buf", "Lnet/minecraft/network/PacketBuffer;", "receiveInitialSyncData", "receiveCustomData", "dataId", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "advanced", "createUIFactory", "Lgregtech/api/metatileentity/multiblock/ui/MultiblockUIFactory;", "getProgressBarCount", "registerBars", "templateBars", "Ljava/util/function/UnaryOperator;", "Lgregtech/api/metatileentity/multiblock/ui/TemplateBarBuilder;", "guiSyncManager", "Lcom/cleanroommc/modularui/value/sync/PanelSyncManager;", "renderMetaTileEntity", "x", "", "y", "z", "partialTicks", "", "getBloomType", "Lgregtech/client/shader/postprocessing/BloomType;", "renderBloomEffect", "buffer", "Lnet/minecraft/client/renderer/BufferBuilder;", "Lgregtech/client/utils/EffectRenderContext;", "shouldRenderBloomEffect", "getRenderBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "shouldRenderInPass", "pass", "isGlobalRenderer", "canBeDistinct", "hasMaintenanceMechanics", "FusionRecipeLogic", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nMultiblockFusionReactor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiblockFusionReactor.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockFusionReactor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,467:1\n774#2:468\n865#2,2:469\n37#3:471\n36#3,3:472\n*S KotlinDebug\n*F\n+ 1 MultiblockFusionReactor.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockFusionReactor\n*L\n179#1:468\n179#1:469,2\n180#1:471\n180#1:472,3\n*E\n"})
public final class MultiblockFusionReactor
extends RecipeMapMultiblockController
implements IFastRenderMetaTileEntity,
IBloomEffect,
ProgressBarMultiblock {
    private final int tier;
    private final int emptyColor;
    private int fusionRingColor;
    @Nullable
    private EnergyContainerList energyContainers;
    private long heat;
    @SideOnly(value=Side.CLIENT)
    private boolean registeredBloomRenderTicket;

    public MultiblockFusionReactor(@NotNull ResourceLocation id, int tier) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, RecipeMaps.FUSION_RECIPES);
        this.tier = tier;
        this.fusionRingColor = this.emptyColor;
        this.recipeMapWorkable = new FusionRecipeLogic(this);
        this.energyContainer = (IEnergyContainer)new EnergyContainerHandler(this){

            public String getName() {
                return "EnergyContainerInternal";
            }
        };
    }

    private final void setFusionRingColor(int value) {
        if (this.fusionRingColor != value) {
            this.setFusionRingColor(value);
            this.writeCustomData(GregtechDataCodes.UPDATE_COLOR, arg_0 -> MultiblockFusionReactor._set_fusionRingColor_$lambda$0(this, arg_0));
        }
    }

    @NotNull
    public MultiblockFusionReactor createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockFusionReactor(resourceLocation, this.tier);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        long storedEnergy = this.energyContainer.getEnergyStored();
        this.initializeAbilities();
        IEnergyContainer iEnergyContainer = this.energyContainer;
        Intrinsics.checkNotNull((Object)iEnergyContainer, (String)"null cannot be cast to non-null type gregtech.api.capability.impl.EnergyContainerHandler");
        ((EnergyContainerHandler)iEnergyContainer).setEnergyStored(storedEnergy);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.energyContainer = (IEnergyContainer)new EnergyContainerHandler(this){

            public String getName() {
                return "EnergyContainerInternal";
            }
        };
        this.energyContainers = new EnergyContainerList((List)new ArrayList());
        this.heat = 0L;
        this.setFusionRingColor(this.emptyColor);
    }

    protected void initializeAbilities() {
        this.inputInventory = (IItemHandlerModifiable)new ItemHandlerList(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.inputFluidInventory = (IMultipleTankHandler)new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.outputInventory = (IItemHandlerModifiable)new ItemHandlerList(this.getAbilities(MultiblockAbility.EXPORT_ITEMS));
        this.outputFluidInventory = (IMultipleTankHandler)new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
        List energyInputs = this.getAbilities(MultiblockAbility.INPUT_ENERGY);
        this.energyContainers = new EnergyContainerList(energyInputs);
        long euCapacity = this.calculateEnergyStorageFactor(energyInputs.size());
        long l = GTValues.V[this.tier];
        this.energyContainer = (IEnergyContainer)new EnergyContainerHandler(this, euCapacity, l){

            public String getName() {
                return "EnergyContainerInternal";
            }
        };
    }

    private final long calculateEnergyStorageFactor(int energyInputAmount) {
        return (long)energyInputAmount * (long)Math.pow(2.0, this.tier - 6) * 10000000L;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected BlockPattern createStructurePattern() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String[] stringArray = new String[]{"               ", "      OGO      ", "               "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"      ICI      ", "    GG###GG    ", "      ICI      "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"    CC   CC    ", "   E##OGO##E   ", "    CC   CC    "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"   C       C   ", "  EKEG   GEKE  ", "   C       C   "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"  C         C  ", " G#E       E#G ", "  C         C  "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"  C         C  ", " G#G       G#G ", "  C         C  "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{" I           I ", "O#O         O#O", " I           I "};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray);
        stringArray = new String[]{" C           C ", "G#G         G#G", " C           C "};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.aisle(stringArray);
        stringArray = new String[]{" I           I ", "O#O         O#O", " I           I "};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.aisle(stringArray);
        stringArray = new String[]{"  C         C  ", " G#G       G#G ", "  C         C  "};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.aisle(stringArray);
        stringArray = new String[]{"  C         C  ", " G#E       E#G ", "  C         C  "};
        FactoryBlockPattern factoryBlockPattern11 = factoryBlockPattern10.aisle(stringArray);
        stringArray = new String[]{"   C       C   ", "  EKEG   GEKE  ", "   C       C   "};
        FactoryBlockPattern factoryBlockPattern12 = factoryBlockPattern11.aisle(stringArray);
        stringArray = new String[]{"    CC   CC    ", "   E##OGO##E   ", "    CC   CC    "};
        FactoryBlockPattern factoryBlockPattern13 = factoryBlockPattern12.aisle(stringArray);
        stringArray = new String[]{"      ICI      ", "    GG###GG    ", "      ICI      "};
        FactoryBlockPattern factoryBlockPattern14 = factoryBlockPattern13.aisle(stringArray);
        stringArray = new String[]{"               ", "      OSO      ", "               "};
        FactoryBlockPattern factoryBlockPattern15 = factoryBlockPattern14.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{this.getCasingState(), this.getGlassState()};
        FactoryBlockPattern factoryBlockPattern16 = factoryBlockPattern15.where('G', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{this.getCasingState(), this.getGlassState()};
        TraceabilityPredicate traceabilityPredicate = RecipeMapMultiblockController.states((IBlockState[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)MetaTileEntities.ENERGY_INPUT_HATCH, (String)"ENERGY_INPUT_HATCH");
        Iterable iterable = ArraysKt.filterNotNull((Object[])MetaTileEntities.ENERGY_INPUT_HATCH);
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate;
        char c = 'E';
        FactoryBlockPattern factoryBlockPattern17 = factoryBlockPattern16;
        boolean $i$f$filter = false;
        void var5_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MetaTileEntityEnergyHatch mte = (MetaTileEntityEnergyHatch)element$iv$iv;
            boolean bl = false;
            if (!(this.tier <= mte.getTier() && mte.getTier() <= 10)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new MetaTileEntityEnergyHatch[0]);
        FactoryBlockPattern factoryBlockPattern18 = factoryBlockPattern17.where(c, traceabilityPredicate2.or(RecipeMapMultiblockController.metaTileEntities((MetaTileEntity[])((MetaTileEntity[])Arrays.copyOf(stringArray, stringArray.length))).setMinGlobalLimited(1).setMaxGlobalLimited(16)));
        stringArray = new IBlockState[]{this.getCasingState()};
        FactoryBlockPattern factoryBlockPattern19 = factoryBlockPattern18.where('C', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{this.getCoilState()};
        FactoryBlockPattern factoryBlockPattern20 = factoryBlockPattern19.where('K', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{this.getCasingState()};
        TraceabilityPredicate traceabilityPredicate3 = RecipeMapMultiblockController.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS};
        FactoryBlockPattern factoryBlockPattern21 = factoryBlockPattern20.where('I', traceabilityPredicate3.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMinGlobalLimited(1)));
        stringArray = new IBlockState[]{this.getCasingState(), this.getGlassState()};
        TraceabilityPredicate traceabilityPredicate4 = RecipeMapMultiblockController.states((IBlockState[])stringArray);
        stringArray = new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS};
        BlockPattern blockPattern = factoryBlockPattern21.where('O', traceabilityPredicate4.or(RecipeMapMultiblockController.abilities((MultiblockAbility[])stringArray).setMinGlobalLimited(1))).where('#', RecipeMapMultiblockController.air()).where(' ', RecipeMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    private final IBlockState getCasingState() {
        return this.tier == 9 ? FusionCasing.MK4.getState() : FusionCasing.MK5.getState();
    }

    private final IBlockState getGlassState() {
        IBlockState iBlockState = MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.FUSION_GLASS);
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getState(...)");
        return iBlockState;
    }

    private final IBlockState getCoilState() {
        return this.tier == 9 ? FusionCoil.ADVANCED.getState() : FusionCoil.ULTIMATE.getState();
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        ICubeRenderer iCubeRenderer;
        if (this.recipeMapWorkable.isActive()) {
            SimpleOverlayRenderer simpleOverlayRenderer = Textures.ACTIVE_FUSION_TEXTURE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"ACTIVE_FUSION_TEXTURE");
            iCubeRenderer = (ICubeRenderer)simpleOverlayRenderer;
        } else {
            SimpleOverlayRenderer simpleOverlayRenderer = Textures.FUSION_TEXTURE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"FUSION_TEXTURE");
            iCubeRenderer = (ICubeRenderer)simpleOverlayRenderer;
        }
        return iCubeRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        OrientedOverlayRenderer orientedOverlayRenderer = Textures.FUSION_REACTOR_OVERLAY;
        Intrinsics.checkNotNullExpressionValue((Object)orientedOverlayRenderer, (String)"FUSION_REACTOR_OVERLAY");
        return (ICubeRenderer)orientedOverlayRenderer;
    }

    @NotNull
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfos = new ArrayList<MultiblockShapeInfo>();
        Object[] objectArray = new RelativeDirection[]{RelativeDirection.LEFT, RelativeDirection.DOWN, RelativeDirection.FRONT};
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder((RelativeDirection[])objectArray);
        objectArray = new String[]{"               ", "      WGW      ", "               "};
        MultiblockShapeInfo.Builder builder2 = builder.aisle((String[])objectArray);
        objectArray = new String[]{"      DCD      ", "    GG   GG    ", "      UCU      "};
        MultiblockShapeInfo.Builder builder3 = builder2.aisle((String[])objectArray);
        objectArray = new String[]{"    CC   CC    ", "   w  EGE  s   ", "    CC   CC    "};
        MultiblockShapeInfo.Builder builder4 = builder3.aisle((String[])objectArray);
        objectArray = new String[]{"   C       C   ", "  nKeG   GeKn  ", "   C       C   "};
        MultiblockShapeInfo.Builder builder5 = builder4.aisle((String[])objectArray);
        objectArray = new String[]{"  C         C  ", " G s       w G ", "  C         C  "};
        MultiblockShapeInfo.Builder builder6 = builder5.aisle((String[])objectArray);
        objectArray = new String[]{"  C         C  ", " G G       G G ", "  C         C  "};
        MultiblockShapeInfo.Builder builder7 = builder6.aisle((String[])objectArray);
        objectArray = new String[]{" D           D ", "N S         N S", " U           U "};
        MultiblockShapeInfo.Builder builder8 = builder7.aisle((String[])objectArray);
        objectArray = new String[]{" C           C ", "G G         G G", " C           C "};
        MultiblockShapeInfo.Builder builder9 = builder8.aisle((String[])objectArray);
        objectArray = new String[]{" D           D ", "N S         N S", " U           U "};
        MultiblockShapeInfo.Builder builder10 = builder9.aisle((String[])objectArray);
        objectArray = new String[]{"  C         C  ", " G G       G G ", "  C         C  "};
        MultiblockShapeInfo.Builder builder11 = builder10.aisle((String[])objectArray);
        objectArray = new String[]{"  C         C  ", " G s       w G ", "  C         C  "};
        MultiblockShapeInfo.Builder builder12 = builder11.aisle((String[])objectArray);
        objectArray = new String[]{"   C       C   ", "  eKnG   GnKe  ", "   C       C   "};
        MultiblockShapeInfo.Builder builder13 = builder12.aisle((String[])objectArray);
        objectArray = new String[]{"    CC   CC    ", "   w  WGW  s   ", "    CC   CC    "};
        MultiblockShapeInfo.Builder builder14 = builder13.aisle((String[])objectArray);
        objectArray = new String[]{"      DCD      ", "    GG   GG    ", "      UCU      "};
        MultiblockShapeInfo.Builder builder15 = builder14.aisle((String[])objectArray);
        objectArray = new String[]{"               ", "      EME      ", "               "};
        MultiblockShapeInfo.Builder builder16 = builder15.aisle((String[])objectArray).where('M', (MetaTileEntity)(this.tier == 9 ? GTLiteMetaTileEntities.INSTANCE.getFUSION_REACTOR_MK4() : GTLiteMetaTileEntities.INSTANCE.getFUSION_REACTOR_MK5()), EnumFacing.SOUTH).where('C', this.getCasingState()).where('G', this.getGlassState()).where('K', this.getCoilState()).where('W', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[this.tier - 1], EnumFacing.NORTH).where('E', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[this.tier - 1], EnumFacing.SOUTH).where('S', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[this.tier - 1], EnumFacing.EAST).where('N', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[this.tier - 1], EnumFacing.WEST).where('w', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.WEST).where('e', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.SOUTH).where('s', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.EAST).where('n', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.NORTH).where('U', (MetaTileEntity)MetaTileEntities.FLUID_IMPORT_HATCH[this.tier - 1], EnumFacing.UP).where('D', (MetaTileEntity)MetaTileEntities.FLUID_IMPORT_HATCH[this.tier - 1], EnumFacing.DOWN);
        shapeInfos.add(builder16.shallowCopy().where('G', this.getCasingState()).build());
        shapeInfos.add(builder16.build());
        return shapeInfos;
    }

    protected void updateFormedValid() {
        EnergyContainerList energyContainerList = this.energyContainers;
        Intrinsics.checkNotNull((Object)energyContainerList);
        if (energyContainerList.getEnergyStored() > 0L) {
            EnergyContainerList energyContainerList2 = this.energyContainers;
            Intrinsics.checkNotNull((Object)energyContainerList2);
            long energyAdded = this.energyContainer.addEnergy(energyContainerList2.getEnergyStored());
            if (energyAdded > 0L) {
                EnergyContainerList energyContainerList3 = this.energyContainers;
                Intrinsics.checkNotNull((Object)energyContainerList3);
                energyContainerList3.removeEnergy(energyAdded);
            }
        }
        super.updateFormedValid();
        if (this.recipeMapWorkable.isWorking() && this.fusionRingColor == this.emptyColor) {
            Recipe previousRecipe = this.recipeMapWorkable.getPreviousRecipe();
            if (previousRecipe != null && !previousRecipe.getFluidOutputs().isEmpty()) {
                this.setFusionRingColor(0xFF000000 | ((FluidStack)previousRecipe.getFluidOutputs().get(0)).getFluid().getColor());
            }
        } else if (!this.recipeMapWorkable.isWorking() && this.isStructureFormed()) {
            this.setFusionRingColor(this.emptyColor);
        }
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.fusionRingColor);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveInitialSyncData(buf);
        this.setFusionRingColor(buf.func_150792_a());
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (dataId == GregtechDataCodes.UPDATE_COLOR) {
            this.setFusionRingColor(buf.func_150792_a());
        } else {
            super.receiveCustomData(dataId, buf);
        }
    }

    public void addInformation(@Nullable ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        long energyCostEach = this.calculateEnergyStorageFactor(16) / 1000000L;
        Object[] objectArray = new Object[]{GTValues.V[this.tier] / (long)16, energyCostEach / (long)16};
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.fusion_reactor.energy_cost", (Object[])objectArray));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.fusion_reactor.recipe_request", (Object[])new Object[0]));
        objectArray = new Object[]{GTValues.VNF[this.tier]};
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.fusion_reactor.tier", (Object[])objectArray));
        tooltip.add(TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.perfect_oc", (Object[])new Object[0]));
    }

    @Nullable
    protected MultiblockUIFactory createUIFactory() {
        UITexture titleTexture = this.tier == 9 ? GTLiteMuiTextures.FUSION_REACTOR_MK4_TITLE : GTLiteMuiTextures.FUSION_REACTOR_MK5_TITLE;
        IDrawable iDrawable = (IDrawable)titleTexture;
        MultiblockWithDisplayBase multiblockWithDisplayBase = (MultiblockWithDisplayBase)this;
        MultiblockRecipeLogic multiblockRecipeLogic = this.recipeMapWorkable;
        Intrinsics.checkNotNullExpressionValue((Object)multiblockRecipeLogic, (String)"recipeMapWorkable");
        return FusionReactorUITemplate.INSTANCE.crateTemplateUI(iDrawable, multiblockWithDisplayBase, multiblockRecipeLogic);
    }

    public int getProgressBarCount() {
        return 2;
    }

    public void registerBars(@NotNull List<UnaryOperator<TemplateBarBuilder>> templateBars, @NotNull PanelSyncManager guiSyncManager) {
        Intrinsics.checkNotNullParameter(templateBars, (String)"templateBars");
        Intrinsics.checkNotNullParameter((Object)guiSyncManager, (String)"guiSyncManager");
        IEnergyContainer iEnergyContainer = this.energyContainer;
        Intrinsics.checkNotNullExpressionValue((Object)iEnergyContainer, (String)"energyContainer");
        FusionReactorUITemplate.INSTANCE.createTemplateBars(templateBars, guiSyncManager, iEnergyContainer, (Function0<Long>)((Function0)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return MultiblockFusionReactor.access$getHeat$p((MultiblockFusionReactor)((Object)this.receiver));
            }

            public void set(Object value) {
                MultiblockFusionReactor.access$setHeat$p((MultiblockFusionReactor)((Object)this.receiver), ((Number)value).longValue());
            }
        }));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(double x, double y, double z, float partialTicks) {
        if (this.fusionRingColor != this.emptyColor && !this.registeredBloomRenderTicket) {
            this.registeredBloomRenderTicket = true;
            BloomEffectUtil.registerBloomRender((IRenderSetup)FusionBloomSetup.INSTANCE, (BloomType)this.getBloomType(), (IBloomEffect)this, (MetaTileEntity)((MetaTileEntity)this));
        }
    }

    private final BloomType getBloomType() {
        ConfigHolder.FusionBloom fusionBloom = ConfigHolder.client.shader.fusionBloom;
        BloomType bloomType = BloomType.fromValue((int)(fusionBloom.useShader ? fusionBloom.bloomStyle : -1));
        Intrinsics.checkNotNullExpressionValue((Object)bloomType, (String)"fromValue(...)");
        return bloomType;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBloomEffect(@NotNull BufferBuilder buffer, @NotNull EffectRenderContext context) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.fusionRingColor != this.emptyColor) {
            int color = RenderUtil.interpolateColor((int)this.fusionRingColor, (int)-1, (float)Eases.QUAD_IN.getInterpolation(Math.abs((float)Math.abs(this.getOffsetTimer() % 50L) + context.partialTicks() - 25.0f) / 25.0f));
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            EnumFacing relativeBack = RelativeDirection.BACK.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
            EnumFacing.Axis axis = RelativeDirection.UP.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped()).func_176740_k();
            buffer.func_181668_a(8, DefaultVertexFormats.field_181706_f);
            RenderBufferHelper.renderRing((BufferBuilder)buffer, (double)((double)this.getPos().func_177958_n() - context.cameraX() + (double)(relativeBack.func_82601_c() * 7) + 0.5), (double)((double)this.getPos().func_177956_o() - context.cameraY() + (double)(relativeBack.func_96559_d() * 7) + 0.5), (double)((double)this.getPos().func_177952_p() - context.cameraZ() + (double)(relativeBack.func_82599_e() * 7) + 0.5), (double)6.0, (double)0.2, (int)10, (int)20, (float)r, (float)g, (float)b, (float)a, (EnumFacing.Axis)axis);
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderBloomEffect(@NotNull EffectRenderContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.fusionRingColor != this.emptyColor && context.camera().func_78546_a(this.getRenderBoundingBox());
    }

    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        EnumFacing relativeRight = RelativeDirection.RIGHT.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing relativeBack = RelativeDirection.BACK.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        return new AxisAlignedBB(this.getPos().func_177972_a(relativeBack).func_177967_a(relativeRight, 6), this.getPos().func_177967_a(relativeBack, 13).func_177967_a(relativeRight.func_176734_d(), 6));
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public boolean isGlobalRenderer() {
        return true;
    }

    public boolean canBeDistinct() {
        return false;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    private static final void _set_fusionRingColor_$lambda$0(MultiblockFusionReactor this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.func_150787_b(this$0.fusionRingColor);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockFusionReactor$FusionRecipeLogic;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockFusionReactor;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "getMaxVoltage", "", "updateWorkable", "", "checkRecipe", "", "recipe", "Lgregtech/api/recipes/Recipe;", "modifyOverclockPre", "ocParams", "Lgregtech/api/recipes/logic/OCParams;", "storage", "Lgregtech/api/recipes/properties/RecipePropertyStorage;", "serializeNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "deserializeNBT", "compound", "gtlitecore"})
    private final class FusionRecipeLogic
    extends MultiblockRecipeLogic {
        public FusionRecipeLogic(RecipeMapMultiblockController mte) {
            Intrinsics.checkNotNullParameter((Object)mte, (String)"mte");
            super(mte, true);
        }

        public long getMaxVoltage() {
            return Math.min(GTValues.V[MultiblockFusionReactor.this.tier], super.getMaxVoltage());
        }

        public void updateWorkable() {
            super.updateWorkable();
            if (MultiblockFusionReactor.this.heat > 0L && (!this.isActive || !this.workingEnabled || this.hasNotEnoughEnergy && this.progressTime == 0)) {
                MultiblockFusionReactor.this.heat = MultiblockFusionReactor.this.heat <= 10000L ? 0L : MultiblockFusionReactor.this.heat - (long)10000;
            }
        }

        public boolean checkRecipe(@NotNull Recipe recipe) {
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            if (!super.checkRecipe(recipe)) {
                return false;
            }
            Object object = recipe.getProperty((RecipeProperty)FusionEUToStartProperty.getInstance(), (Object)0L);
            Intrinsics.checkNotNull((Object)object);
            if (((Number)object).longValue() > this.getEnergyContainer().getEnergyCapacity()) {
                return false;
            }
            Object object2 = recipe.getProperty((RecipeProperty)FusionEUToStartProperty.getInstance(), (Object)0L);
            Intrinsics.checkNotNull((Object)object2);
            long heatDiff = ((Number)object2).longValue() - MultiblockFusionReactor.this.heat;
            if (heatDiff <= 0L) {
                return true;
            }
            if (this.getEnergyContainer().getEnergyStored() < heatDiff) {
                return false;
            }
            this.getEnergyContainer().removeEnergy(heatDiff);
            MultiblockFusionReactor.this.heat = MultiblockFusionReactor.this.heat + heatDiff;
            return true;
        }

        protected void modifyOverclockPre(@NotNull OCParams ocParams, @NotNull RecipePropertyStorage storage) {
            Intrinsics.checkNotNullParameter((Object)ocParams, (String)"ocParams");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            super.modifyOverclockPre(ocParams, storage);
            Object object = storage.get((RecipeProperty)FusionEUToStartProperty.getInstance(), (Object)0L);
            Intrinsics.checkNotNull((Object)object);
            long euToStart = ((Number)object).longValue();
            int fusionTier = FusionEUToStartProperty.getFusionTier((Long)euToStart);
            if (fusionTier != 0) {
                fusionTier = MultiblockFusionReactor.this.tier - fusionTier;
            }
            ocParams.setOcAmount(Math.min(fusionTier, ocParams.ocAmount()));
        }

        @NotNull
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nBTTagCompound = super.serializeNBT();
            Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"serializeNBT(...)");
            NBTTagCompound tag = nBTTagCompound;
            tag.func_74772_a("Heat", MultiblockFusionReactor.this.heat);
            return tag;
        }

        public void deserializeNBT(@NotNull NBTTagCompound compound) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            super.deserializeNBT(compound);
            MultiblockFusionReactor.this.heat = compound.func_74763_f("Heat");
        }
    }
}

