/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.FeCompat;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtechlite.gtlitecore.api.item.GTLiteToolHelper;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.adapter.GTComputerCasing;
import gregtechlite.gtlitecore.common.block.variant.science.ScienceCasing;
import gregtechlite.gtlitecore.common.metatileentity.GTLiteMetaTileEntities;
import gregtechlite.gtlitecore.core.GTLiteConfigHolder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 J2\u00020\u00012\u00020\u0002:\u0001JB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0011\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0017J\b\u0010\u001f\u001a\u00020\u001cH\u0015J3\u0010 \u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0010\u0010%\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010(J\u0012\u0010)\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010+\u0018\u00010*H\u0016J0\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u0001002\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00104\u001a\u00020\u000fH\u0016J\b\u00105\u001a\u00020\u0015H\u0014J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0016J\u0010\u00109\u001a\u00020\u00152\u0006\u00108\u001a\u000207H\u0016J\u0010\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010>\u001a\u00020\u00152\u0006\u0010?\u001a\u00020@2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010C\u001a\u00020\u00152\u0006\u0010D\u001a\u00020\u000fH\u0016J\b\u0010E\u001a\u00020\u000fH\u0016J\u0018\u0010F\u001a\u00020G2\u0006\u0010-\u001a\u00020.2\u0006\u0010H\u001a\u00020GH\u0002J\u0010\u0010I\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockEnergyInfuser;", "Lgregtech/api/metatileentity/multiblock/MultiblockWithDisplayBase;", "Lgregtech/api/capability/IControllable;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "inputInventory", "Lnet/minecraftforge/items/IItemHandlerModifiable;", "outputInventory", "inputFluidInventory", "Lgregtech/api/capability/IMultipleTankHandler;", "energyContainer", "Lgregtech/api/capability/IEnergyContainer;", "isActive", "", "isWorkingEnabled", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "initializeAbilities", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "renderMetaTileEntity", "renderState", "Lcodechicken/lib/render/CCRenderState;", "translation", "Lcodechicken/lib/vec/Matrix4;", "pipeline", "", "Lcodechicken/lib/render/pipeline/IVertexOperation;", "(Lcodechicken/lib/render/CCRenderState;Lcodechicken/lib/vec/Matrix4;[Lcodechicken/lib/render/pipeline/IVertexOperation;)V", "getMatchingShapes", "", "Lgregtech/api/pattern/MultiblockShapeInfo;", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "updateFormedValid", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "data", "readFromNBT", "writeInitialSyncData", "buf", "Lnet/minecraft/network/PacketBuffer;", "receiveInitialSyncData", "receiveCustomData", "dataId", "", "setActive", "active", "setWorkingEnabled", "workingEnabled", "hasMaintenanceMechanics", "chargeItem", "", "energy", "isItemFullyCharged", "Companion", "gtlitecore"})
public final class MultiblockEnergyInfuser
extends MultiblockWithDisplayBase
implements IControllable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private IItemHandlerModifiable inputInventory;
    @Nullable
    private IItemHandlerModifiable outputInventory;
    @Nullable
    private IMultipleTankHandler inputFluidInventory;
    @Nullable
    private IEnergyContainer energyContainer;
    private boolean isActive;
    private boolean isWorkingEnabled;
    @NotNull
    private static final IBlockState casingState = GTComputerCasing.HIGH_POWER_CASING.getState();
    @NotNull
    private static final IBlockState secondCasingState = ScienceCasing.MOLECULAR_CASING.getState();
    @NotNull
    private static final IBlockState coilState = ScienceCasing.MOLECULAR_COIL.getState();

    public MultiblockEnergyInfuser(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id);
    }

    @NotNull
    public MultiblockEnergyInfuser createMetaTileEntity(@Nullable IGregTechTileEntity tileEntity) {
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockEnergyInfuser(resourceLocation);
    }

    protected void formStructure(@Nullable PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    private final void initializeAbilities() {
        this.inputInventory = (IItemHandlerModifiable)new ItemHandlerList(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.outputInventory = (IItemHandlerModifiable)new ItemHandlerList(this.getAbilities(MultiblockAbility.EXPORT_ITEMS));
        this.inputFluidInventory = (IMultipleTankHandler)new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        List inputEnergy = this.getAbilities(MultiblockAbility.INPUT_ENERGY);
        this.energyContainer = (IEnergyContainer)new EnergyContainerList(inputEnergy);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"CCC", "MMM", "DDD", "MMM", "CCC"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"CCC", "MDM", "DDD", "MDM", "CCC"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"CCC", "MMM", "DSD", "MMM", "CCC"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        TraceabilityPredicate traceabilityPredicate = MultiblockWithDisplayBase.states((IBlockState[])stringArray).setMinGlobalLimited(9);
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY};
        TraceabilityPredicate traceabilityPredicate2 = traceabilityPredicate.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setMaxGlobalLimited(4).setPreviewCount(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.INPUT_LASER};
        TraceabilityPredicate traceabilityPredicate3 = traceabilityPredicate2.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setMaxGlobalLimited(1).setPreviewCount(0));
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS};
        TraceabilityPredicate traceabilityPredicate4 = traceabilityPredicate3.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setPreviewCount(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS};
        TraceabilityPredicate traceabilityPredicate5 = traceabilityPredicate4.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setPreviewCount(1));
        stringArray = new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.where('C', traceabilityPredicate5.or(MultiblockWithDisplayBase.abilities((MultiblockAbility[])stringArray).setPreviewCount(0)));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.where('D', MultiblockWithDisplayBase.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{coilState};
        BlockPattern blockPattern = factoryBlockPattern5.where('M', MultiblockWithDisplayBase.states((IBlockState[])stringArray)).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        ICubeRenderer iCubeRenderer;
        if (sourcePart == null) {
            iCubeRenderer = (ICubeRenderer)GTLiteOverlays.MOLECULAR_CASING;
        } else {
            SimpleOverlayRenderer simpleOverlayRenderer = Textures.HIGH_POWER_CASING;
            Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"HIGH_POWER_CASING");
            iCubeRenderer = (ICubeRenderer)simpleOverlayRenderer;
        }
        return iCubeRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        OrientedOverlayRenderer orientedOverlayRenderer = Textures.DATA_BANK_OVERLAY;
        Intrinsics.checkNotNullExpressionValue((Object)orientedOverlayRenderer, (String)"DATA_BANK_OVERLAY");
        return (ICubeRenderer)orientedOverlayRenderer;
    }

    public void renderMetaTileEntity(@Nullable CCRenderState renderState, @Nullable Matrix4 translation, @Nullable IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.isWorkingEnabled());
    }

    @Nullable
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfos = new ArrayList<MultiblockShapeInfo>();
        Object[] objectArray = new RelativeDirection[]{RelativeDirection.LEFT, RelativeDirection.DOWN, RelativeDirection.FRONT};
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder((RelativeDirection[])objectArray);
        objectArray = new String[]{"CEC", "MMM", "DDD", "MMM", "CCC"};
        MultiblockShapeInfo.Builder builder2 = builder.aisle((String[])objectArray);
        objectArray = new String[]{"CCC", "MDM", "DDD", "MDM", "CCC"};
        MultiblockShapeInfo.Builder builder3 = builder2.aisle((String[])objectArray);
        objectArray = new String[]{"ICJ", "MMM", "DSD", "MMM", "CCC"};
        MultiblockShapeInfo builder4 = builder3.aisle((String[])objectArray).where('S', (MetaTileEntity)GTLiteMetaTileEntities.INSTANCE.getENERGY_INFUSER(), EnumFacing.SOUTH).where('C', casingState).where('D', secondCasingState).where('M', coilState).where('E', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[0], EnumFacing.NORTH).where('I', (MetaTileEntity)MetaTileEntities.ITEM_IMPORT_BUS[0], EnumFacing.SOUTH).where('J', (MetaTileEntity)MetaTileEntities.ITEM_EXPORT_BUS[0], EnumFacing.SOUTH).build();
        shapeInfos.add(builder4);
        return shapeInfos;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addInformation(stack, world, tooltip, advanced);
        String string = I18n.func_135052_a((String)"gtlitecore.machine.energy_infuser.tooltip.1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"gtlitecore.machine.energy_infuser.tooltip.2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        tooltip.add(string2);
        String string3 = I18n.func_135052_a((String)"gtlitecore.machine.energy_infuser.tooltip.3", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        tooltip.add(string3);
    }

    protected void updateFormedValid() {
        if (!this.isWorkingEnabled || this.getWorld() == null || this.getWorld().field_72995_K) {
            return;
        }
        boolean itemProcessed = false;
        IItemHandlerModifiable iItemHandlerModifiable = this.inputInventory;
        Intrinsics.checkNotNull((Object)iItemHandlerModifiable);
        int n = iItemHandlerModifiable.getSlots();
        for (int i = 0; i < n; ++i) {
            ItemStack stackInSlot;
            IEnergyContainer iEnergyContainer = this.energyContainer;
            Intrinsics.checkNotNull((Object)iEnergyContainer);
            long energyAvailable = iEnergyContainer.getEnergyStored();
            if (energyAvailable < 1L) break;
            IItemHandlerModifiable iItemHandlerModifiable2 = this.inputInventory;
            Intrinsics.checkNotNull((Object)iItemHandlerModifiable2);
            Intrinsics.checkNotNullExpressionValue((Object)iItemHandlerModifiable2.getStackInSlot(i), (String)"getStackInSlot(...)");
            if (stackInSlot.func_190926_b()) continue;
            boolean isCharged = this.isItemFullyCharged(stackInSlot);
            boolean isRepaired = GTLiteToolHelper.isItemHasFullDurability(stackInSlot);
            if (isCharged && isRepaired) {
                IItemHandlerModifiable iItemHandlerModifiable3 = this.inputInventory;
                Intrinsics.checkNotNull((Object)iItemHandlerModifiable3);
                stackInSlot = iItemHandlerModifiable3.extractItem(i, 1, true);
                IItemHandlerModifiable iItemHandlerModifiable4 = this.outputInventory;
                Intrinsics.checkNotNull((Object)iItemHandlerModifiable4);
                if (iItemHandlerModifiable4.getSlots() > 0 && GTTransferUtils.insertItem((IItemHandler)((IItemHandler)this.outputInventory), (ItemStack)stackInSlot, (boolean)true).func_190926_b()) {
                    IItemHandlerModifiable iItemHandlerModifiable5 = this.inputInventory;
                    Intrinsics.checkNotNull((Object)iItemHandlerModifiable5);
                    stackInSlot = iItemHandlerModifiable5.extractItem(i, 1, false);
                    GTTransferUtils.insertItem((IItemHandler)((IItemHandler)this.outputInventory), (ItemStack)stackInSlot, (boolean)false);
                } else if (this.getVoidingMode() == 1 || this.getVoidingMode() == 3) {
                    IItemHandlerModifiable iItemHandlerModifiable6 = this.inputInventory;
                    Intrinsics.checkNotNull((Object)iItemHandlerModifiable6);
                    iItemHandlerModifiable6.extractItem(i, 1, false);
                }
            }
            if (!isCharged) {
                long energyUsed = this.chargeItem(stackInSlot, energyAvailable);
                if (!itemProcessed) {
                    boolean bl = itemProcessed = energyUsed > 0L;
                }
            }
            if (isRepaired) continue;
            IMultipleTankHandler iMultipleTankHandler = this.inputFluidInventory;
            Intrinsics.checkNotNull((Object)iMultipleTankHandler);
            if (iMultipleTankHandler.getTanks() <= 0) continue;
            IEnergyContainer iEnergyContainer2 = this.energyContainer;
            Intrinsics.checkNotNull((Object)iEnergyContainer2);
            energyAvailable = iEnergyContainer2.getEnergyStored();
            int toRepair = Math.min(stackInSlot.func_77952_i(), GTLiteConfigHolder.machine.energyInfuser.maxRepairedDamagePerWorking);
            long powerCost = (long)toRepair * (long)GTLiteConfigHolder.machine.energyInfuser.energyConsumedPerDurability;
            FluidStack toDrain = new FluidStack(Materials.UUMatter.getFluid(), toRepair * GTLiteConfigHolder.machine.energyInfuser.uuMatterConsumedPerDurability);
            if (energyAvailable <= powerCost) continue;
            IMultipleTankHandler iMultipleTankHandler2 = this.inputFluidInventory;
            Intrinsics.checkNotNull((Object)iMultipleTankHandler2);
            if (iMultipleTankHandler2.drain(toDrain, false) == null) continue;
            stackInSlot.func_77964_b(Math.max(stackInSlot.func_77952_i() - toRepair, 0));
            IMultipleTankHandler iMultipleTankHandler3 = this.inputFluidInventory;
            Intrinsics.checkNotNull((Object)iMultipleTankHandler3);
            iMultipleTankHandler3.drain(toDrain, true);
            IEnergyContainer iEnergyContainer3 = this.energyContainer;
            Intrinsics.checkNotNull((Object)iEnergyContainer3);
            iEnergyContainer3.removeEnergy(powerCost);
            itemProcessed = true;
        }
        if (itemProcessed != this.isActive()) {
            this.setActive(itemProcessed);
        }
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.writeToNBT(data);
        data.func_74757_a("isWorkingEnabled", this.isWorkingEnabled);
        return data;
    }

    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.readFromNBT(data);
        this.isWorkingEnabled = data.func_74767_n("isWorkingEnabled");
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isWorkingEnabled);
        buf.writeBoolean(this.isActive);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveInitialSyncData(buf);
        this.isWorkingEnabled = buf.readBoolean();
        this.isActive = buf.readBoolean();
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    public boolean isActive() {
        return super.isActive() && this.isActive;
    }

    public final void setActive(boolean active) {
        this.isActive = active;
        this.markDirty();
        this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, arg_0 -> MultiblockEnergyInfuser.setActive$lambda$0(this, arg_0));
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        this.isWorkingEnabled = workingEnabled;
        this.markDirty();
        this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, arg_0 -> MultiblockEnergyInfuser.setWorkingEnabled$lambda$1(this, arg_0));
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    private final long chargeItem(ItemStack stack, long energy) {
        IEnergyContainer iEnergyContainer = this.energyContainer;
        Intrinsics.checkNotNull((Object)iEnergyContainer);
        long l = iEnergyContainer.getInputVoltage();
        IEnergyContainer iEnergyContainer2 = this.energyContainer;
        Intrinsics.checkNotNull((Object)iEnergyContainer2);
        long energyAvailable = Math.min(energy, l * iEnergyContainer2.getInputAmperage());
        if (stack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) {
            IElectricItem item = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (item == null) {
                return 0L;
            }
            IEnergyContainer iEnergyContainer3 = this.energyContainer;
            Intrinsics.checkNotNull((Object)iEnergyContainer3);
            return item.charge(energyAvailable, (int)GTUtility.getFloorTierByVoltage((long)iEnergyContainer3.getInputVoltage()), true, false);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (storage == null) {
                return 0L;
            }
            return FeCompat.insertEu((IEnergyStorage)storage, (long)energyAvailable);
        }
        return 0L;
    }

    private final boolean isItemFullyCharged(ItemStack stack) {
        if (stack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) {
            IElectricItem item = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (item == null || !item.chargeable()) {
                return true;
            }
            return item.getCharge() >= item.getMaxCharge();
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (storage == null || !storage.canReceive()) {
                return true;
            }
            return storage.getEnergyStored() >= storage.getMaxEnergyStored();
        }
        return true;
    }

    private static final void setActive$lambda$0(MultiblockEnergyInfuser this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.isActive);
    }

    private static final void setWorkingEnabled$lambda$1(MultiblockEnergyInfuser this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.isWorkingEnabled);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockEnergyInfuser$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "secondCasingState", "coilState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

