/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock;

import gregtech.api.block.VariantActiveBlock;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.BlockWorldState;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.unification.material.Material;
import gregtech.api.util.BlockInfo;
import gregtech.client.renderer.ICubeRenderer;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeProperties;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import gregtechlite.gtlitecore.client.renderer.texture.GTLiteOverlays;
import gregtechlite.gtlitecore.common.block.adapter.GTFusionCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import gregtechlite.gtlitecore.common.block.variant.MultiblockCasing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0002./B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014J%\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001b\"\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0017J\b\u0010\"\u001a\u00020\u001fH\u0015J0\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020,H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockCosmicRayDetector;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "emitterCasingTier", "", "sensorCasingTier", "fieldGenCasingTier", "processorCasingTier", "tier", "topBlockPos", "Lnet/minecraft/util/math/BlockPos;", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "minHeightPredicate", "Lgregtech/api/pattern/TraceabilityPredicate;", "allowedStates", "", "Lnet/minecraft/block/state/IBlockState;", "([Lnet/minecraft/block/state/IBlockState;)Lgregtech/api/pattern/TraceabilityPredicate;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "canBeDistinct", "Companion", "CosmicRayDetectorWorkableHandler", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nMultiblockCosmicRayDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiblockCosmicRayDetector.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockCosmicRayDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,173:1\n11158#2:174\n11493#2,3:175\n37#3:178\n36#3,3:179\n*S KotlinDebug\n*F\n+ 1 MultiblockCosmicRayDetector.kt\ngregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockCosmicRayDetector\n*L\n132#1:174\n132#1:175,3\n132#1:178\n132#1:179,3\n*E\n"})
public final class MultiblockCosmicRayDetector
extends RecipeMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int emitterCasingTier;
    private int sensorCasingTier;
    private int fieldGenCasingTier;
    private int processorCasingTier;
    private int tier;
    @NotNull
    private BlockPos topBlockPos;
    @NotNull
    private static final IBlockState casingState = MetalCasing.QUANTUM_ALLOY.getState();
    @NotNull
    private static final IBlockState secondCasingState = MultiblockCasing.REFLECTIVE_SURFACE_CASING.getState();
    @NotNull
    private static final IBlockState coilState = GTFusionCasing.SUPERCONDUCTOR_COIL.getState();

    public MultiblockCosmicRayDetector(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, GTLiteRecipeMaps.COSMIC_RAY_DETECTING_RECIPES);
        this.topBlockPos = new BlockPos(0, -64, 0);
        this.recipeMapWorkable = new CosmicRayDetectorWorkableHandler(this);
    }

    @NotNull
    public MultiblockCosmicRayDetector createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockCosmicRayDetector(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.formStructure(context);
        this.emitterCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.EMITTER_CASING_TIER, 0)).intValue();
        this.sensorCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.SENSOR_CASING_TIER, 0)).intValue();
        this.fieldGenCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.FIELD_GEN_CASING_TIER, 0)).intValue();
        this.processorCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.PROCESSOR_CASING_TIER, 0)).intValue();
        int[] nArray = new int[]{this.sensorCasingTier, this.fieldGenCasingTier, this.processorCasingTier};
        this.tier = ComparisonsKt.minOf((int)this.emitterCasingTier, (int[])nArray);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.emitterCasingTier = 0;
        this.sensorCasingTier = 0;
        this.fieldGenCasingTier = 0;
        this.processorCasingTier = 0;
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      DDD      ", "               "};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"               ", "               ", "               ", "               ", "               ", "               ", "               ", "      DDD      ", "    DD   DD    ", "               "};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"               ", "               ", "               ", "               ", "               ", "               ", "       D       ", "    DDD DDD    ", "   D       D   ", "               "};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"      CCC      ", "      CCC      ", "      CCC      ", "               ", "               ", "       C       ", "     DDDDD     ", "   DD     DD   ", "  D         D  ", "               "};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"     CCCCC     ", "     C###C     ", "     C###C     ", "      CCC      ", "      CCC      ", "     CCCCC     ", "    DDDDDDD    ", "  DD       DD  ", " D           D ", "               "};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"    CCCCCCC    ", "    C#####C    ", "    C#####C    ", "     C###C     ", "     C###C     ", "    CCDDDCC    ", "   DDD   DDD   ", "  D         D  ", " D           D ", "               "};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{"   CCCCCCCCC   ", "   C###E###C   ", "   C#######C   ", "    C#####C    ", "    C##F##C    ", "    CDDDDDC    ", "   DD     DD   ", " DD         DD ", "D             D", "       *       "};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray);
        stringArray = new String[]{"   CCCCCCCCC   ", "   C##ExE##C   ", "   C###c###C   ", "    C##c##C    ", "    C#FxF#C    ", "   CCDDEDDCC   ", "  DDD  f  DDD  ", " D     f     D ", "D      f      D", "      *s*      "};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.aisle(stringArray);
        stringArray = new String[]{"   CCCCCCCCC   ", "   C###E###C   ", "   C#######C   ", "    C#####C    ", "    C##F##C    ", "    CDDDDDC    ", "   DD     DD   ", " DD         DD ", "D             D", "       *       "};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.aisle(stringArray);
        stringArray = new String[]{"    CCCCCCC    ", "    C#####C    ", "    C#####C    ", "     C###C     ", "     C###C     ", "    CCDDDCC    ", "   DDD   DDD   ", "  D         D  ", " D           D ", "               "};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.aisle(stringArray);
        stringArray = new String[]{"     CCCCC     ", "     C###C     ", "     C###C     ", "      CCC      ", "      CCC      ", "     CCCCC     ", "    DDDDDDD    ", "  DD       DD  ", " D           D ", "               "};
        FactoryBlockPattern factoryBlockPattern11 = factoryBlockPattern10.aisle(stringArray);
        stringArray = new String[]{"      CCC      ", "      CSC      ", "      CCC      ", "               ", "               ", "       C       ", "     DDDDD     ", "   DD     DD   ", "  D         D  ", "               "};
        FactoryBlockPattern factoryBlockPattern12 = factoryBlockPattern11.aisle(stringArray);
        stringArray = new String[]{"               ", "               ", "               ", "               ", "               ", "               ", "       D       ", "    DDD DDD    ", "   D       D   ", "               "};
        FactoryBlockPattern factoryBlockPattern13 = factoryBlockPattern12.aisle(stringArray);
        stringArray = new String[]{"               ", "               ", "               ", "               ", "               ", "               ", "               ", "      DDD      ", "    DD   DD    ", "               "};
        FactoryBlockPattern factoryBlockPattern14 = factoryBlockPattern13.aisle(stringArray);
        stringArray = new String[]{"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      DDD      ", "               "};
        FactoryBlockPattern factoryBlockPattern15 = factoryBlockPattern14.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern16 = factoryBlockPattern15.where('C', RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(148).or(this.autoAbilities()));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern17 = factoryBlockPattern16.where('D', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{coilState};
        FactoryBlockPattern factoryBlockPattern18 = factoryBlockPattern17.where('c', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new Material[]{GTLiteMaterials.INSTANCE.getHDCS()};
        FactoryBlockPattern factoryBlockPattern19 = factoryBlockPattern18.where('f', RecipeMapMultiblockController.frames((Material[])stringArray)).where('E', TraceabilityPredicates.emitterCasings()).where('F', TraceabilityPredicates.fieldGenCasings()).where('s', TraceabilityPredicates.sensorCasings()).where('x', TraceabilityPredicates.processorCasings());
        stringArray = new IBlockState[]{Blocks.field_150350_a.func_176223_P()};
        BlockPattern blockPattern = factoryBlockPattern19.where('*', this.minHeightPredicate((IBlockState[])stringArray)).where('#', RecipeMapMultiblockController.air()).where(' ', RecipeMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    private final TraceabilityPredicate minHeightPredicate(IBlockState ... allowedStates) {
        return new TraceabilityPredicate(arg_0 -> MultiblockCosmicRayDetector.minHeightPredicate$lambda$0(this, allowedStates, arg_0), () -> MultiblockCosmicRayDetector.minHeightPredicate$lambda$2(allowedStates));
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        return (ICubeRenderer)GTLiteOverlays.QUANTUM_ALLOY_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return (ICubeRenderer)GTLiteOverlays.COSMIC_RAY_DETECTOR_OVERLAY;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockCosmicRayDetector::addInformation$lambda$3));
    }

    public boolean canBeDistinct() {
        return false;
    }

    private static final boolean minHeightPredicate$lambda$0(MultiblockCosmicRayDetector this$0, IBlockState[] $allowedStates, BlockWorldState blockWorldState) {
        Intrinsics.checkNotNullParameter((Object)blockWorldState, (String)"blockWorldState");
        this$0.topBlockPos = blockWorldState.getPos();
        IBlockState iBlockState = blockWorldState.getBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getBlockState(...)");
        IBlockState state = iBlockState;
        if (state.func_177230_c() instanceof VariantActiveBlock) {
            ((LinkedList)blockWorldState.getMatchContext().getOrPut("VABlock", new LinkedList())).add(blockWorldState.getPos());
        }
        return ArraysKt.contains((Object[])$allowedStates, (Object)state);
    }

    /*
     * WARNING - void declaration
     */
    private static final BlockInfo[] minHeightPredicate$lambda$2(IBlockState[] $allowedStates) {
        void $this$mapTo$iv$iv;
        IBlockState[] $this$map$iv = $allowedStates;
        boolean $i$f$map = false;
        IBlockState[] iBlockStateArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new BlockInfo((IBlockState)it, null));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new BlockInfo[0]);
    }

    private static final Unit addInformation$lambda$3(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("CRD");
        String[] stringArray = new String[]{"gtlitecore.machine.cosmic_ray_detector.tooltip.1"};
        $this$addTooltip.description(true, stringArray);
        $this$addTooltip.overclockInfo(-1);
        stringArray = new String[]{"gtlitecore.machine.cosmic_ray_detector.tooltip.2", "gtlitecore.machine.cosmic_ray_detector.tooltip.3"};
        $this$addTooltip.description(false, stringArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockCosmicRayDetector$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "secondCasingState", "coilState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockCosmicRayDetector$CosmicRayDetectorWorkableHandler;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockCosmicRayDetector;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "checkRecipe", "", "recipe", "Lgregtech/api/recipes/Recipe;", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class CosmicRayDetectorWorkableHandler
    extends MultiblockRecipeLogic {
        public CosmicRayDetectorWorkableHandler(RecipeMapMultiblockController mte) {
            super(mte, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean checkRecipe(@NotNull Recipe recipe) {
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            if (!super.checkRecipe(recipe)) return false;
            Object object = recipe.getProperty(GTLiteRecipeProperties.INSTANCE.getMINIMUM_HEIGHT(), (Object)-64);
            Intrinsics.checkNotNull((Object)object);
            if (((Number)object).intValue() > MultiblockCosmicRayDetector.this.topBlockPos.func_177956_o()) return false;
            return true;
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.5, Math.min(MultiblockCosmicRayDetector.this.sensorCasingTier, MultiblockCosmicRayDetector.this.processorCasingTier))));
        }

        public int getParallelLimit() {
            return 32 * Math.min(MultiblockCosmicRayDetector.this.emitterCasingTier, MultiblockCosmicRayDetector.this.fieldGenCasingTier);
        }
    }
}

