/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.metatileentity.multiblock;

import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.BlockWorldState;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.unification.material.Material;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtechlite.gtlitecore.api.GTLiteAPI;
import gregtechlite.gtlitecore.api.extension.IBlockStateExtKt;
import gregtechlite.gtlitecore.api.pattern.TraceabilityPredicates;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.translation.MultiblockTooltipDSL;
import gregtechlite.gtlitecore.api.translation.UpgradeType;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import gregtechlite.gtlitecore.common.block.adapter.GTMetalCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTMultiblockCasing;
import gregtechlite.gtlitecore.common.block.adapter.GTTurbineCasing;
import gregtechlite.gtlitecore.common.block.variant.MetalCasing;
import gregtechlite.gtlitecore.common.block.variant.MultiblockCasing;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0002*+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0017J\b\u0010\u001d\u001a\u00020\u001aH\u0015J0\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020'H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockBedrockDrillingRig;", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "id", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "pistonCasingTier", "", "motorCasingTier", "tier", "targetBlock", "Lnet/minecraft/util/math/BlockPos;", "createMetaTileEntity", "tileEntity", "Lgregtech/api/metatileentity/interfaces/IGregTechTileEntity;", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "invalidateStructure", "initializeAbilities", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "blockPredicate", "Lgregtech/api/pattern/TraceabilityPredicate;", "getBaseTexture", "Lgregtech/client/renderer/ICubeRenderer;", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "getFrontOverlay", "addInformation", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "advanced", "", "canBeDistinct", "hasMufflerMechanics", "Companion", "BedrockDrillingRigWorkableHandler", "gtlitecore"})
public final class MultiblockBedrockDrillingRig
extends RecipeMapMultiblockController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int pistonCasingTier;
    private int motorCasingTier;
    private int tier;
    @Nullable
    private BlockPos targetBlock;
    @NotNull
    private static final IBlockState casingState = MetalCasing.TRINAQUADALLOY.getState();
    @NotNull
    private static final IBlockState secondCasingState = GTMetalCasing.STEEL_SOLID.getState();
    @NotNull
    private static final IBlockState gearboxCasingState = GTTurbineCasing.TUNGSTENSTEEL_GEARBOX.getState();
    @NotNull
    private static final IBlockState thirdCasingState = MultiblockCasing.DRILL_HEAD.getState();
    @NotNull
    private static final IBlockState fourthCasingState = GTMultiblockCasing.GRATE_CASING.getState();

    public MultiblockBedrockDrillingRig(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(id, GTLiteRecipeMaps.DRILLING_RECIPES);
        this.recipeMapWorkable = new BedrockDrillingRigWorkableHandler(this);
    }

    @NotNull
    public MultiblockBedrockDrillingRig createMetaTileEntity(@NotNull IGregTechTileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        ResourceLocation resourceLocation = this.metaTileEntityId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"metaTileEntityId");
        return new MultiblockBedrockDrillingRig(resourceLocation);
    }

    protected void formStructure(@NotNull PatternMatchContext context) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super.formStructure(context);
            this.pistonCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.PISTON_CASING_TIER, 0)).intValue();
            this.motorCasingTier = ((Number)TraceabilityPredicates.getAttributeOrDefault(context, GTLiteAPI.MOTOR_CASING_TIER, 0)).intValue();
            this.tier = Math.min(this.pistonCasingTier, this.motorCasingTier);
            BlockPos blockPos = this.targetBlock;
            if (blockPos == null) break block0;
            BlockPos it = blockPos;
            boolean bl = false;
            IBlockState iBlockState = this.getWorld().func_180495_p(it);
            Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getBlockState(...)");
            this.inputInventory.setStackInSlot(0, IBlockStateExtKt.toItem$default(iBlockState, 0, 1, null));
        }
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.pistonCasingTier = 0;
        this.motorCasingTier = 0;
        this.targetBlock = null;
    }

    protected void initializeAbilities() {
        super.initializeAbilities();
        this.inputInventory = (IItemHandlerModifiable)new NotifiableItemStackHandler((MetaTileEntity)this, 1, (MetaTileEntity)this, false);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        String[] stringArray = new String[]{"       ", "XXXXXXX", "X     X", "X     X", "X     X", "X     X", "X     X", "XXXXXXX"};
        FactoryBlockPattern factoryBlockPattern = FactoryBlockPattern.start().aisle(stringArray);
        stringArray = new String[]{"       ", "X     X", "       ", " F   F ", "       ", "       ", "       ", "X  F  X"};
        FactoryBlockPattern factoryBlockPattern2 = factoryBlockPattern.aisle(stringArray);
        stringArray = new String[]{"       ", "X     X", "   C   ", "  FCF  ", "   C   ", "  CVC  ", "  CVC  ", "X BBB X"};
        FactoryBlockPattern factoryBlockPattern3 = factoryBlockPattern2.aisle(stringArray);
        stringArray = new String[]{"   R   ", "X  D  X", "  COC  ", "  CQC  ", "  CGC  ", "  VGV  ", "  VGV  ", "XFBBBFX"};
        FactoryBlockPattern factoryBlockPattern4 = factoryBlockPattern3.aisle(stringArray);
        stringArray = new String[]{"       ", "X     X", "   C   ", "  FCF  ", "   C   ", "  CSC  ", "  CVC  ", "X BBB X"};
        FactoryBlockPattern factoryBlockPattern5 = factoryBlockPattern4.aisle(stringArray);
        stringArray = new String[]{"       ", "X     X", "       ", " F   F ", "       ", "       ", "       ", "X  F  X"};
        FactoryBlockPattern factoryBlockPattern6 = factoryBlockPattern5.aisle(stringArray);
        stringArray = new String[]{"       ", "XXXXXXX", "X     X", "X     X", "X     X", "X     X", "X     X", "XXXXXXX"};
        FactoryBlockPattern factoryBlockPattern7 = factoryBlockPattern6.aisle(stringArray).where('S', this.selfPredicate());
        stringArray = new IBlockState[]{casingState};
        FactoryBlockPattern factoryBlockPattern8 = factoryBlockPattern7.where('X', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern9 = factoryBlockPattern8.where('B', RecipeMapMultiblockController.states((IBlockState[])stringArray).setMinGlobalLimited(4).or(this.autoAbilities(true, true, false, true, false, true, true)));
        stringArray = new IBlockState[]{secondCasingState};
        FactoryBlockPattern factoryBlockPattern10 = factoryBlockPattern9.where('C', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{thirdCasingState};
        FactoryBlockPattern factoryBlockPattern11 = factoryBlockPattern10.where('D', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new Material[]{GTLiteMaterials.INSTANCE.getHSLASteel()};
        FactoryBlockPattern factoryBlockPattern12 = factoryBlockPattern11.where('F', RecipeMapMultiblockController.frames((Material[])stringArray));
        stringArray = new IBlockState[]{gearboxCasingState};
        FactoryBlockPattern factoryBlockPattern13 = factoryBlockPattern12.where('G', RecipeMapMultiblockController.states((IBlockState[])stringArray));
        stringArray = new IBlockState[]{fourthCasingState};
        BlockPattern blockPattern = factoryBlockPattern13.where('V', RecipeMapMultiblockController.states((IBlockState[])stringArray)).where('O', TraceabilityPredicates.pistonCasings()).where('Q', TraceabilityPredicates.motorCasings()).where('R', this.blockPredicate()).where(' ', RecipeMapMultiblockController.any()).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockPattern, (String)"build(...)");
        return blockPattern;
    }

    private final TraceabilityPredicate blockPredicate() {
        return new TraceabilityPredicate(arg_0 -> MultiblockBedrockDrillingRig.blockPredicate$lambda$1(this, arg_0));
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(@Nullable IMultiblockPart sourcePart) {
        SimpleOverlayRenderer simpleOverlayRenderer = Textures.SOLID_STEEL_CASING;
        Intrinsics.checkNotNullExpressionValue((Object)simpleOverlayRenderer, (String)"SOLID_STEEL_CASING");
        return (ICubeRenderer)simpleOverlayRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        OrientedOverlayRenderer orientedOverlayRenderer = Textures.PROCESSING_ARRAY_OVERLAY;
        Intrinsics.checkNotNullExpressionValue((Object)orientedOverlayRenderer, (String)"PROCESSING_ARRAY_OVERLAY");
        return (ICubeRenderer)orientedOverlayRenderer;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MultiblockTooltipDSL.Companion.addTooltip((MultiblockWithDisplayBase)this, tooltip, (Function1<? super MultiblockTooltipDSL, Unit>)((Function1)MultiblockBedrockDrillingRig::addInformation$lambda$2));
    }

    public boolean canBeDistinct() {
        return false;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    private static final boolean blockPredicate$lambda$1(MultiblockBedrockDrillingRig this$0, BlockWorldState blockWorldState) {
        Intrinsics.checkNotNullParameter((Object)blockWorldState, (String)"blockWorldState");
        this$0.targetBlock = blockWorldState.getPos();
        if (this$0.isStructureFormed()) {
            IItemHandlerModifiable iItemHandlerModifiable = this$0.inputInventory;
            World world = this$0.getWorld();
            BlockPos blockPos = this$0.targetBlock;
            Intrinsics.checkNotNull((Object)blockPos);
            IBlockState iBlockState = world.func_180495_p(blockPos);
            Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getBlockState(...)");
            iItemHandlerModifiable.setStackInSlot(0, IBlockStateExtKt.toItem$default(iBlockState, 0, 1, null));
        }
        return true;
    }

    private static final Unit addInformation$lambda$2(MultiblockTooltipDSL $this$addTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$addTooltip, (String)"$this$addTooltip");
        $this$addTooltip.machineType("BDR");
        String[] stringArray = new String[]{"gtlitecore.machine.bedrock_drilling_rig.tooltip.1", "gtlitecore.machine.bedrock_drilling_rig.tooltip.2", "gtlitecore.machine.bedrock_drilling_rig.tooltip.3"};
        $this$addTooltip.description(true, stringArray);
        $this$addTooltip.overclockInfo(-1);
        $this$addTooltip.durationInfo(UpgradeType.MOTOR_CASING, 80);
        $this$addTooltip.parallelInfo(UpgradeType.PISTON_CASING, 16);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockBedrockDrillingRig$BedrockDrillingRigWorkableHandler;", "Lgregtech/api/capability/impl/MultiblockRecipeLogic;", "mte", "Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;", "<init>", "(Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockBedrockDrillingRig;Lgregtech/api/metatileentity/multiblock/RecipeMapMultiblockController;)V", "getMetaTileEntity", "Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockBedrockDrillingRig;", "setupAndConsumeRecipeInputs", "Lgregtech/api/recipes/Recipe;", "recipe", "importInventory", "Lnet/minecraftforge/items/IItemHandlerModifiable;", "setMaxProgress", "", "maxProgress", "", "getParallelLimit", "gtlitecore"})
    private final class BedrockDrillingRigWorkableHandler
    extends MultiblockRecipeLogic {
        public BedrockDrillingRigWorkableHandler(RecipeMapMultiblockController mte) {
            super(mte, true);
        }

        @NotNull
        public MultiblockBedrockDrillingRig getMetaTileEntity() {
            MetaTileEntity metaTileEntity = super.getMetaTileEntity();
            Intrinsics.checkNotNull((Object)metaTileEntity, (String)"null cannot be cast to non-null type gregtechlite.gtlitecore.common.metatileentity.multiblock.MultiblockBedrockDrillingRig");
            return (MultiblockBedrockDrillingRig)metaTileEntity;
        }

        @Nullable
        protected Recipe setupAndConsumeRecipeInputs(@NotNull Recipe recipe, @NotNull IItemHandlerModifiable importInventory) {
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)importInventory, (String)"importInventory");
            if (!((GTRecipeInput)recipe.getInputs().get(0)).isNonConsumable()) {
                MultiblockBedrockDrillingRig mte = this.getMetaTileEntity();
                if (mte == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                World world = mte.getWorld();
                BlockPos blockPos = mte.targetBlock;
                Intrinsics.checkNotNull((Object)blockPos);
                world.func_175655_b(blockPos, false);
            }
            return super.setupAndConsumeRecipeInputs(recipe, importInventory);
        }

        public void setMaxProgress(int maxProgress) {
            super.setMaxProgress((int)Math.floor((double)maxProgress * Math.pow(0.8, MultiblockBedrockDrillingRig.this.motorCasingTier)));
        }

        public int getParallelLimit() {
            return 16 * MultiblockBedrockDrillingRig.this.pistonCasingTier;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgregtechlite/gtlitecore/common/metatileentity/multiblock/MultiblockBedrockDrillingRig$Companion;", "", "<init>", "()V", "casingState", "Lnet/minecraft/block/state/IBlockState;", "secondCasingState", "gearboxCasingState", "thirdCasingState", "fourthCasingState", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

