/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.item.behavior;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IParentWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.text.RichText;
import com.cleanroommc.modularui.factory.HandGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Row;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.mui.factory.MetaItemGuiFactory;
import gregtech.api.util.KeyUtil;
import gregtech.common.mui.widget.ScrollableTextWidget;
import gregtechlite.gtlitecore.api.GTLiteLog;
import gregtechlite.gtlitecore.api.pattern.JsonBlockPattern;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016JN\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J*\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010#\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001d\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010&2\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010'\u00a8\u0006("}, d2={"Lgregtechlite/gtlitecore/common/item/behavior/StructureWriterBehavior;", "Lgregtech/api/items/metaitem/stats/IItemBehaviour;", "Lgregtech/api/items/gui/ItemUIFactory;", "<init>", "()V", "isItemStructureWriter", "", "stack", "Lnet/minecraft/item/ItemStack;", "buildUI", "Lcom/cleanroommc/modularui/screen/ModularPanel;", "guiData", "Lcom/cleanroommc/modularui/factory/HandGuiData;", "guiSyncManager", "Lcom/cleanroommc/modularui/value/sync/PanelSyncManager;", "onItemUseFirst", "Lnet/minecraft/util/EnumActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "side", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "hand", "Lnet/minecraft/util/EnumHand;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "addPos", "", "removePos", "exportLog", "getPos", "", "(Lnet/minecraft/item/ItemStack;)[Lnet/minecraft/util/math/BlockPos;", "gtlitecore"})
public final class StructureWriterBehavior
implements IItemBehaviour,
ItemUIFactory {
    @NotNull
    public static final StructureWriterBehavior INSTANCE = new StructureWriterBehavior();

    private StructureWriterBehavior() {
    }

    public final boolean isItemStructureWriter(@Nullable ItemStack stack) {
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull((Object)itemStack);
        if (itemStack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof MetaItem) {
            MetaItem.MetaValueItem valueItem = ((MetaItem)item).getItem(stack);
            return valueItem != null && valueItem.getBehaviours().contains(INSTANCE);
        }
        return false;
    }

    @NotNull
    public ModularPanel buildUI(@NotNull HandGuiData guiData, @NotNull PanelSyncManager guiSyncManager) {
        Intrinsics.checkNotNullParameter((Object)guiData, (String)"guiData");
        Intrinsics.checkNotNullParameter((Object)guiSyncManager, (String)"guiSyncManager");
        IDrawable[] iDrawableArray = new IDrawable[]{GTGuiTextures.BACKGROUND};
        ModularPanel modularPanel = (ModularPanel)GTGuis.createPanel((ItemStack)guiData.getMainHandItem(), (int)176, (int)120).background(iDrawableArray);
        iDrawableArray = new IDrawable[]{GTGuiTextures.DISPLAY};
        Flow flow = (Flow)((Flow)new Column().margin(4)).child((IWidget)((ParentWidget)((ParentWidget)((ParentWidget)new ParentWidget().widthRel(1.0f)).heightRel(0.5f)).background(iDrawableArray)).child((IWidget)((ScrollableTextWidget)((ScrollableTextWidget)((ScrollableTextWidget)new ScrollableTextWidget().full()).margin(4)).alignment(Alignment.TopLeft)).autoUpdate(true).textBuilder(arg_0 -> StructureWriterBehavior.buildUI$lambda$0(guiData, arg_0))));
        iDrawableArray = new IDrawable[]{IKey.lang((String)"metaitem.debug.structure_writer.export_to_log")};
        Flow flow2 = (Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(22)).crossAxisAlignment(Alignment.CrossAxis.CENTER).childPadding(4).child((IWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().expanded()).overlay(iDrawableArray)).onMouseTapped(arg_0 -> StructureWriterBehavior.buildUI$lambda$1(guiData, arg_0)));
        iDrawableArray = new IDrawable[]{IKey.lang((String)"metaitem.debug.structure_writer.export_to_json")};
        Flow flow3 = (Flow)flow.child((IWidget)flow2.child((IWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().expanded()).overlay(iDrawableArray)).onMouseTapped(arg_0 -> StructureWriterBehavior.buildUI$lambda$2(guiData, arg_0))));
        iDrawableArray = new IDrawable[]{IKey.lang((String)"metaitem.debug.structure_writer.rotate_along_y_axis")};
        Flow flow4 = (Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(22)).crossAxisAlignment(Alignment.CrossAxis.CENTER).childPadding(4).child((IWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().expanded()).overlay(iDrawableArray)).onMouseTapped(arg_0 -> StructureWriterBehavior.buildUI$lambda$3(guiData, arg_0)));
        iDrawableArray = new IDrawable[]{IKey.lang((String)"metaitem.debug.structure_writer.empty")};
        IParentWidget iParentWidget = modularPanel.child((IWidget)flow3.child((IWidget)flow4.child((IWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().expanded()).overlay(iDrawableArray)).onMouseTapped(arg_0 -> StructureWriterBehavior.buildUI$lambda$4(guiData, arg_0)))));
        Intrinsics.checkNotNullExpressionValue((Object)iParentWidget, (String)"child(...)");
        return (ModularPanel)iParentWidget;
    }

    @Nullable
    public EnumActionResult onItemUseFirst(@NotNull EntityPlayer player, @Nullable World world, @NotNull BlockPos pos, @Nullable EnumFacing side, float hitX, float hitY, float hitZ, @NotNull EnumHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            Intrinsics.checkNotNull((Object)stack);
            this.addPos(stack, pos);
        } else {
            Intrinsics.checkNotNull((Object)stack);
            this.removePos(stack);
        }
        return EnumActionResult.SUCCESS;
    }

    @Nullable
    public ActionResult<ItemStack> onItemRightClick(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            Intrinsics.checkNotNull((Object)stack);
            this.removePos(stack);
        } else if (!world.field_72995_K) {
            MetaItemGuiFactory.open((EntityPlayer)player, (EnumHand)hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public final void addPos(@NotNull ItemStack stack, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        NBTTagCompound tag = stack.func_190925_c("blueprint");
        if (!tag.func_74764_b("minX") || tag.func_74762_e("minX") > pos.func_177958_n()) {
            tag.func_74768_a("minX", pos.func_177958_n());
        }
        if (!tag.func_74764_b("maxX") || tag.func_74762_e("maxX") < pos.func_177958_n()) {
            tag.func_74768_a("maxX", pos.func_177958_n());
        }
        if (!tag.func_74764_b("minY") || tag.func_74762_e("minY") > pos.func_177956_o()) {
            tag.func_74768_a("minY", pos.func_177956_o());
        }
        if (!tag.func_74764_b("maxY") || tag.func_74762_e("maxY") < pos.func_177956_o()) {
            tag.func_74768_a("maxY", pos.func_177956_o());
        }
        if (!tag.func_74764_b("minZ") || tag.func_74762_e("minZ") > pos.func_177952_p()) {
            tag.func_74768_a("minZ", pos.func_177952_p());
        }
        if (!tag.func_74764_b("maxZ") || tag.func_74762_e("maxZ") < pos.func_177952_p()) {
            tag.func_74768_a("maxZ", pos.func_177952_p());
        }
    }

    public final void removePos(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        NBTTagCompound tag = stack.func_190925_c("blueprint");
        tag.func_82580_o("minX");
        tag.func_82580_o("maxX");
        tag.func_82580_o("minY");
        tag.func_82580_o("maxY");
        tag.func_82580_o("minZ");
        tag.func_82580_o("maxZ");
    }

    private final boolean exportLog(HandGuiData guiData) {
        if (this.getPos(guiData.getMainHandItem()) != null) {
            BlockPos[] blockPosArray = this.getPos(guiData.getMainHandItem());
            Intrinsics.checkNotNull((Object)blockPosArray);
            BlockPos[] blockPos = blockPosArray;
            StringBuilder builder = new StringBuilder();
            World world = guiData.getPlayer().field_70170_p;
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
            JsonBlockPattern blockPattern = new JsonBlockPattern(world, blockPos[0].func_177958_n(), blockPos[0].func_177956_o(), blockPos[0].func_177952_p(), blockPos[1].func_177958_n(), blockPos[1].func_177956_o(), blockPos[1].func_177952_p());
            int n = ((Object[])blockPattern.getBlockPattern()).length;
            for (int i = 0; i < n; ++i) {
                String[] strings = blockPattern.getBlockPattern()[i];
                builder.append(".aisle(");
                for (String string : strings) {
                    String string2 = "\"%s\", ";
                    Object[] objectArray = new Object[]{string};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    builder.append(string3);
                }
                builder.append(")\n");
            }
            GTLiteLog.logger.info(builder.toString());
            return true;
        }
        return false;
    }

    @Nullable
    public final BlockPos[] getPos(@Nullable ItemStack stack) {
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull((Object)itemStack);
        NBTTagCompound tag = itemStack.func_190925_c("blueprint");
        if (!tag.func_74764_b("minX")) {
            return null;
        }
        BlockPos[] blockPosArray = new BlockPos[]{new BlockPos(tag.func_74762_e("minX"), tag.func_74762_e("minY"), tag.func_74762_e("minZ")), new BlockPos(tag.func_74762_e("maxX"), tag.func_74762_e("maxY"), tag.func_74762_e("maxZ"))};
        return blockPosArray;
    }

    private static final void buildUI$lambda$0(HandGuiData $guiData, RichText it) {
        int x = 0;
        int y = 0;
        int z = 0;
        if (INSTANCE.getPos($guiData.getMainHandItem()) != null) {
            BlockPos[] blockPosArray = INSTANCE.getPos($guiData.getMainHandItem());
            Intrinsics.checkNotNull((Object)blockPosArray);
            BlockPos[] blockPos = blockPosArray;
            x = 1 + blockPos[1].func_177958_n() - blockPos[0].func_177958_n();
            y = 1 + blockPos[1].func_177956_o() - blockPos[0].func_177956_o();
            z = 1 + blockPos[1].func_177952_p() - blockPos[0].func_177952_p();
        }
        Object[] objectArray = new Object[]{x, y, z};
        it.add((IDrawable)KeyUtil.lang((TextFormatting)TextFormatting.WHITE, (String)"metaitem.debug.structure_writer.structure_scale", (Object[])objectArray));
    }

    private static final boolean buildUI$lambda$1(HandGuiData $guiData, int it) {
        return INSTANCE.exportLog($guiData);
    }

    private static final boolean buildUI$lambda$2(HandGuiData $guiData, int it) {
        return INSTANCE.exportLog($guiData);
    }

    private static final boolean buildUI$lambda$3(HandGuiData $guiData, int it) {
        return INSTANCE.exportLog($guiData);
    }

    private static final boolean buildUI$lambda$4(HandGuiData $guiData, int it) {
        return INSTANCE.exportLog($guiData);
    }
}

