/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.item.behavior;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IFoodBehavior;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.util.RandomPotionEffect;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0001>BK\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u0012\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011BG\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0012\u001a\u00020\b\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\f\u0012\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0014B-\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0012\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0015J\u0012\u0010.\u001a\u00020/2\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u0016\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u001c\u0010\u001a\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u001c\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0010\u00102\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\fJ\u0016\u00102\u001a\u00020\u00002\u000e\u00103\u001a\n04R\u0006\u0012\u0002\b\u000305J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0004J\u001f\u00106\u001a\u00020\u00002\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u00107J\u001a\u00108\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\"\u00109\u001a\u00020:2\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\u000e\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010=0<H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u001e\"\u0004\b!\u0010 R\"\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010*\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010+\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0017\"\u0004\b-\u0010\u0019\u00a8\u0006?"}, d2={"Lgregtechlite/gtlitecore/common/item/behavior/FoodBehavior;", "Lgregtech/api/items/metaitem/stats/IFoodBehavior;", "Lgregtech/api/items/metaitem/stats/IItemBehaviour;", "foodLevel", "", "saturation", "", "isDrink", "", "isAlwaysEdible", "stackSupplier", "Lkotlin/Function0;", "Lnet/minecraft/item/ItemStack;", "effects", "", "Lgregtech/api/util/RandomPotionEffect;", "<init>", "(IFZZLkotlin/jvm/functions/Function0;[Lgregtech/api/util/RandomPotionEffect;)V", "alwaysEdible", "stack", "(IFZZLnet/minecraft/item/ItemStack;[Lgregtech/api/util/RandomPotionEffect;)V", "(IFZZ)V", "getFoodLevel", "()I", "setFoodLevel", "(I)V", "getSaturation", "()F", "setSaturation", "(F)V", "()Z", "setDrink", "(Z)V", "setAlwaysEdible", "getStackSupplier", "()Lkotlin/jvm/functions/Function0;", "setStackSupplier", "(Lkotlin/jvm/functions/Function0;)V", "getEffects", "()[Lgregtech/api/util/RandomPotionEffect;", "setEffects", "([Lgregtech/api/util/RandomPotionEffect;)V", "[Lgregtech/api/util/RandomPotionEffect;", "eatingDuration", "getEatingDuration", "setEatingDuration", "getFoodAction", "Lnet/minecraft/item/EnumAction;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "setReturnStack", "metaItem", "Lgregtech/api/items/metaitem/MetaItem$MetaValueItem;", "Lgregtech/api/items/metaitem/MetaItem;", "setPotionEffects", "([Lgregtech/api/util/RandomPotionEffect;)Lgregtechlite/gtlitecore/common/item/behavior/FoodBehavior;", "onFoodEaten", "addInformation", "", "lines", "", "", "Companion", "gtlitecore"})
public final class FoodBehavior
implements IFoodBehavior,
IItemBehaviour {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int foodLevel;
    private float saturation;
    private boolean isDrink;
    private boolean isAlwaysEdible;
    @NotNull
    private Function0<ItemStack> stackSupplier;
    @NotNull
    private RandomPotionEffect[] effects;
    private int eatingDuration;

    public FoodBehavior(int foodLevel, float saturation, boolean isDrink, boolean isAlwaysEdible, @NotNull Function0<ItemStack> stackSupplier, RandomPotionEffect ... effects) {
        Intrinsics.checkNotNullParameter(stackSupplier, (String)"stackSupplier");
        Intrinsics.checkNotNullParameter((Object)effects, (String)"effects");
        this.foodLevel = foodLevel;
        this.saturation = saturation;
        this.isDrink = isDrink;
        this.isAlwaysEdible = isAlwaysEdible;
        this.stackSupplier = stackSupplier;
        this.effects = effects;
        this.eatingDuration = 32;
    }

    public final int getFoodLevel() {
        return this.foodLevel;
    }

    public final void setFoodLevel(int n) {
        this.foodLevel = n;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final void setSaturation(float f) {
        this.saturation = f;
    }

    public final boolean isDrink() {
        return this.isDrink;
    }

    public final void setDrink(boolean bl) {
        this.isDrink = bl;
    }

    public final boolean isAlwaysEdible() {
        return this.isAlwaysEdible;
    }

    public final void setAlwaysEdible(boolean bl) {
        this.isAlwaysEdible = bl;
    }

    @NotNull
    public final Function0<ItemStack> getStackSupplier() {
        return this.stackSupplier;
    }

    public final void setStackSupplier(@NotNull Function0<ItemStack> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.stackSupplier = function0;
    }

    @NotNull
    public final RandomPotionEffect[] getEffects() {
        return this.effects;
    }

    public final void setEffects(@NotNull RandomPotionEffect[] randomPotionEffectArray) {
        Intrinsics.checkNotNullParameter((Object)randomPotionEffectArray, (String)"<set-?>");
        this.effects = randomPotionEffectArray;
    }

    public final int getEatingDuration() {
        return this.eatingDuration;
    }

    public final void setEatingDuration(int n) {
        this.eatingDuration = n;
    }

    public FoodBehavior(int foodLevel, float saturation, boolean isDrink, boolean alwaysEdible, @Nullable ItemStack stack, RandomPotionEffect ... effects) {
        Intrinsics.checkNotNullParameter((Object)effects, (String)"effects");
        this(foodLevel, saturation, isDrink, alwaysEdible, (Function0<ItemStack>)((Function0)() -> FoodBehavior._init_$lambda$0(stack)), Arrays.copyOf(effects, effects.length));
    }

    @JvmOverloads
    public FoodBehavior(int foodLevel, float saturation, boolean isDrink, boolean alwaysEdible) {
        this(foodLevel, saturation, isDrink, alwaysEdible, ItemStack.field_190927_a, new RandomPotionEffect[0]);
    }

    public /* synthetic */ FoodBehavior(int n, float f, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        this(n, f, bl, bl2);
    }

    @NotNull
    public EnumAction getFoodAction(@Nullable ItemStack stack) {
        return this.isDrink ? EnumAction.DRINK : EnumAction.EAT;
    }

    public int getFoodLevel(@Nullable ItemStack stack, @Nullable EntityPlayer player) {
        return this.foodLevel;
    }

    public float getSaturation(@Nullable ItemStack stack, @Nullable EntityPlayer player) {
        return this.saturation;
    }

    public boolean alwaysEdible(@Nullable ItemStack stack, @Nullable EntityPlayer player) {
        return this.isAlwaysEdible;
    }

    @NotNull
    public final FoodBehavior setReturnStack(@Nullable ItemStack stack) {
        this.stackSupplier = () -> FoodBehavior.setReturnStack$lambda$1(stack);
        return this;
    }

    @NotNull
    public final FoodBehavior setReturnStack(@NotNull MetaItem.MetaValueItem metaItem) {
        Intrinsics.checkNotNullParameter((Object)metaItem, (String)"metaItem");
        return this.setReturnStack(metaItem.getStackForm());
    }

    @NotNull
    public final FoodBehavior setEatingDuration(int eatingDuration) {
        this.eatingDuration = eatingDuration;
        return this;
    }

    @NotNull
    public final FoodBehavior setPotionEffects(RandomPotionEffect ... effects) {
        Intrinsics.checkNotNullParameter((Object)effects, (String)"effects");
        this.effects = effects;
        return this;
    }

    @NotNull
    public ItemStack onFoodEaten(@NotNull ItemStack stack, @Nullable EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        for (RandomPotionEffect effect : this.effects) {
            if (!(Math.random() * (double)100 > (double)effect.chance)) continue;
            EntityPlayer entityPlayer = player;
            Intrinsics.checkNotNull((Object)entityPlayer);
            entityPlayer.func_70690_d(new PotionEffect(effect.effect));
        }
        if (player != null && !player.field_70170_p.field_72995_K) {
            Object object = this.stackSupplier.invoke();
            Intrinsics.checkNotNull((Object)object);
            ItemStack containedStack = ((ItemStack)object).func_77946_l();
            if (!player.field_71075_bZ.field_75098_d) {
                if (stack.func_190926_b()) {
                    Intrinsics.checkNotNull((Object)containedStack);
                    return containedStack;
                }
                if (!player.field_71071_by.func_70441_a(containedStack)) {
                    player.func_146097_a(containedStack, false, false);
                }
            }
        }
        return stack;
    }

    public void addInformation(@Nullable ItemStack stack, @NotNull List<String> lines) {
        boolean bl;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        if (!(this.effects.length == 0)) {
            objectArray = this.effects;
            FoodBehavior.Companion.addPotionEffectTooltip(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(objectArray, objectArray.length)), lines);
        }
        if (this.eatingDuration == 32) {
            objectArray = new Object[]{this.eatingDuration};
            bl = lines.add(new TextComponentTranslation("gtlitecore.tooltip.food.common_duration", objectArray).func_150254_d());
        } else {
            objectArray = new Object[]{this.eatingDuration};
            bl = lines.add(new TextComponentTranslation("gtlitecore.tooltip.food.duration", objectArray).func_150254_d());
        }
    }

    @JvmOverloads
    public FoodBehavior(int foodLevel, float saturation, boolean isDrink) {
        this(foodLevel, saturation, isDrink, false, 8, null);
    }

    @JvmOverloads
    public FoodBehavior(int foodLevel, float saturation) {
        this(foodLevel, saturation, false, false, 12, null);
    }

    private static final ItemStack _init_$lambda$0(ItemStack $stack) {
        return $stack;
    }

    private static final ItemStack setReturnStack$lambda$1(ItemStack $stack) {
        return $stack;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007H\u0003\u00a8\u0006\u000b"}, d2={"Lgregtechlite/gtlitecore/common/item/behavior/FoodBehavior$Companion;", "", "<init>", "()V", "addPotionEffectTooltip", "", "effects", "", "Lgregtech/api/util/RandomPotionEffect;", "lines", "", "gtlitecore"})
    @SourceDebugExtension(value={"SMAP\nFoodBehavior.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FoodBehavior.kt\ngregtechlite/gtlitecore/common/item/behavior/FoodBehavior$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1863#2,2:135\n*S KotlinDebug\n*F\n+ 1 FoodBehavior.kt\ngregtechlite/gtlitecore/common/item/behavior/FoodBehavior$Companion\n*L\n45#1:135,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @SideOnly(value=Side.CLIENT)
        private final void addPotionEffectTooltip(List<RandomPotionEffect> effects, List<String> lines) {
            lines.add(new TextComponentTranslation("gtlitecore.tooltip.potion.header", new Object[0]).func_150254_d());
            Iterable $this$forEach$iv = effects;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RandomPotionEffect effect = (RandomPotionEffect)element$iv;
                boolean bl = false;
                Object[] objectArray = new Object[4];
                RandomPotionEffect randomPotionEffect = effect;
                Intrinsics.checkNotNull((Object)randomPotionEffect);
                objectArray[0] = new TextComponentTranslation(randomPotionEffect.effect.func_76453_d(), new Object[0]).func_150254_d();
                objectArray[1] = new TextComponentTranslation("enchantment.level." + (effect.effect.func_76458_c() + 1), new Object[0]);
                objectArray[2] = effect.effect.func_76459_b();
                objectArray[3] = 100 - effect.chance;
                lines.add(new TextComponentTranslation("gtlitecore.tooltip.potion.each", objectArray).func_150254_d());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

