/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.item.behavior;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtechlite.gtlitecore.common.block.GTLiteCropBlock;
import gregtechlite.gtlitecore.common.block.GTLiteRootCropBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n0\tR\u0006\u0012\u0002\b\u00030\n\u0012\u000e\u0010\u0006\u001a\n0\tR\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJT\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0016J\"\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00052\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\"H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lgregtechlite/gtlitecore/common/item/behavior/CropSeedBehavior;", "Lgregtech/api/items/metaitem/stats/IItemBehaviour;", "cropBlock", "Lgregtechlite/gtlitecore/common/block/GTLiteCropBlock;", "seed", "Lnet/minecraft/item/ItemStack;", "crop", "<init>", "(Lgregtechlite/gtlitecore/common/block/GTLiteCropBlock;Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)V", "Lgregtech/api/items/metaitem/MetaItem$MetaValueItem;", "Lgregtech/api/items/metaitem/MetaItem;", "(Lgregtechlite/gtlitecore/common/block/GTLiteCropBlock;Lgregtech/api/items/metaitem/MetaItem$MetaValueItem;Lgregtech/api/items/metaitem/MetaItem$MetaValueItem;)V", "getCropBlock", "()Lgregtechlite/gtlitecore/common/block/GTLiteCropBlock;", "onItemUse", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "addInformation", "", "stack", "lines", "", "", "gtlitecore"})
public class CropSeedBehavior
implements IItemBehaviour {
    @NotNull
    private final GTLiteCropBlock cropBlock;

    public CropSeedBehavior(@NotNull GTLiteCropBlock cropBlock, @NotNull ItemStack seed, @NotNull ItemStack crop) {
        Intrinsics.checkNotNullParameter((Object)((Object)cropBlock), (String)"cropBlock");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)crop, (String)"crop");
        this.cropBlock = cropBlock;
        this.cropBlock.setSeedStack(seed);
        this.cropBlock.setCropStack(crop);
    }

    @NotNull
    protected final GTLiteCropBlock getCropBlock() {
        return this.cropBlock;
    }

    public CropSeedBehavior(@NotNull GTLiteCropBlock cropBlock, @NotNull MetaItem.MetaValueItem seed, @NotNull MetaItem.MetaValueItem crop) {
        Intrinsics.checkNotNullParameter((Object)((Object)cropBlock), (String)"cropBlock");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)crop, (String)"crop");
        ItemStack itemStack = seed.getStackForm();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackForm(...)");
        ItemStack itemStack2 = crop.getStackForm();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getStackForm(...)");
        this(cropBlock, itemStack, itemStack2);
    }

    @Nullable
    public ActionResult<ItemStack> onItemUse(@NotNull EntityPlayer player, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull EnumHand hand, @Nullable EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (worldIn.func_175623_d(pos.func_177984_a()) && this.cropBlock.func_176223_P().func_177230_c().func_176196_c(worldIn, pos.func_177984_a())) {
            worldIn.func_175656_a(pos.func_177984_a(), this.cropBlock.func_176223_P());
            ItemStack heldItem = player.func_184586_b(hand);
            heldItem.func_190918_g(1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public void addInformation(@Nullable ItemStack stack, @NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        lines.add(I18n.func_135052_a((String)"gtlitecore.tooltip.crop.placeable_seed", (Object[])new Object[0]));
        if (this.cropBlock instanceof GTLiteRootCropBlock) {
            lines.add(I18n.func_135052_a((String)"gtlitecore.tooltip.crop.root_placeable_seed.1", (Object[])new Object[0]));
            lines.add(I18n.func_135052_a((String)"gtlitecore.tooltip.crop.root_placeable_seed.2", (Object[])new Object[0]));
        }
    }
}

