/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.item.behavior;

import gregtech.api.items.metaitem.MetaItem;
import gregtechlite.gtlitecore.common.block.GTLiteBerryBushBlock;
import gregtechlite.gtlitecore.common.block.GTLiteCropBlock;
import gregtechlite.gtlitecore.common.item.behavior.CropSeedBehavior;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n0\tR\u0006\u0012\u0002\b\u00030\n\u0012\u000e\u0010\u0006\u001a\n0\tR\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJT\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J\"\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 H\u0016J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006%"}, d2={"Lgregtechlite/gtlitecore/common/item/behavior/BerryCropSeedBehavior;", "Lgregtechlite/gtlitecore/common/item/behavior/CropSeedBehavior;", "berryBush", "Lgregtechlite/gtlitecore/common/block/GTLiteBerryBushBlock;", "seed", "Lnet/minecraft/item/ItemStack;", "crop", "<init>", "(Lgregtechlite/gtlitecore/common/block/GTLiteBerryBushBlock;Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)V", "Lgregtech/api/items/metaitem/MetaItem$MetaValueItem;", "Lgregtech/api/items/metaitem/MetaItem;", "(Lgregtechlite/gtlitecore/common/block/GTLiteBerryBushBlock;Lgregtech/api/items/metaitem/MetaItem$MetaValueItem;Lgregtech/api/items/metaitem/MetaItem$MetaValueItem;)V", "onItemUse", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "addInformation", "", "stack", "lines", "", "", "isBlocked", "", "world", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nBerryCropSeedBehavior.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BerryCropSeedBehavior.kt\ngregtechlite/gtlitecore/common/item/behavior/BerryCropSeedBehavior\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1863#2:90\n1863#2,2:91\n1864#2:93\n*S KotlinDebug\n*F\n+ 1 BerryCropSeedBehavior.kt\ngregtechlite/gtlitecore/common/item/behavior/BerryCropSeedBehavior\n*L\n54#1:90\n60#1:91,2\n54#1:93\n*E\n"})
public final class BerryCropSeedBehavior
extends CropSeedBehavior {
    public BerryCropSeedBehavior(@NotNull GTLiteBerryBushBlock berryBush, @NotNull ItemStack seed, @NotNull ItemStack crop) {
        Intrinsics.checkNotNullParameter((Object)((Object)berryBush), (String)"berryBush");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)crop, (String)"crop");
        super((GTLiteCropBlock)berryBush, seed, crop);
    }

    public BerryCropSeedBehavior(@NotNull GTLiteBerryBushBlock berryBush, @NotNull MetaItem.MetaValueItem seed, @NotNull MetaItem.MetaValueItem crop) {
        Intrinsics.checkNotNullParameter((Object)((Object)berryBush), (String)"berryBush");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)crop, (String)"crop");
        ItemStack itemStack = seed.getStackForm();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackForm(...)");
        ItemStack itemStack2 = crop.getStackForm();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getStackForm(...)");
        this(berryBush, itemStack, itemStack2);
    }

    @Override
    @Nullable
    public ActionResult<ItemStack> onItemUse(@NotNull EntityPlayer player, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull EnumHand hand, @Nullable EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!this.isBlocked(worldIn, pos, player)) {
            return super.onItemUse(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    @Override
    public void addInformation(@Nullable ItemStack stack, @NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        super.addInformation(stack, lines);
        lines.add(I18n.func_135052_a((String)"gtlitecore.tooltip.crop.berry_bush.1", (Object[])new Object[0]));
        lines.add(I18n.func_135052_a((String)"gtlitecore.tooltip.crop.berry_bush.2", (Object[])new Object[0]));
        lines.add(I18n.func_135052_a((String)"gtlitecore.tooltip.crop.berry_bush.3", (Object[])new Object[0]));
        lines.add(I18n.func_135052_a((String)"gtlitecore.tooltip.crop.berry_bush.4", (Object[])new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isBlocked(World world, BlockPos pos, EntityPlayer player) {
        void $this$forEach$iv;
        AtomicInteger areAnyBlocked = new AtomicInteger(0);
        AtomicReference<BlockPos> blockedCrop = new AtomicReference<BlockPos>();
        Iterable iterable = BlockPos.func_177980_a((BlockPos)pos.func_177984_a().func_177974_f().func_177978_c(), (BlockPos)pos.func_177984_a().func_177976_e().func_177968_d());
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllInBox(...)");
        Iterable iterable2 = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            BlockPos crop = (BlockPos)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)crop, (Object)pos.func_177984_a())) {
                BlockPos blockPos = crop;
                Intrinsics.checkNotNull((Object)blockPos);
                if (!(world.func_180495_p(blockPos).func_177230_c() instanceof GTLiteBerryBushBlock)) continue;
            }
            AtomicBoolean isBlocked = new AtomicBoolean(true);
            Intrinsics.checkNotNullExpressionValue((Object)BlockPos.func_177980_a((BlockPos)crop.func_177974_f().func_177978_c(), (BlockPos)crop.func_177976_e().func_177968_d()), (String)"getAllInBox(...)");
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BlockPos blockPos = (BlockPos)element$iv2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)blockPos, (Object)pos.func_177984_a()) || !world.func_180495_p(blockPos).func_177230_c().isAir(world.func_180495_p(blockPos), (IBlockAccess)world, blockPos)) continue;
                isBlocked.set(false);
            }
            if (!isBlocked.get()) continue;
            blockedCrop.set(crop);
            areAnyBlocked.set(areAnyBlocked.get() + 1);
        }
        if (world.field_72995_K && areAnyBlocked.get() > 0) {
            StringBuilder stringBuilder = new StringBuilder().append('(');
            Object v = blockedCrop.get();
            Intrinsics.checkNotNull(v);
            StringBuilder stringBuilder2 = stringBuilder.append(((BlockPos)v).func_177958_n()).append(", ");
            Object v2 = blockedCrop.get();
            Intrinsics.checkNotNull(v2);
            StringBuilder stringBuilder3 = stringBuilder2.append(((BlockPos)v2).func_177956_o()).append(", ");
            Object v3 = blockedCrop.get();
            Intrinsics.checkNotNull(v3);
            String posString = stringBuilder3.append(((BlockPos)v3).func_177952_p()).append(')').toString();
            Object[] objectArray = new Object[]{posString, areAnyBlocked.get()};
            player.func_145747_a((ITextComponent)new TextComponentTranslation("gtlitecore.message.berry_bush_blocked", objectArray));
        }
        return areAnyBlocked.get() > 0;
    }
}

