/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.block;

import gregtech.api.block.VariantBlock;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import gregtechlite.gtlitecore.common.block.GTLiteBlocks;
import gregtechlite.gtlitecore.common.creativetabs.GTLiteCreativeTabs;
import java.util.Collection;
import java.util.Random;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001f !B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\""}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteStoneVariantBlock;", "Lgregtech/api/block/VariantBlock;", "Lgregtechlite/gtlitecore/common/block/GTLiteStoneVariantBlock$StoneType;", "stoneVariant", "Lgregtechlite/gtlitecore/common/block/GTLiteStoneVariantBlock$StoneVariant;", "<init>", "(Lgregtechlite/gtlitecore/common/block/GTLiteStoneVariantBlock$StoneVariant;)V", "getStoneVariant", "()Lgregtechlite/gtlitecore/common/block/GTLiteStoneVariantBlock$StoneVariant;", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "canCreatureSpawn", "", "state", "Lnet/minecraft/block/state/IBlockState;", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "type", "Lnet/minecraft/entity/EntityLiving$SpawnPlacementType;", "canSilkHarvest", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getItemDropped", "Lnet/minecraft/item/Item;", "rand", "Ljava/util/Random;", "fortune", "", "Companion", "StoneType", "StoneVariant", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nGTLiteStoneVariantBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GTLiteStoneVariantBlock.kt\ngregtechlite/gtlitecore/common/block/GTLiteStoneVariantBlock\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,137:1\n37#2:138\n36#2,3:139\n*S KotlinDebug\n*F\n+ 1 GTLiteStoneVariantBlock.kt\ngregtechlite/gtlitecore/common/block/GTLiteStoneVariantBlock\n*L\n50#1:138\n50#1:139,3\n*E\n"})
public final class GTLiteStoneVariantBlock
extends VariantBlock<StoneType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StoneVariant stoneVariant;
    @NotNull
    private static final PropertyEnum<StoneType> PROPERTY;

    public GTLiteStoneVariantBlock(@NotNull StoneVariant stoneVariant) {
        Intrinsics.checkNotNullParameter((Object)((Object)stoneVariant), (String)"stoneVariant");
        super(Material.field_151576_e);
        this.stoneVariant = stoneVariant;
        this.setRegistryName(this.stoneVariant.getId());
        this.func_149663_c("gtlitecore." + this.stoneVariant.getTranslationKey());
        this.func_149711_c(this.stoneVariant.getHardness());
        this.func_149752_b(this.stoneVariant.getResistance());
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.getState(StoneType.LIMESTONE));
        this.func_149647_a(GTLiteCreativeTabs.TAB_DECORATION);
    }

    @NotNull
    public final StoneVariant getStoneVariant() {
        return this.stoneVariant;
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        this.VARIANT = PROPERTY;
        Collection $this$toTypedArray$iv = (Collection)StoneType.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.VALUES = thisCollection$iv.toArray(new StoneType[0]);
        IProperty[] iPropertyArray = new IProperty[]{this.VARIANT};
        return new BlockStateContainer((Block)this, iPropertyArray);
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    public boolean canSilkHarvest(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.stoneVariant == StoneVariant.SMOOTH;
    }

    @NotNull
    public Item func_180660_a(@NotNull IBlockState state, @NotNull Random rand, int fortune) {
        Block block;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (this.stoneVariant == StoneVariant.SMOOTH) {
            GTLiteStoneVariantBlock gTLiteStoneVariantBlock = GTLiteBlocks.STONES.get((Object)StoneVariant.COBBLE);
            Intrinsics.checkNotNull((Object)((Object)gTLiteStoneVariantBlock), (String)"null cannot be cast to non-null type net.minecraft.block.Block");
            block = (Block)gTLiteStoneVariantBlock;
        } else {
            block = (Block)this;
        }
        Item item = Item.func_150898_a((Block)block);
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItemFromBlock(...)");
        return item;
    }

    static {
        PropertyEnum propertyEnum = PropertyEnum.func_177709_a((String)"variant", StoneType.class);
        Intrinsics.checkNotNullExpressionValue((Object)propertyEnum, (String)"create(...)");
        PROPERTY = propertyEnum;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteStoneVariantBlock$Companion;", "", "<init>", "()V", "PROPERTY", "Lnet/minecraft/block/properties/PropertyEnum;", "Lgregtechlite/gtlitecore/common/block/GTLiteStoneVariantBlock$StoneType;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001b\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u001c"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteStoneVariantBlock$StoneType;", "Lnet/minecraft/util/IStringSerializable;", "", "serialName", "", "mapColor", "Lnet/minecraft/block/material/MapColor;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lnet/minecraft/block/material/MapColor;)V", "getMapColor", "()Lnet/minecraft/block/material/MapColor;", "LIMESTONE", "KOMATIITE", "GREEN_SCHIST", "BLUE_SCHIST", "KIMBERLITE", "QUARTZITE", "SLATE", "SHALE", "orePrefix", "Lgregtech/api/unification/ore/OrePrefix;", "getOrePrefix", "()Lgregtech/api/unification/ore/OrePrefix;", "material", "Lgregtech/api/unification/material/Material;", "getMaterial", "()Lgregtech/api/unification/material/Material;", "getName", "gtlitecore"})
    public static final class StoneType
    extends Enum<StoneType>
    implements IStringSerializable {
        @NotNull
        private final String serialName;
        @NotNull
        private final MapColor mapColor;
        @NotNull
        private final OrePrefix orePrefix;
        public static final /* enum */ StoneType LIMESTONE;
        public static final /* enum */ StoneType KOMATIITE;
        public static final /* enum */ StoneType GREEN_SCHIST;
        public static final /* enum */ StoneType BLUE_SCHIST;
        public static final /* enum */ StoneType KIMBERLITE;
        public static final /* enum */ StoneType QUARTZITE;
        public static final /* enum */ StoneType SLATE;
        public static final /* enum */ StoneType SHALE;
        private static final /* synthetic */ StoneType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private StoneType(String serialName, MapColor mapColor) {
            this.serialName = serialName;
            this.mapColor = mapColor;
            OrePrefix orePrefix = OrePrefix.stone;
            Intrinsics.checkNotNullExpressionValue((Object)orePrefix, (String)"stone");
            this.orePrefix = orePrefix;
        }

        @NotNull
        public final MapColor getMapColor() {
            return this.mapColor;
        }

        @NotNull
        public final OrePrefix getOrePrefix() {
            return this.orePrefix;
        }

        @NotNull
        public final gregtech.api.unification.material.Material getMaterial() {
            if (this == LIMESTONE) {
                return GTLiteMaterials.INSTANCE.getLimestone();
            }
            if (this == KOMATIITE) {
                return GTLiteMaterials.INSTANCE.getKomatiite();
            }
            if (this == GREEN_SCHIST) {
                return GTLiteMaterials.INSTANCE.getGreenSchist();
            }
            if (this == BLUE_SCHIST) {
                return GTLiteMaterials.INSTANCE.getBlueSchist();
            }
            if (this == KIMBERLITE) {
                return GTLiteMaterials.INSTANCE.getKimberlite();
            }
            if (this == QUARTZITE) {
                gregtech.api.unification.material.Material material = Materials.Quartzite;
                Intrinsics.checkNotNullExpressionValue((Object)material, (String)"Quartzite");
                return material;
            }
            if (this == SLATE) {
                return GTLiteMaterials.INSTANCE.getSlate();
            }
            if (this == SHALE) {
                return GTLiteMaterials.INSTANCE.getShale();
            }
            gregtech.api.unification.material.Material material = Materials.Stone;
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"Stone");
            return material;
        }

        @NotNull
        public String func_176610_l() {
            return this.serialName;
        }

        public static StoneType[] values() {
            return (StoneType[])$VALUES.clone();
        }

        public static StoneType valueOf(String value) {
            return Enum.valueOf(StoneType.class, value);
        }

        @NotNull
        public static EnumEntries<StoneType> getEntries() {
            return $ENTRIES;
        }

        static {
            MapColor mapColor = MapColor.field_193568_T;
            Intrinsics.checkNotNullExpressionValue((Object)mapColor, (String)"GRAY_STAINED_HARDENED_CLAY");
            LIMESTONE = new StoneType("limestone", mapColor);
            MapColor mapColor2 = MapColor.field_193565_Q;
            Intrinsics.checkNotNullExpressionValue((Object)mapColor2, (String)"YELLOW_STAINED_HARDENED_CLAY");
            KOMATIITE = new StoneType("komatiite", mapColor2);
            MapColor mapColor3 = MapColor.field_193574_Z;
            Intrinsics.checkNotNullExpressionValue((Object)mapColor3, (String)"GREEN_STAINED_HARDENED_CLAY");
            GREEN_SCHIST = new StoneType("green_schist", mapColor3);
            MapColor mapColor4 = MapColor.field_193572_X;
            Intrinsics.checkNotNullExpressionValue((Object)mapColor4, (String)"BLUE_STAINED_HARDENED_CLAY");
            BLUE_SCHIST = new StoneType("blue_schist", mapColor4);
            MapColor mapColor5 = MapColor.field_151670_w;
            Intrinsics.checkNotNullExpressionValue((Object)mapColor5, (String)"GRAY");
            KIMBERLITE = new StoneType("kimberlite", mapColor5);
            MapColor mapColor6 = MapColor.field_151677_p;
            Intrinsics.checkNotNullExpressionValue((Object)mapColor6, (String)"QUARTZ");
            QUARTZITE = new StoneType("quartzite", mapColor6);
            MapColor mapColor7 = MapColor.field_193559_aa;
            Intrinsics.checkNotNullExpressionValue((Object)mapColor7, (String)"RED_STAINED_HARDENED_CLAY");
            SLATE = new StoneType("slate", mapColor7);
            MapColor mapColor8 = MapColor.field_193559_aa;
            Intrinsics.checkNotNullExpressionValue((Object)mapColor8, (String)"RED_STAINED_HARDENED_CLAY");
            SHALE = new StoneType("shale", mapColor8);
            $VALUES = stoneTypeArray = new StoneType[]{StoneType.LIMESTONE, StoneType.KOMATIITE, StoneType.GREEN_SCHIST, StoneType.BLUE_SCHIST, StoneType.KIMBERLITE, StoneType.QUARTZITE, StoneType.SLATE, StoneType.SHALE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0018\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000ej\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001d\u00a8\u0006\u001e"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteStoneVariantBlock$StoneVariant;", "", "id", "", "translationKey", "hardness", "", "resistance", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;FF)V", "getId", "()Ljava/lang/String;", "getTranslationKey", "getHardness", "()F", "getResistance", "SMOOTH", "COBBLE", "COBBLE_MOSSY", "POLISHED", "BRICKS", "BRICKS_CRACKED", "BRICKS_MOSSY", "CHISELED", "TILED", "TILED_SMALL", "BRICKS_SMALL", "WINDMILL_A", "WINDMILL_B", "BRICKS_SQUARE", "gtlitecore"})
    public static final class StoneVariant
    extends Enum<StoneVariant> {
        @NotNull
        private final String id;
        @NotNull
        private final String translationKey;
        private final float hardness;
        private final float resistance;
        public static final /* enum */ StoneVariant SMOOTH = new StoneVariant("SMOOTH", 0, "stone_smooth", null, 0.0f, 0.0f, 14, null);
        public static final /* enum */ StoneVariant COBBLE = new StoneVariant("stone_cobble", "stone_cobble", 2.0f, 10.0f);
        public static final /* enum */ StoneVariant COBBLE_MOSSY = new StoneVariant("stone_cobble_mossy", "stone_cobble_mossy", 2.0f, 10.0f);
        public static final /* enum */ StoneVariant POLISHED = new StoneVariant("POLISHED", 3, "stone_polished", null, 0.0f, 0.0f, 14, null);
        public static final /* enum */ StoneVariant BRICKS = new StoneVariant("BRICKS", 4, "stone_bricks", null, 0.0f, 0.0f, 14, null);
        public static final /* enum */ StoneVariant BRICKS_CRACKED = new StoneVariant("BRICKS_CRACKED", 5, "stone_bricks_cracked", null, 0.0f, 0.0f, 14, null);
        public static final /* enum */ StoneVariant BRICKS_MOSSY = new StoneVariant("BRICKS_MOSSY", 6, "stone_bricks_mossy", null, 0.0f, 0.0f, 14, null);
        public static final /* enum */ StoneVariant CHISELED = new StoneVariant("CHISELED", 7, "stone_chiseled", null, 0.0f, 0.0f, 14, null);
        public static final /* enum */ StoneVariant TILED = new StoneVariant("TILED", 8, "stone_tiled", null, 0.0f, 0.0f, 14, null);
        public static final /* enum */ StoneVariant TILED_SMALL = new StoneVariant("TILED_SMALL", 9, "stone_tiled_small", null, 0.0f, 0.0f, 14, null);
        public static final /* enum */ StoneVariant BRICKS_SMALL = new StoneVariant("BRICKS_SMALL", 10, "stone_bricks_small", null, 0.0f, 0.0f, 14, null);
        public static final /* enum */ StoneVariant WINDMILL_A = new StoneVariant("WINDMILL_A", 11, "stone_windmill_a", "stone_bricks_windmill_a", 0.0f, 0.0f, 12, null);
        public static final /* enum */ StoneVariant WINDMILL_B = new StoneVariant("WINDMILL_B", 12, "stone_windmill_b", "stone_bricks_windmill_b", 0.0f, 0.0f, 12, null);
        public static final /* enum */ StoneVariant BRICKS_SQUARE = new StoneVariant("BRICKS_SQUARE", 13, "stone_bricks_square", null, 0.0f, 0.0f, 14, null);
        private static final /* synthetic */ StoneVariant[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private StoneVariant(String id, String translationKey, float hardness, float resistance) {
            this.id = id;
            this.translationKey = translationKey;
            this.hardness = hardness;
            this.resistance = resistance;
        }

        /* synthetic */ StoneVariant(String string, int n, String string2, String string3, float f, float f2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string3 = string2;
            }
            if ((n2 & 4) != 0) {
                f = 1.5f;
            }
            if ((n2 & 8) != 0) {
                f2 = 10.0f;
            }
            this(string2, string3, f, f2);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getTranslationKey() {
            return this.translationKey;
        }

        public final float getHardness() {
            return this.hardness;
        }

        public final float getResistance() {
            return this.resistance;
        }

        public static StoneVariant[] values() {
            return (StoneVariant[])$VALUES.clone();
        }

        public static StoneVariant valueOf(String value) {
            return Enum.valueOf(StoneVariant.class, value);
        }

        @NotNull
        public static EnumEntries<StoneVariant> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stoneVariantArray = new StoneVariant[]{StoneVariant.SMOOTH, StoneVariant.COBBLE, StoneVariant.COBBLE_MOSSY, StoneVariant.POLISHED, StoneVariant.BRICKS, StoneVariant.BRICKS_CRACKED, StoneVariant.BRICKS_MOSSY, StoneVariant.CHISELED, StoneVariant.TILED, StoneVariant.TILED_SMALL, StoneVariant.BRICKS_SMALL, StoneVariant.WINDMILL_A, StoneVariant.WINDMILL_B, StoneVariant.BRICKS_SQUARE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

