/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.block;

import gregtechlite.gtlitecore.api.GTLiteLog;
import gregtechlite.gtlitecore.api.block.TranslatableBlock;
import gregtechlite.gtlitecore.api.worldgen.generator.CustomWorldGeneratorImpl;
import gregtechlite.gtlitecore.common.block.GTLiteBlocks;
import gregtechlite.gtlitecore.common.creativetabs.GTLiteCreativeTabs;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeBase;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeRegistry;
import java.util.Random;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001.B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020!H\u0016J(\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010(\u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J(\u0010)\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010-\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteSaplingBlock;", "Lnet/minecraft/block/BlockBush;", "Lnet/minecraft/block/IGrowable;", "Lgregtechlite/gtlitecore/api/block/TranslatableBlock;", "offset", "", "<init>", "(I)V", "getTreeFromState", "Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBase;", "blockState", "Lnet/minecraft/block/state/IBlockState;", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "getStateFromMeta", "meta", "getMetaFromState", "getSubBlocks", "", "itemIn", "Lnet/minecraft/creativetab/CreativeTabs;", "items", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/ItemStack;", "getTranslation", "", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "blockSource", "Lnet/minecraft/world/IBlockAccess;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "canGrow", "", "worldIn", "Lnet/minecraft/world/World;", "isClient", "canUseBonemeal", "random", "Ljava/util/Random;", "canBeReplacedByLeaves", "grow", "getPlantType", "Lnet/minecraftforge/common/EnumPlantType;", "damageDropped", "updateTick", "Companion", "gtlitecore"})
public final class GTLiteSaplingBlock
extends BlockBush
implements IGrowable,
TranslatableBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int offset;
    @NotNull
    private static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);
    @NotNull
    private static final PropertyInteger VARIANT;

    public GTLiteSaplingBlock(int offset) {
        super(Material.field_151584_j);
        this.offset = offset;
        this.func_149663_c("gtlitecore.sapling_" + this.offset);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149713_g(1);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(GTLiteCreativeTabs.TAB_DECORATION);
        GTLiteBlocks.SAPLINGS.add(this);
    }

    @NotNull
    public final WorldGeneratorTreeBase getTreeFromState(@NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return WorldGeneratorTreeRegistry.INSTANCE.getGenerators().get(((Number)((Object)blockState.func_177229_b((IProperty)VARIANT))).intValue() + this.offset * 8);
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        IProperty[] iPropertyArray = new IProperty[]{BlockSapling.field_176479_b, VARIANT};
        return new BlockStateContainer((Block)this, iPropertyArray);
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public IBlockState func_176203_a(int meta) {
        IBlockState iBlockState = this.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(meta & 1)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf((meta & 0xE) >> 1));
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"withProperty(...)");
        return iBlockState;
    }

    public int func_176201_c(@NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        int meta = 0;
        Comparable comparable = blockState.func_177229_b((IProperty)BlockSapling.field_176479_b);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        meta |= ((Number)((Object)comparable)).intValue();
        return meta |= ((Number)((Object)blockState.func_177229_b((IProperty)VARIANT))).intValue() << 1;
    }

    public void func_149666_a(@NotNull CreativeTabs itemIn, @NotNull NonNullList<ItemStack> items) {
        Intrinsics.checkNotNullParameter((Object)itemIn, (String)"itemIn");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        for (int i = 0; i < 8 && WorldGeneratorTreeRegistry.INSTANCE.getGenerators().size() > i + this.offset * 8; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i * 2));
        }
    }

    @Override
    @NotNull
    public String getTranslation(@NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        try {
            return "gtlitecore.sapling." + this.getTreeFromState(blockState).getName();
        }
        catch (IndexOutOfBoundsException exception) {
            GTLiteLog.logger.debug((Object)exception);
            return "gtlitecore.sapling.error";
        }
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public AxisAlignedBB func_185496_a(@NotNull IBlockState blockState, @NotNull IBlockAccess blockSource, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockSource, (String)"blockSource");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return SAPLING_AABB;
    }

    public boolean func_176473_a(@NotNull World worldIn, @NotNull BlockPos blockPos, @NotNull IBlockState blockState, boolean isClient) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return true;
    }

    public boolean func_180670_a(@NotNull World worldIn, @NotNull Random random, @NotNull BlockPos blockPos, @NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return true;
    }

    public boolean canBeReplacedByLeaves(@NotNull IBlockState blockState, @NotNull IBlockAccess worldIn, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return true;
    }

    public void func_176474_b(@NotNull World worldIn, @NotNull Random random, @NotNull BlockPos blockPos, @NotNull IBlockState blockState) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            CustomWorldGeneratorImpl customWorldGeneratorImpl = this.getTreeFromState(blockState).getOuterGenerator();
            if (customWorldGeneratorImpl == null) break block0;
            customWorldGeneratorImpl.func_180709_b(worldIn, random, blockPos);
        }
    }

    @NotNull
    public EnumPlantType getPlantType(@NotNull IBlockAccess worldIn, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return EnumPlantType.Plains;
    }

    public int func_180651_a(@NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return ((Number)((Object)blockState.func_177229_b((IProperty)VARIANT))).intValue() << 1;
    }

    public void func_180650_b(@NotNull World worldIn, @NotNull BlockPos blockPos, @NotNull IBlockState blockState, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, blockPos, blockState, random);
            if (random.nextInt(7) != 0) {
                return;
            }
            if (!worldIn.func_175697_a(blockPos, 1)) {
                return;
            }
            if (worldIn.func_175671_l(blockPos.func_177984_a()) >= 9) {
                this.func_176474_b(worldIn, random, blockPos, blockState);
            }
        }
    }

    static {
        PropertyInteger propertyInteger = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)7);
        Intrinsics.checkNotNullExpressionValue((Object)propertyInteger, (String)"create(...)");
        VARIANT = propertyInteger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteSaplingBlock$Companion;", "", "<init>", "()V", "SAPLING_AABB", "Lnet/minecraft/util/math/AxisAlignedBB;", "VARIANT", "Lnet/minecraft/block/properties/PropertyInteger;", "getVARIANT", "()Lnet/minecraft/block/properties/PropertyInteger;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PropertyInteger getVARIANT() {
            return VARIANT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

