/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.block;

import gregtechlite.gtlitecore.api.extension.ItemStackExtKt;
import gregtechlite.gtlitecore.common.block.GTLiteCropBlock;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016JP\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\u000e\u0010(\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010)\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010*\u001a\u00020+H\u0014R\u0011\u0010\"\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$\u00a8\u0006-"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteRootCropBlock;", "Lgregtechlite/gtlitecore/common/block/GTLiteCropBlock;", "name", "", "<init>", "(Ljava/lang/String;)V", "getDrops", "", "drops", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "fortune", "", "onBlockActivated", "", "Lnet/minecraft/world/World;", "blockPos", "blockState", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "minHarvestingAge", "getMinHarvestingAge", "()I", "maxHarvestingAge", "getMaxHarvestingAge", "getMaxAge", "seedHarvestable", "cropHarvestable", "getAgeProperty", "Lnet/minecraft/block/properties/PropertyInteger;", "Companion", "gtlitecore"})
public final class GTLiteRootCropBlock
extends GTLiteCropBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final PropertyInteger DEFAULT_AGE_ROOT;

    private GTLiteRootCropBlock(String name) {
        super(name);
    }

    @Override
    public void getDrops(@NotNull NonNullList<ItemStack> drops, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        Intrinsics.checkNotNullParameter(drops, (String)"drops");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Random random = worldIn instanceof World ? ((World)worldIn).field_73012_v : new Random();
        int age = this.func_185527_x(state);
        if (age >= this.getMinHarvestingAge() && age <= this.getMaxHarvestingAge()) {
            int n = 1 + fortune;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                drops.add((Object)this.getCropStack().func_77946_l());
            }
        } else if (age >= this.func_185526_g()) {
            int cropCount = 0;
            int n = 3 + fortune;
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                if (random.nextInt(2 * this.func_185526_g()) > age) continue;
                ++cropCount;
            }
            if (cropCount > 0) {
                ItemStack cropStack = this.getCropStack().func_77946_l();
                cropStack.func_190920_e(cropCount);
                drops.add((Object)cropStack);
            }
            drops.add((Object)ItemStackExtKt.copy(this.getSeedStack(), 3 + fortune));
        }
    }

    public boolean func_180639_a(@NotNull World worldIn, @NotNull BlockPos blockPos, @NotNull IBlockState blockState, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        if (this.func_185527_x(blockState) >= this.func_185526_g()) {
            Random random = worldIn.field_73012_v;
            BlockCrops.func_180635_a((World)worldIn, (BlockPos)blockPos, (ItemStack)ItemStackExtKt.copy(this.getSeedStack(), random.nextInt(2) + 1));
            worldIn.func_180501_a(blockPos, this.func_185528_e(this.func_185527_x(blockState) - 1), 2);
        }
        return super.func_180639_a(worldIn, blockPos, blockState, player, hand, facing, hitX, hitY, hitZ);
    }

    public final int getMinHarvestingAge() {
        return 4;
    }

    public final int getMaxHarvestingAge() {
        return 5;
    }

    @Override
    public int func_185526_g() {
        return 7;
    }

    public final boolean seedHarvestable(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.func_185527_x(state) == this.func_185526_g();
    }

    public final boolean cropHarvestable(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.func_185527_x(state) <= this.getMaxHarvestingAge() && this.func_185527_x(state) >= this.getMinHarvestingAge();
    }

    @Override
    @NotNull
    protected PropertyInteger func_185524_e() {
        return DEFAULT_AGE_ROOT;
    }

    public /* synthetic */ GTLiteRootCropBlock(String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    static {
        PropertyInteger propertyInteger = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
        Intrinsics.checkNotNullExpressionValue((Object)propertyInteger, (String)"create(...)");
        DEFAULT_AGE_ROOT = propertyInteger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteRootCropBlock$Companion;", "", "<init>", "()V", "DEFAULT_AGE_ROOT", "Lnet/minecraft/block/properties/PropertyInteger;", "create", "Lgregtechlite/gtlitecore/common/block/GTLiteRootCropBlock;", "name", "", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GTLiteRootCropBlock create(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new GTLiteRootCropBlock(name, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

