/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.block;

import com.google.common.collect.Lists;
import com.morphismmc.morphismlib.client.Games;
import com.morphismmc.morphismlib.util.LeafDecayUpdate;
import gregtech.core.CoreModule;
import gregtechlite.gtlitecore.api.GTLiteLog;
import gregtechlite.gtlitecore.api.block.TranslatableBlock;
import gregtechlite.gtlitecore.common.block.GTLiteBlocks;
import gregtechlite.gtlitecore.common.creativetabs.GTLiteCreativeTabs;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeBase;
import gregtechlite.gtlitecore.common.worldgen.generator.tree.WorldGeneratorTreeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004H\u0017J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J.\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020'2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\t\u001a\u00020\nH\u0017J(\u0010,\u001a\u00020+2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010-\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010.\u001a\u00020/H\u0017J(\u00100\u001a\u00020\f2\u0006\u0010 \u001a\u0002012\u0006\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0006\u00102\u001a\u00020\u0004H\u0014J\u0010\u00103\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J \u00104\u001a\u00020\u00152\u0006\u0010 \u001a\u0002012\u0006\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\nH\u0017J(\u00105\u001a\u00020\f2\u0006\u0010 \u001a\u0002012\u0006\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u00106\u001a\u00020+H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteLeaveBlock;", "Lnet/minecraft/block/BlockLeaves;", "Lgregtechlite/gtlitecore/api/block/TranslatableBlock;", "offset", "", "<init>", "(I)V", "getTreeFromState", "Lgregtechlite/gtlitecore/common/worldgen/generator/tree/WorldGeneratorTreeBase;", "blockState", "Lnet/minecraft/block/state/IBlockState;", "registerColors", "", "getStateFromMeta", "meta", "getMetaFromState", "getSubBlocks", "itemIn", "Lnet/minecraft/creativetab/CreativeTabs;", "items", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/ItemStack;", "getWoodType", "Lnet/minecraft/block/BlockPlanks$EnumType;", "getItemDropped", "Lnet/minecraft/item/Item;", "random", "Ljava/util/Random;", "fortune", "onSheared", "", "stack", "worldIn", "Lnet/minecraft/world/IBlockAccess;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "getTranslation", "", "getRenderLayer", "Lnet/minecraft/util/BlockRenderLayer;", "isOpaqueCube", "", "shouldSideBeRendered", "blockAccess", "side", "Lnet/minecraft/util/EnumFacing;", "dropApple", "Lnet/minecraft/world/World;", "chance", "damageDropped", "getItem", "updateTick", "isFancyGraphics", "Companion", "gtlitecore"})
public final class GTLiteLeaveBlock
extends BlockLeaves
implements TranslatableBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int offset;
    @NotNull
    private static final PropertyInteger VARIANT;

    public GTLiteLeaveBlock(int offset) {
        this.offset = offset;
        this.func_149663_c("gtlitecore.leaves_" + this.offset);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(GTLiteCreativeTabs.TAB_DECORATION);
        GTLiteBlocks.LEAVES.add(this);
    }

    @NotNull
    public final WorldGeneratorTreeBase getTreeFromState(@NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return WorldGeneratorTreeRegistry.INSTANCE.getGenerators().get(((Number)((Object)blockState.func_177229_b((IProperty)VARIANT))).intValue() + this.offset * 4);
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerColors() {
        Block[] blockArray = new Block[]{this};
        Games.blockColors().func_186722_a((arg_0, arg_1, arg_2, arg_3) -> GTLiteLeaveBlock.registerColors$lambda$0(this, arg_0, arg_1, arg_2, arg_3), blockArray);
        blockArray = new Block[]{this};
        Games.itemColors().func_186731_a((arg_0, arg_1) -> GTLiteLeaveBlock.registerColors$lambda$1(this, arg_0, arg_1), blockArray);
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public IBlockState func_176203_a(int meta) {
        IBlockState iBlockState = this.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf((meta & 2) == 2)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf((meta & 0xC) >> 2));
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"withProperty(...)");
        return iBlockState;
    }

    public int func_176201_c(@NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        int meta = 0;
        if (((Boolean)blockState.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
            meta |= 1;
        }
        if (((Boolean)blockState.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue()) {
            meta |= 2;
        }
        return meta |= ((Number)((Object)blockState.func_177229_b((IProperty)VARIANT))).intValue() << 2;
    }

    public void func_149666_a(@NotNull CreativeTabs itemIn, @NotNull NonNullList<ItemStack> items) {
        Intrinsics.checkNotNullParameter((Object)itemIn, (String)"itemIn");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        for (int i = 0; i < 4 && WorldGeneratorTreeRegistry.INSTANCE.getGenerators().size() > i + this.offset * 4; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i << 2));
        }
    }

    @Nullable
    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    @NotNull
    public Item func_180660_a(@NotNull IBlockState blockState, @NotNull Random random, int fortune) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        IBlockState iBlockState = this.getTreeFromState(blockState).getSaplingState();
        Intrinsics.checkNotNull((Object)iBlockState);
        Item item = Item.func_150898_a((Block)iBlockState.func_177230_c());
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItemFromBlock(...)");
        return item;
    }

    @NotNull
    public List<ItemStack> onSheared(@NotNull ItemStack stack, @NotNull IBlockAccess worldIn, @NotNull BlockPos blockPos, int fortune) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Object[] objectArray = new ItemStack[1];
        Block block = (Block)this;
        IBlockState iBlockState = worldIn.func_180495_p(blockPos);
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getBlockState(...)");
        objectArray[0] = new ItemStack(block, 1, this.func_176201_c(iBlockState));
        ArrayList arrayList = Lists.newArrayList((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        return arrayList;
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        IProperty[] iPropertyArray = new IProperty[]{BlockLeaves.field_176237_a, BlockLeaves.field_176236_b, VARIANT};
        return new BlockStateContainer((Block)this, iPropertyArray);
    }

    @Override
    @NotNull
    public String getTranslation(@NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        try {
            return "gtlitecore.leaves." + this.getTreeFromState(blockState).getName();
        }
        catch (IndexOutOfBoundsException exception) {
            GTLiteLog.logger.debug((Object)exception);
            return "gtlitecore.leaves.error";
        }
    }

    @NotNull
    public BlockRenderLayer func_180664_k() {
        if (!this.isFancyGraphics()) {
            BlockRenderLayer blockRenderLayer = super.func_180664_k();
            Intrinsics.checkNotNullExpressionValue((Object)blockRenderLayer, (String)"getRenderLayer(...)");
            return blockRenderLayer;
        }
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Deprecated(message="Deprecated in Java")
    public boolean func_149662_c(@NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        if (!this.isFancyGraphics()) {
            return super.func_149662_c(blockState);
        }
        return false;
    }

    @Deprecated(message="Deprecated in Java")
    public boolean func_176225_a(@NotNull IBlockState blockState, @NotNull IBlockAccess blockAccess, @NotNull BlockPos blockPos, @NotNull EnumFacing side) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockAccess, (String)"blockAccess");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (!this.isFancyGraphics()) {
            return super.func_176225_a(blockState, blockAccess, blockPos, side);
        }
        return true;
    }

    protected void func_176234_a(@NotNull World worldIn, @NotNull BlockPos blockPos, @NotNull IBlockState blockState, int chance) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Block block = blockState.func_177230_c();
        Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type gregtechlite.gtlitecore.common.block.GTLiteLeaveBlock");
        ItemStack itemStack = ((GTLiteLeaveBlock)block).getTreeFromState(blockState).getFruitDrop(chance);
        Intrinsics.checkNotNull((Object)itemStack);
        BlockLeaves.func_180635_a((World)worldIn, (BlockPos)blockPos, (ItemStack)itemStack);
    }

    public int func_180651_a(@NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return (((Number)((Object)blockState.func_177229_b((IProperty)VARIANT))).intValue() << 1) + this.offset % 2 * 8;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public ItemStack func_185473_a(@NotNull World worldIn, @NotNull BlockPos blockPos, @NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return new ItemStack(Item.func_150898_a((Block)((Block)this)), 1, ((Number)((Object)blockState.func_177229_b((IProperty)VARIANT))).intValue() << 2);
    }

    public void func_180650_b(@NotNull World worldIn, @NotNull BlockPos blockPos, @NotNull IBlockState blockState, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        LeafDecayUpdate.leafDecay((Block)((Block)this), (World)worldIn, (BlockPos)blockPos);
    }

    private final boolean isFancyGraphics() {
        return CoreModule.proxy.isFancyGraphics();
    }

    private static final int registerColors$lambda$0(GTLiteLeaveBlock this$0, IBlockState blockState, IBlockAccess worldIn, BlockPos blockPos, int tintIndex) {
        Intrinsics.checkNotNull((Object)blockState);
        return this$0.getTreeFromState(blockState).getBlockColor(blockState, worldIn, blockPos, tintIndex);
    }

    private static final int registerColors$lambda$1(GTLiteLeaveBlock this$0, ItemStack stack, int tintIndex) {
        return this$0.getTreeFromState(this$0.func_176203_a(stack.func_77952_i())).getItemColor(stack, tintIndex);
    }

    static {
        PropertyInteger propertyInteger = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)3);
        Intrinsics.checkNotNullExpressionValue((Object)propertyInteger, (String)"create(...)");
        VARIANT = propertyInteger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteLeaveBlock$Companion;", "", "<init>", "()V", "VARIANT", "Lnet/minecraft/block/properties/PropertyInteger;", "getVARIANT", "()Lnet/minecraft/block/properties/PropertyInteger;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PropertyInteger getVARIANT() {
            return VARIANT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

