/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.block;

import java.util.ArrayList;
import java.util.Random;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J8\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0012H\u0016J \u0010\"\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000b\u00a8\u0006,"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteCropBlock;", "Lnet/minecraft/block/BlockCrops;", "name", "", "<init>", "(Ljava/lang/String;)V", "seedStack", "Lnet/minecraft/item/ItemStack;", "getSeedStack", "()Lnet/minecraft/item/ItemStack;", "setSeedStack", "(Lnet/minecraft/item/ItemStack;)V", "cropStack", "getCropStack", "setCropStack", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "state", "Lnet/minecraft/block/state/IBlockState;", "worldIn", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getPlantType", "Lnet/minecraftforge/common/EnumPlantType;", "getMaxAge", "", "getDrops", "", "drops", "Lnet/minecraft/util/NonNullList;", "fortune", "damageDropped", "blockState", "getItem", "Lnet/minecraft/world/World;", "getAgeProperty", "Lnet/minecraft/block/properties/PropertyInteger;", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "getSeed", "Lnet/minecraft/item/Item;", "getCrop", "Companion", "gtlitecore"})
public class GTLiteCropBlock
extends BlockCrops {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ItemStack seedStack;
    @NotNull
    private ItemStack cropStack;
    @NotNull
    private static final PropertyInteger DEFAULT_AGE;
    @NotNull
    private static final AxisAlignedBB CROPS_AABB;
    @JvmField
    @NotNull
    public static ArrayList<GTLiteCropBlock> CROPS;

    protected GTLiteCropBlock(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.seedStack = itemStack;
        ItemStack itemStack2 = ItemStack.field_190927_a;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
        this.cropStack = itemStack2;
        this.setRegistryName("gtlitecore", "crop_" + name);
        this.func_149663_c("gtlitecore.crop_" + name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(0)));
        CROPS.add(this);
    }

    @NotNull
    public final ItemStack getSeedStack() {
        return this.seedStack;
    }

    public final void setSeedStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.seedStack = itemStack;
    }

    @NotNull
    public final ItemStack getCropStack() {
        return this.cropStack;
    }

    public final void setCropStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.cropStack = itemStack;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return CROPS_AABB;
    }

    @NotNull
    public EnumPlantType getPlantType(@NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return EnumPlantType.Crop;
    }

    public int func_185526_g() {
        return 5;
    }

    public void getDrops(@NotNull NonNullList<ItemStack> drops, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        Intrinsics.checkNotNullParameter(drops, (String)"drops");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Random random = worldIn instanceof World ? ((World)worldIn).field_73012_v : new Random();
        int age = this.func_185527_x(state);
        if (age >= this.func_185526_g()) {
            if (!this.seedStack.func_190926_b()) {
                ItemStack seedStack = this.seedStack.func_77946_l();
                if (random.nextInt(9) == 0) {
                    seedStack.func_190920_e(seedStack.func_190916_E() + 1);
                }
                drops.add((Object)seedStack);
            }
            int cropCount = 0;
            int n = 3 + fortune;
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                if (random.nextInt(2 * this.func_185526_g()) > age) continue;
                ++cropCount;
            }
            if (cropCount > 0) {
                ItemStack cropStack = this.cropStack.func_77946_l();
                cropStack.func_190920_e(cropCount);
                drops.add((Object)cropStack);
            }
        }
    }

    public int func_180651_a(@NotNull IBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return this.seedStack.func_77952_i();
    }

    @NotNull
    public ItemStack func_185473_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.seedStack;
    }

    @NotNull
    protected PropertyInteger func_185524_e() {
        return DEFAULT_AGE;
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        IProperty[] iPropertyArray = new IProperty[]{this.func_185524_e()};
        return new BlockStateContainer((Block)this, iPropertyArray);
    }

    @NotNull
    public Item func_149866_i() {
        Item item = this.seedStack.func_77973_b();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
        return item;
    }

    @NotNull
    public Item func_149865_P() {
        Item item = this.cropStack.func_77973_b();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
        return item;
    }

    static {
        PropertyInteger propertyInteger = PropertyInteger.func_177719_a((String)"age", (int)0, (int)5);
        Intrinsics.checkNotNullExpressionValue((Object)propertyInteger, (String)"create(...)");
        DEFAULT_AGE = propertyInteger;
        CROPS_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
        CROPS = new ArrayList();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteCropBlock$Companion;", "", "<init>", "()V", "DEFAULT_AGE", "Lnet/minecraft/block/properties/PropertyInteger;", "getDEFAULT_AGE", "()Lnet/minecraft/block/properties/PropertyInteger;", "CROPS_AABB", "Lnet/minecraft/util/math/AxisAlignedBB;", "CROPS", "Ljava/util/ArrayList;", "Lgregtechlite/gtlitecore/common/block/GTLiteCropBlock;", "create", "name", "", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PropertyInteger getDEFAULT_AGE() {
            return DEFAULT_AGE;
        }

        @NotNull
        public final GTLiteCropBlock create(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new GTLiteCropBlock(name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

