/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.block;

import gregtechlite.gtlitecore.api.GTLiteLog;
import gregtechlite.gtlitecore.common.block.GTLiteCropBlock;
import java.util.Collection;
import java.util.Random;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 A2\u00020\u0001:\u0001AB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0014J8\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0019H\u0014J\u0016\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0017J\u001e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0016J\"\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J \u0010(\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\b\u0010)\u001a\u00020\u0017H\u0016JP\u0010*\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u000202H\u0016J\u0010\u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020\u0017H\u0016J\u0010\u00107\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u00108\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0015H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u000e\u0010>\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteBerryBushBlock;", "Lgregtechlite/gtlitecore/common/block/GTLiteCropBlock;", "name", "", "<init>", "(Ljava/lang/String;)V", "isThorny", "", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "canSustainBush", "state", "Lnet/minecraft/block/state/IBlockState;", "getDrops", "", "drops", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "fortune", "", "grow", "Lnet/minecraft/world/World;", "getEfficiencyByPos", "getBonemealAgeIncrease", "withEfficiency", "efficiency", "getGrowthSlowdown", "world", "getPlantType", "Lnet/minecraftforge/common/EnumPlantType;", "onEntityCollision", "entityIn", "Lnet/minecraft/entity/Entity;", "getCollisionBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "blockState", "getBoundingBox", "getMaxAge", "onBlockActivated", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "getStateFromMeta", "meta", "getMetaFromState", "neighborChanged", "blockIn", "Lnet/minecraft/block/Block;", "fromPos", "getAgeProperty", "Lnet/minecraft/block/properties/PropertyInteger;", "getEfficiency", "setThorny", "thorny", "Companion", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nGTLiteBerryBushBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GTLiteBerryBushBlock.kt\ngregtechlite/gtlitecore/common/block/GTLiteBerryBushBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1863#2,2:230\n295#2,2:232\n*S KotlinDebug\n*F\n+ 1 GTLiteBerryBushBlock.kt\ngregtechlite/gtlitecore/common/block/GTLiteBerryBushBlock\n*L\n101#1:230,2\n110#1:232,2\n*E\n"})
public class GTLiteBerryBushBlock
extends GTLiteCropBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isThorny;
    @NotNull
    private static final PropertyInteger EFFICIENCY;
    @NotNull
    private static final PropertyInteger DEFAULT_AGE;
    @NotNull
    private static final AxisAlignedBB SMALL_AABB;
    @NotNull
    private static final AxisAlignedBB LARGE_AABB;
    @NotNull
    private static final AxisAlignedBB STEM_AABB;

    protected GTLiteBerryBushBlock(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.func_149663_c("gtlitecore.berry_bush_" + name);
        this.func_149711_c(1.0f);
    }

    @Override
    @NotNull
    protected BlockStateContainer func_180661_e() {
        IProperty[] iPropertyArray = new IProperty[]{this.func_185524_e(), EFFICIENCY};
        return new BlockStateContainer((Block)this, iPropertyArray);
    }

    protected boolean func_185514_i(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.func_177230_c() == Blocks.field_150346_d || super.func_185514_i(state);
    }

    @Override
    public void getDrops(@NotNull NonNullList<ItemStack> drops, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        Random rand;
        Intrinsics.checkNotNullParameter(drops, (String)"drops");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.getDrops(drops, worldIn, pos, state, fortune);
        int age = this.func_185527_x(state);
        int efficiency = this.getEfficiency(state);
        Random random = rand = worldIn instanceof World ? ((World)worldIn).field_73012_v : new Random();
        if (age >= this.func_185526_g()) {
            int cropCount = 0;
            cropCount = 1;
            int n = 2 + efficiency;
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                if (rand.nextInt(2) != 0) continue;
                ++cropCount;
            }
            ItemStack crop = this.getCropStack().func_77946_l();
            crop.func_190920_e(cropCount);
            drops.add((Object)crop);
        }
    }

    public void func_176487_g(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        int maxAge;
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (worldIn.field_73012_v.nextInt(Math.max(2, this.getGrowthSlowdown(worldIn, pos, state) / 8)) != 0) {
            return;
        }
        int age = this.func_185527_x(state) + this.func_185529_b(worldIn);
        if (age >= (maxAge = this.func_185526_g())) {
            age = maxAge;
        }
        IBlockState iBlockState = this.func_185528_e(age);
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"withAge(...)");
        worldIn.func_180501_a(pos, this.withEfficiency(iBlockState, this.getEfficiencyByPos(worldIn, pos)), 3);
    }

    /*
     * WARNING - void declaration
     */
    public final int getEfficiencyByPos(@NotNull World worldIn, @NotNull BlockPos pos) {
        Object v5;
        block2: {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Collection collection = EFFICIENCY.func_177700_c();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllowedValues(...)");
            Integer n = (Integer)CollectionsKt.maxOrThrow((Iterable)collection);
            int maxEfficiency = n != null ? n : 0;
            int[] efficiencies = new int[maxEfficiency + 1];
            Iterable iterable = BlockPos.func_177980_a((BlockPos)pos.func_177974_f().func_177978_c(), (BlockPos)pos.func_177976_e().func_177968_d());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllInBox(...)");
            Iterable iterable2 = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos blockPos = (BlockPos)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)blockPos, (Object)pos)) continue;
                IBlockState iBlockState = worldIn.func_180495_p(blockPos);
                Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getBlockState(...)");
                int efficiency = this.getEfficiency(iBlockState);
                boolean bl2 = 0 <= efficiency ? efficiency < efficiencies.length : false;
                if (!bl2) continue;
                int n2 = efficiencies[efficiency];
                efficiencies[efficiency] = n2 + 1;
            }
            Iterable $this$firstOrNull$iv = (Iterable)RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((int[])efficiencies)));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!(efficiencies[it] > 2)) continue;
                v5 = element$iv;
                break block2;
            }
            v5 = null;
        }
        Integer n = v5;
        return n != null ? n : 0;
    }

    protected int func_185529_b(@NotNull World worldIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        return 1;
    }

    @NotNull
    public final IBlockState withEfficiency(@NotNull IBlockState state, int efficiency) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int efficiency2 = efficiency;
        if (efficiency2 > 4) {
            efficiency2 = 4;
            GTLiteLog.logger.warn("The efficiency of a Berry Bush cannot large than 4!");
        }
        IBlockState iBlockState = state.func_177226_a((IProperty)EFFICIENCY, (Comparable)Integer.valueOf(efficiency2));
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"withProperty(...)");
        return iBlockState;
    }

    public final int getGrowthSlowdown(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.func_185527_x(state) == 0) {
            return 4;
        }
        int growthSlowdown = 320 << this.getEfficiency(state);
        if (!world.func_72935_r()) {
            growthSlowdown *= 2;
        }
        if (world.func_72896_J()) {
            growthSlowdown = growthSlowdown * 2 / 3;
        }
        return growthSlowdown;
    }

    @Override
    @NotNull
    public EnumPlantType getPlantType(@NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return EnumPlantType.Plains;
    }

    public void func_180634_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entityIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entityIn, (String)"entityIn");
        if (this.isThorny && entityIn instanceof EntityLiving) {
            ((EntityLiving)entityIn).func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
        double distanceFromCenter = entityIn.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        distanceFromCenter += 0.5;
        entityIn.field_70138_W = 0.125f;
        entityIn.field_70159_w *= (distanceFromCenter /= 4.0);
        entityIn.field_70181_x *= distanceFromCenter;
        entityIn.field_70179_y *= distanceFromCenter;
    }

    @Deprecated(message="Deprecated in Java")
    @Nullable
    public AxisAlignedBB func_180646_a(@NotNull IBlockState blockState, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return STEM_AABB;
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    @NotNull
    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.func_185527_x(state) == 0 ? SMALL_AABB : LARGE_AABB;
    }

    @Override
    public int func_185526_g() {
        return 2;
    }

    public boolean func_180639_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        if (this.func_185525_y(state)) {
            int berries = 0;
            berries = 1;
            int n = 2 + this.getEfficiency(state);
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                if (worldIn.field_73012_v.nextInt(2) != 0) continue;
                ++berries;
            }
            ItemStack berryStack = this.getCropStack().func_77946_l();
            berryStack.func_190920_e(berries);
            if (!playerIn.func_191521_c(berryStack)) {
                playerIn.func_71019_a(berryStack, false);
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(this.func_185526_g() - 1)), 3);
            return true;
        }
        return false;
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        IBlockState iBlockState = this.func_185528_e(meta % 3).func_177226_a((IProperty)EFFICIENCY, (Comparable)Integer.valueOf(meta / 3));
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"withProperty(...)");
        return iBlockState;
    }

    public int func_176201_c(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.getEfficiency(state) * 3 + this.func_185527_x(state);
    }

    public void func_189540_a(@NotNull IBlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockIn, (String)"blockIn");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        if (!(worldIn.func_180495_p(fromPos).func_177230_c() instanceof GTLiteBerryBushBlock)) {
            int newEfficiency = Math.min(this.getEfficiencyByPos(worldIn, pos), this.getEfficiency(state));
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)EFFICIENCY, (Comparable)Integer.valueOf(newEfficiency)), 3);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    @Override
    @NotNull
    public PropertyInteger func_185524_e() {
        return DEFAULT_AGE;
    }

    public final int getEfficiency(@NotNull IBlockState state) {
        int n;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.func_177228_b().get((Object)EFFICIENCY) != null) {
            Comparable comparable = state.func_177229_b((IProperty)EFFICIENCY);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            n = ((Number)((Object)comparable)).intValue();
        } else {
            n = -1;
        }
        return n;
    }

    @NotNull
    public final GTLiteBerryBushBlock setThorny(boolean thorny) {
        this.isThorny = thorny;
        return this;
    }

    static {
        PropertyInteger propertyInteger = PropertyInteger.func_177719_a((String)"efficiency", (int)0, (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)propertyInteger, (String)"create(...)");
        EFFICIENCY = propertyInteger;
        PropertyInteger propertyInteger2 = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)propertyInteger2, (String)"create(...)");
        DEFAULT_AGE = propertyInteger2;
        SMALL_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
        LARGE_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);
        STEM_AABB = new AxisAlignedBB(0.4325, 0.0, 0.4325, 0.5675, 0.25, 0.5675);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgregtechlite/gtlitecore/common/block/GTLiteBerryBushBlock$Companion;", "", "<init>", "()V", "EFFICIENCY", "Lnet/minecraft/block/properties/PropertyInteger;", "getEFFICIENCY", "()Lnet/minecraft/block/properties/PropertyInteger;", "DEFAULT_AGE", "getDEFAULT_AGE", "SMALL_AABB", "Lnet/minecraft/util/math/AxisAlignedBB;", "LARGE_AABB", "STEM_AABB", "create", "Lgregtechlite/gtlitecore/common/block/GTLiteBerryBushBlock;", "name", "", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PropertyInteger getEFFICIENCY() {
            return EFFICIENCY;
        }

        @NotNull
        public final PropertyInteger getDEFAULT_AGE() {
            return DEFAULT_AGE;
        }

        @NotNull
        public final GTLiteBerryBushBlock create(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new GTLiteBerryBushBlock(name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

