/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common.block;

import com.google.common.collect.UnmodifiableIterator;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.client.model.MaterialStateMapper;
import gregtech.client.model.modelfactories.MaterialBlockModelLoader;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockMaterialBase;
import gregtech.common.blocks.properties.PropertyMaterial;
import gregtech.common.creativetab.GTCreativeTabs;
import gregtechlite.gtlitecore.api.unification.material.info.GTLiteMaterialIconType;
import gregtechlite.gtlitecore.common.creativetabs.GTLiteCreativeTabs;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 #2\u00020\u0001:\u0001#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J2\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001cH\u0007\u00a8\u0006$"}, d2={"Lgregtechlite/gtlitecore/common/block/BlockMetalWall;", "Lgregtech/common/blocks/BlockMaterialBase;", "<init>", "()V", "getHarvestTool", "", "state", "Lnet/minecraft/block/state/IBlockState;", "getSoundType", "Lnet/minecraft/block/SoundType;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "entity", "Lnet/minecraft/entity/Entity;", "stack", "Lnet/minecraft/item/ItemStack;", "getHarvestLevel", "", "getMaterial", "Lnet/minecraft/block/material/Material;", "canCreatureSpawn", "", "Lnet/minecraft/world/IBlockAccess;", "type", "Lnet/minecraft/entity/EntityLiving$SpawnPlacementType;", "addInformation", "", "worldIn", "tooltip", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "onModelRegister", "Companion", "gtlitecore"})
public abstract class BlockMetalWall
extends BlockMaterialBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private BlockMetalWall() {
        super(Material.field_151573_f);
        this.func_149663_c("wall_gt");
        this.func_149711_c(4.0f);
        this.func_149752_b(8.0f);
        this.func_149647_a((CreativeTabs)GTCreativeTabs.TAB_GREGTECH_MATERIALS);
        this.func_149647_a(GTLiteCreativeTabs.TAB_DECORATION);
    }

    @NotNull
    public String getHarvestTool(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        gregtech.api.unification.material.Material material = this.getGtMaterial(state);
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getGtMaterial(...)");
        gregtech.api.unification.material.Material material2 = material;
        if (ModHandler.isMaterialWood((gregtech.api.unification.material.Material)material2)) {
            return "axe";
        }
        return "wrench";
    }

    @NotNull
    public SoundType getSoundType(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @Nullable Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        gregtech.api.unification.material.Material material = this.getGtMaterial(state);
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getGtMaterial(...)");
        gregtech.api.unification.material.Material material2 = material;
        if (ModHandler.isMaterialWood((gregtech.api.unification.material.Material)material2)) {
            SoundType soundType = SoundType.field_185848_a;
            Intrinsics.checkNotNullExpressionValue((Object)soundType, (String)"WOOD");
            return soundType;
        }
        SoundType soundType = SoundType.field_185852_e;
        Intrinsics.checkNotNullExpressionValue((Object)soundType, (String)"METAL");
        return soundType;
    }

    @NotNull
    public final SoundType getSoundType(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        gregtech.api.unification.material.Material material = this.getGtMaterial(stack);
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getGtMaterial(...)");
        gregtech.api.unification.material.Material material2 = material;
        if (ModHandler.isMaterialWood((gregtech.api.unification.material.Material)material2)) {
            SoundType soundType = SoundType.field_185848_a;
            Intrinsics.checkNotNullExpressionValue((Object)soundType, (String)"WOOD");
            return soundType;
        }
        SoundType soundType = SoundType.field_185852_e;
        Intrinsics.checkNotNullExpressionValue((Object)soundType, (String)"METAL");
        return soundType;
    }

    public int getHarvestLevel(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return 1;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public Material func_149688_o(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        gregtech.api.unification.material.Material material = this.getGtMaterial(state);
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getGtMaterial(...)");
        gregtech.api.unification.material.Material material2 = material;
        if (ModHandler.isMaterialWood((gregtech.api.unification.material.Material)material2)) {
            Material material3 = Material.field_151575_d;
            Intrinsics.checkNotNullExpressionValue((Object)material3, (String)"WOOD");
            return material3;
        }
        Material material4 = super.func_149688_o(state);
        Intrinsics.checkNotNullExpressionValue((Object)material4, (String)"getMaterial(...)");
        return material4;
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    public void func_190948_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)flagIn, (String)"flagIn");
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (ConfigHolder.misc.debug) {
            tooltip.add("MetaItem Id: wallGt" + this.getGtMaterial(stack).toCamelCaseString());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void onModelRegister() {
        ModelLoader.setCustomStateMapper((Block)((Block)this), (IStateMapper)((IStateMapper)new MaterialStateMapper(GTLiteMaterialIconType.wallGt, arg_0 -> BlockMetalWall.onModelRegister$lambda$0(this, arg_0))));
        UnmodifiableIterator unmodifiableIterator = this.func_176194_O().func_177619_a().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            IBlockState state = (IBlockState)unmodifiableIterator2.next();
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)((Block)this)), (int)this.func_176201_c(state), (ModelResourceLocation)MaterialBlockModelLoader.registerItemModel((MaterialIconType)GTLiteMaterialIconType.wallGt, (MaterialIconSet)this.getGtMaterial(state).getMaterialIconSet()));
        }
    }

    private static final MaterialIconSet onModelRegister$lambda$0(BlockMetalWall this$0, IBlockState s) {
        return this$0.getGtMaterial(s).getMaterialIconSet();
    }

    public /* synthetic */ BlockMetalWall(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lgregtechlite/gtlitecore/common/block/BlockMetalWall$Companion;", "", "<init>", "()V", "create", "Lgregtechlite/gtlitecore/common/block/BlockMetalWall;", "materials", "", "Lgregtech/api/unification/material/Material;", "([Lgregtech/api/unification/material/Material;)Lgregtechlite/gtlitecore/common/block/BlockMetalWall;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockMetalWall create(@NotNull gregtech.api.unification.material.Material[] materials) {
            Intrinsics.checkNotNullParameter((Object)materials, (String)"materials");
            PropertyMaterial property = PropertyMaterial.create((String)"variant", (gregtech.api.unification.material.Material[])materials);
            return new BlockMetalWall(property){
                final /* synthetic */ PropertyMaterial $property;
                {
                    this.$property = $property;
                    super(null);
                }

                public PropertyMaterial getVariantProperty() {
                    PropertyMaterial propertyMaterial = this.$property;
                    Intrinsics.checkNotNull((Object)propertyMaterial);
                    return propertyMaterial;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

