/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.common;

import gregtech.api.block.VariantItemBlock;
import gregtech.common.blocks.BlockMaterialBase;
import gregtech.common.blocks.MaterialItemBlock;
import gregtechlite.gtlitecore.api.GTLiteLog;
import gregtechlite.gtlitecore.api.block.TranslatableVariantItemBlock;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeBackends;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.unification.ore.GTLiteOrePrefix;
import gregtechlite.gtlitecore.common.block.GTLiteBlocks;
import gregtechlite.gtlitecore.common.block.GTLiteCropBlock;
import gregtechlite.gtlitecore.common.block.GTLiteStoneVariantBlock;
import gregtechlite.gtlitecore.common.item.DimensionDisplayItemBlock;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import gregtechlite.gtlitecore.common.item.GTLiteMetaOreDictItems;
import gregtechlite.gtlitecore.common.item.SheetedFrameItemBlock;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="gtlitecore")
public class CommonProxy {
    public void onPreInit() {
        GTLiteRecipeMaps.preInit();
        GTLiteRecipeBackends.preInit();
        GTLiteMetaOreDictItems.register();
    }

    public void onInit() {
        GTLiteRecipeBackends.init();
    }

    public void onPostInit() {
        GTLiteRecipeBackends.postInit();
    }

    @SubscribeEvent
    public static void syncConfigValues(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("gtlitecore")) {
            ConfigManager.sync((String)"gtlitecore", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(@NotNull RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        GTLiteLog.logger.info("Registering Blocks...");
        for (GTLiteStoneVariantBlock stone : GTLiteBlocks.STONES.values()) {
            registry.register((IForgeRegistryEntry)stone);
        }
        GTLiteBlocks.LEAVES.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        GTLiteBlocks.LOGS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        GTLiteBlocks.PLANKS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        GTLiteBlocks.SAPLINGS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        GTLiteCropBlock.CROPS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        registry.register((IForgeRegistryEntry)GTLiteBlocks.WOOD_SLABS);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.DOUBLE_WOOD_SLABS);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.BANANA_WOOD_STAIR);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.ORANGE_WOOD_STAIR);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.MANGO_WOOD_STAIR);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.APRICOT_WOOD_STAIR);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.LEMON_WOOD_STAIR);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.LIME_WOOD_STAIR);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.OLIVE_WOOD_STAIR);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.NUTMEG_WOOD_STAIR);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.COCONUT_WOOD_STAIR);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.RAINBOW_WOOD_STAIR);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.BANANA_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.ORANGE_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.MANGO_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.APRICOT_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.LEMON_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.LIME_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.OLIVE_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.NUTMEG_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.COCONUT_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.RAINBOW_WOOD_FENCE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.BANANA_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.ORANGE_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.MANGO_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.APRICOT_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.LEMON_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.LIME_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.OLIVE_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.NUTMEG_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.COCONUT_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.RAINBOW_WOOD_FENCE_GATE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.DUST_BLOCK);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.DIMENSION_DISPLAY_OVERWORLD);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.DIMENSION_DISPLAY_NETHER);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.DIMENSION_DISPLAY_END);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.NAQUADRIA_CHARGE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.TARANIUM_CHARGE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.LEPTONIC_CHARGE);
        registry.register((IForgeRegistryEntry)GTLiteBlocks.QUANTUM_CHROMODYNAMIC_CHARGE);
        GTLiteBlocks.SHEETED_FRAMES.values().stream().distinct().forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        GTLiteBlocks.METAL_WALLS.values().stream().distinct().forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        registry.register(GTLiteBlocks.MOTOR_CASING);
        registry.register(GTLiteBlocks.PISTON_CASING);
        registry.register(GTLiteBlocks.PUMP_CASING);
        registry.register(GTLiteBlocks.CONVEYOR_CASING);
        registry.register(GTLiteBlocks.ROBOT_ARM_CASING);
        registry.register(GTLiteBlocks.EMITTER_CASING);
        registry.register(GTLiteBlocks.SENSOR_CASING);
        registry.register(GTLiteBlocks.FIELD_GEN_CASING);
        registry.register(GTLiteBlocks.PROCESSOR_CASING);
        registry.register(GTLiteBlocks.PRIMITIVE_CASING);
        registry.register(GTLiteBlocks.METAL_CASING_01);
        registry.register(GTLiteBlocks.METAL_CASING_02);
        registry.register(GTLiteBlocks.METAL_CASING_03);
        registry.register(GTLiteBlocks.BOILER_CASING_01);
        registry.register(GTLiteBlocks.MULTIBLOCK_CASING_01);
        registry.register(GTLiteBlocks.ACTIVE_UNIQUE_CASING_01);
        registry.register(GTLiteBlocks.TURBINE_CASING_01);
        registry.register(GTLiteBlocks.TURBINE_CASING_02);
        registry.register(GTLiteBlocks.FUSION_CASING);
        registry.register(GTLiteBlocks.FUSION_COIL);
        registry.register(GTLiteBlocks.FUSION_CRYOSTAT);
        registry.register(GTLiteBlocks.FUSION_DIVERTOR);
        registry.register(GTLiteBlocks.FUSION_VACUUM);
        registry.register(GTLiteBlocks.SCIENCE_CASING_01);
        registry.register(GTLiteBlocks.SPACETIME_COMPRESSION_FIELD_GENERATOR);
        registry.register(GTLiteBlocks.TIME_ACCELERATION_FIELD_GENERATOR);
        registry.register(GTLiteBlocks.STABILIZATION_FIELD_GENERATOR);
        registry.register(GTLiteBlocks.AEROSPACE_CASING);
        registry.register(GTLiteBlocks.ACCELERATION_TRACK);
        registry.register(GTLiteBlocks.WIRE_COIL);
        registry.register(GTLiteBlocks.CRUCIBLE);
        registry.register(GTLiteBlocks.COMPONENT_ASSEMBLY_CASING);
        registry.register(GTLiteBlocks.NUCLEAR_REACTOR_CORE_01);
        registry.register(GTLiteBlocks.NUCLEAR_REACTOR_CORE_02);
        registry.register(GTLiteBlocks.MANIPULATOR);
        registry.register(GTLiteBlocks.SHIELDING_CORE);
        registry.register(GTLiteBlocks.TRANSPARENT_CASING_01);
        registry.register(GTLiteBlocks.TRANSPARENT_CASING_02);
        registry.register(GTLiteBlocks.TRANSPARENT_CASING_03);
    }

    @SubscribeEvent
    public static void registerItems(@NotNull RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        GTLiteLog.logger.info("Registering Items...");
        GTLiteMetaItems.register();
        for (GTLiteStoneVariantBlock stone : GTLiteBlocks.STONES.values()) {
            registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(stone, VariantItemBlock::new));
        }
        GTLiteBlocks.LEAVES.forEach(t -> registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(t, TranslatableVariantItemBlock::new)));
        GTLiteBlocks.LOGS.forEach(t -> registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(t, TranslatableVariantItemBlock::new)));
        GTLiteBlocks.SAPLINGS.forEach(t -> registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(t, TranslatableVariantItemBlock::new)));
        GTLiteBlocks.PLANKS.forEach(t -> registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(t, TranslatableVariantItemBlock::new)));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.WOOD_SLABS, t -> new ItemSlab((Block)t, (BlockSlab)t, (BlockSlab)GTLiteBlocks.DOUBLE_WOOD_SLABS)));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.BANANA_WOOD_STAIR, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.ORANGE_WOOD_STAIR, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.MANGO_WOOD_STAIR, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.APRICOT_WOOD_STAIR, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.LEMON_WOOD_STAIR, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.LIME_WOOD_STAIR, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.OLIVE_WOOD_STAIR, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.NUTMEG_WOOD_STAIR, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.COCONUT_WOOD_STAIR, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.RAINBOW_WOOD_STAIR, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.BANANA_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.ORANGE_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.MANGO_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.APRICOT_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.LEMON_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.LIME_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.OLIVE_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.NUTMEG_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.COCONUT_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.RAINBOW_WOOD_FENCE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.BANANA_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.ORANGE_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.MANGO_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.APRICOT_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.LEMON_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.LIME_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.OLIVE_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.NUTMEG_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.COCONUT_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.RAINBOW_WOOD_FENCE_GATE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.DUST_BLOCK, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.DIMENSION_DISPLAY_OVERWORLD, DimensionDisplayItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.DIMENSION_DISPLAY_NETHER, DimensionDisplayItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.DIMENSION_DISPLAY_END, DimensionDisplayItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.NAQUADRIA_CHARGE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.TARANIUM_CHARGE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.LEPTONIC_CHARGE, ItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.QUANTUM_CHROMODYNAMIC_CHARGE, ItemBlock::new));
        GTLiteBlocks.SHEETED_FRAMES.values().stream().distinct().map(block -> CommonProxy.createItemBlock(block, SheetedFrameItemBlock::new)).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        GTLiteBlocks.METAL_WALLS.values().stream().distinct().map(block -> CommonProxy.createItemBlock(block, blockWall -> new MaterialItemBlock((BlockMaterialBase)blockWall, GTLiteOrePrefix.wallGt))).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.MOTOR_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.PISTON_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.PUMP_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.CONVEYOR_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.ROBOT_ARM_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.EMITTER_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.SENSOR_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.FIELD_GEN_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.PROCESSOR_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.PRIMITIVE_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.METAL_CASING_01, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.METAL_CASING_02, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.METAL_CASING_03, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.BOILER_CASING_01, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.MULTIBLOCK_CASING_01, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.ACTIVE_UNIQUE_CASING_01, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.TURBINE_CASING_01, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.TURBINE_CASING_02, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.FUSION_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.FUSION_COIL, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.FUSION_CRYOSTAT, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.FUSION_DIVERTOR, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.FUSION_VACUUM, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.SCIENCE_CASING_01, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.SPACETIME_COMPRESSION_FIELD_GENERATOR, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.TIME_ACCELERATION_FIELD_GENERATOR, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.STABILIZATION_FIELD_GENERATOR, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.AEROSPACE_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.ACCELERATION_TRACK, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.WIRE_COIL, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.CRUCIBLE, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.COMPONENT_ASSEMBLY_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.NUCLEAR_REACTOR_CORE_01, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.NUCLEAR_REACTOR_CORE_02, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.MANIPULATOR, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.SHIELDING_CORE, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.TRANSPARENT_CASING_01, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.TRANSPARENT_CASING_02, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTLiteBlocks.TRANSPARENT_CASING_03, VariantItemBlock::new));
    }

    private static <T extends Block> ItemBlock createItemBlock(T block, Function<T, ItemBlock> producer) {
        ItemBlock itemBlock = producer.apply(block);
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            throw new IllegalArgumentException("Block " + block.func_149739_a() + " has no registry name.");
        }
        itemBlock.setRegistryName(registryName);
        return itemBlock;
    }
}

