/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.client.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.Util;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.Display;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u001d\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u0016"}, d2={"Lgregtechlite/gtlitecore/client/util/IconLoader;", "", "<init>", "()V", "setCustomIcon", "", "resourcePath", "", "load", "", "Ljava/nio/ByteBuffer;", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;)[Ljava/nio/ByteBuffer;", "loadInstance", "size", "", "getIconRatio", "", "src", "icon", "convertToByteBuffer", "gtlitecore"})
public final class IconLoader {
    @NotNull
    public static final IconLoader INSTANCE = new IconLoader();

    private IconLoader() {
    }

    @JvmStatic
    public static final boolean setCustomIcon(@Nullable String resourcePath) {
        InputStream resource = IconLoader.class.getClassLoader().getResourceAsStream(resourcePath);
        if (resource == null) {
            return false;
        }
        try {
            BufferedImage image = ImageIO.read(resource);
            Intrinsics.checkNotNull((Object)image);
            Display.setIcon((ByteBuffer[])IconLoader.load(image));
            return true;
        }
        catch (IOException exception) {
            return false;
        }
    }

    @JvmStatic
    @NotNull
    public static final ByteBuffer[] load(@NotNull BufferedImage image) {
        ByteBuffer[] byteBufferArray;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Util.EnumOS enumOS = Util.func_110647_a();
        switch (enumOS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[enumOS.ordinal()]) {
            case 1: {
                ByteBuffer[] byteBufferArray2 = new ByteBuffer[]{INSTANCE.loadInstance(image, 16), INSTANCE.loadInstance(image, 32)};
                byteBufferArray = byteBufferArray2;
                break;
            }
            case 2: {
                ByteBuffer[] byteBufferArray3 = new ByteBuffer[]{INSTANCE.loadInstance(image, 128)};
                byteBufferArray = byteBufferArray3;
                break;
            }
            default: {
                ByteBuffer[] byteBufferArray4 = new ByteBuffer[]{INSTANCE.loadInstance(image, 32)};
                byteBufferArray = byteBufferArray4;
            }
        }
        return byteBufferArray;
    }

    private final ByteBuffer loadInstance(BufferedImage image, int size) {
        BufferedImage imageScaled = new BufferedImage(size, size, 3);
        Graphics2D graphics = imageScaled.createGraphics();
        double ratio = this.getIconRatio(image, imageScaled);
        double width = (double)image.getWidth() * ratio;
        double height = (double)image.getHeight() * ratio;
        graphics.drawImage(image, (int)(((double)imageScaled.getWidth() - width) / (double)2), (int)(((double)imageScaled.getHeight() - height) / (double)2), (int)width, (int)height, null);
        graphics.dispose();
        return IconLoader.convertToByteBuffer(imageScaled);
    }

    private final double getIconRatio(BufferedImage src, BufferedImage icon) {
        double ratio;
        double d = ratio = src.getWidth() > icon.getWidth() ? (double)icon.getWidth() / (double)src.getWidth() : (double)(icon.getWidth() / src.getWidth());
        if (src.getHeight() > icon.getHeight()) {
            double r2 = (double)icon.getHeight() / (double)src.getHeight();
            if (r2 < ratio) {
                ratio = r2;
            }
        } else {
            double r2 = icon.getHeight() / src.getHeight();
            if (r2 < ratio) {
                ratio = r2;
            }
        }
        return ratio;
    }

    @JvmStatic
    @NotNull
    public static final ByteBuffer convertToByteBuffer(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        byte[] buffer = new byte[image.getWidth() * image.getHeight() * 4];
        int counter2 = 0;
        int n = image.getHeight();
        for (int i = 0; i < n; ++i) {
            int n2 = image.getWidth();
            for (int j = 0; j < n2; ++j) {
                int colorSpace = image.getRGB(j, i);
                buffer[counter2] = (byte)(colorSpace << 8 >> 24);
                buffer[counter2 + 1] = (byte)(colorSpace << 16 >> 24);
                buffer[counter2 + 2] = (byte)(colorSpace << 24 >> 24);
                buffer[counter2 + 3] = (byte)(colorSpace >> 24);
                counter2 += 4;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        return byteBuffer;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Util.EnumOS.values().length];
            try {
                nArray[Util.EnumOS.WINDOWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Util.EnumOS.OSX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

