/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.client.shader;

import com.morphismmc.morphismlib.client.Games;
import gregtechlite.gtlitecore.client.event.ClientEventHandlers;
import gregtechlite.gtlitecore.client.shader.CosmicShaderProgram;
import gregtechlite.gtlitecore.client.shader.ShaderCallback;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.ARBShaderObjects;

public class CosmicShaderHelper {
    public static final ShaderCallback shaderCallback;
    public static float[] lightlevel;
    public static boolean inventoryRender;
    public static float cosmicOpacity;

    public static void useShader() {
        CosmicShaderProgram.useShader(CosmicShaderProgram.cosmicShader, shaderCallback);
    }

    public static void releaseShader() {
        CosmicShaderProgram.releaseShader();
    }

    public static void setLightFromLocation(World world, BlockPos pos) {
        if (world == null) {
            CosmicShaderHelper.setLightLevel(1.0f);
            return;
        }
        int coord = world.func_175626_b(pos, 0);
        int[] map = Minecraft.func_71410_x().field_71460_t.field_78504_Q;
        if (map == null) {
            CosmicShaderHelper.setLightLevel(1.0f);
            return;
        }
        int mx = coord % 65536 / 16;
        int my = coord / 65536 / 16;
        int lightcolour = map[my * 16 + mx];
        CosmicShaderHelper.setLightLevel((float)(lightcolour >> 16 & 0xFF) / 256.0f, (float)(lightcolour >> 8 & 0xFF) / 256.0f, (float)(lightcolour & 0xFF) / 256.0f);
    }

    public static void setLightLevel(float level) {
        CosmicShaderHelper.setLightLevel(level, level, level);
    }

    public static void setLightLevel(float r, float g, float b) {
        CosmicShaderHelper.lightlevel[0] = Math.max(0.0f, Math.min(1.0f, r));
        CosmicShaderHelper.lightlevel[1] = Math.max(0.0f, Math.min(1.0f, g));
        CosmicShaderHelper.lightlevel[2] = Math.max(0.0f, Math.min(1.0f, b));
    }

    static {
        lightlevel = new float[3];
        inventoryRender = false;
        cosmicOpacity = 1.0f;
        shaderCallback = new ShaderCallback(){

            @Override
            public void call(int shader) {
                float yaw = 0.0f;
                float pitch = 0.0f;
                float scale = 1.0f;
                if (!inventoryRender) {
                    yaw = (float)((double)(Games.player().field_70177_z * 2.0f) * Math.PI / 360.0);
                    pitch = -((float)((double)(Games.player().field_70125_A * 2.0f) * Math.PI / 360.0));
                } else {
                    scale = 25.0f;
                }
                int x = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"yaw");
                ARBShaderObjects.glUniform1fARB((int)x, (float)yaw);
                int z = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"pitch");
                ARBShaderObjects.glUniform1fARB((int)z, (float)pitch);
                int l = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"lightlevel");
                ARBShaderObjects.glUniform3fARB((int)l, (float)lightlevel[0], (float)lightlevel[1], (float)lightlevel[2]);
                int lightmix = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"lightmix");
                ARBShaderObjects.glUniform1fARB((int)lightmix, (float)0.2f);
                int uvs = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"cosmicuvs");
                ARBShaderObjects.glUniformMatrix2ARB((int)uvs, (boolean)false, (FloatBuffer)ClientEventHandlers.cosmicUVs);
                int s = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"externalScale");
                ARBShaderObjects.glUniform1fARB((int)s, (float)scale);
                int o = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"opacity");
                ARBShaderObjects.glUniform1fARB((int)o, (float)cosmicOpacity);
            }
        };
    }
}

