/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.client.renderer.handler;

import codechicken.lib.model.ModelRegistryHelper;
import gregtechlite.gtlitecore.client.model.WrappedModelGetter;
import gregtechlite.gtlitecore.client.renderer.handler.PerspectiveAwareItemRenderer;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;

public abstract class WrappedItemRenderer
extends PerspectiveAwareItemRenderer {
    protected IBakedModel wrapped;

    public WrappedItemRenderer(IModelState state, IBakedModel model) {
        super(state);
        this.wrapped = model;
    }

    public WrappedItemRenderer(IModelState state, WrappedModelGetter getter) {
        super(state);
        ModelRegistryHelper.registerPreBakeCallback(modelRegistry -> {
            this.wrapped = getter.getWrappedModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry);
        });
    }

    public static void renderModel(IBakedModel model, ItemStack stack) {
        WrappedItemRenderer.renderModel(model, stack, 1.0f);
    }

    public static void renderModel(IBakedModel model, ItemStack stack, float alphaOverride) {
        ItemColors itemColorProvider = Minecraft.func_71410_x().getItemColors();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        LinkedList quads = new LinkedList();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            quads.addAll(model.func_188616_a(null, face, 0L));
        }
        quads.addAll(model.func_188616_a(null, null, 0L));
        int alpha = (int)(alphaOverride * 255.0f) & 0xFF;
        for (BakedQuad quad : quads) {
            int colour = -1;
            if (quad.func_178212_b()) {
                colour = itemColorProvider.func_186728_a(stack, quad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    colour = TextureUtil.func_177054_c((int)colour);
                }
            }
            LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)quad, (int)(colour |= alpha << 24));
        }
        tess.func_78381_a();
    }
}

