/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.client.renderer.handler;

import codechicken.lib.render.item.IItemRenderer;
import com.google.common.collect.ImmutableList;
import gregtechlite.gtlitecore.client.renderer.EntityCallback;
import gregtechlite.gtlitecore.client.renderer.EntityItemTickCallback;
import java.util.List;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerspectiveAwareItemRenderer
implements IItemRenderer,
EntityItemTickCallback {
    @Nullable
    protected EntityLivingBase renderEntity;
    protected World world;
    protected BlockPos entityPos;
    private final IModelState state;

    protected PerspectiveAwareItemRenderer(IModelState state) {
        this.state = state;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public ItemOverrideList func_188617_f() {
        return new EntityCachingOverrideList((entity, world) -> {
            this.renderEntity = entity;
            this.world = world;
            if (entity != null) {
                this.entityPos = entity.func_180425_c();
            }
        });
    }

    public IModelState getTransforms() {
        return this.state;
    }

    @Override
    public void onEntityTick(EntityItem item) {
        this.entityPos = item.func_180425_c();
    }

    private static class EntityCachingOverrideList
    extends ItemOverrideList {
        private final EntityCallback callback;

        public EntityCachingOverrideList(EntityCallback callback) {
            super((List)ImmutableList.of());
            this.callback = callback;
        }

        @NotNull
        public IBakedModel handleItemState(@NotNull IBakedModel originalModel, @NotNull ItemStack stack, World world, EntityLivingBase entity) {
            this.callback.onEntityStuffs(entity, world);
            return super.handleItemState(originalModel, stack, world, entity);
        }
    }
}

