/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.client.renderer.handler;

import codechicken.lib.colour.Colour;
import gregtech.api.items.metaitem.MetaItem;
import gregtechlite.gtlitecore.client.model.WrappedModelGetter;
import gregtechlite.gtlitecore.client.renderer.CustomItemRenderer;
import gregtechlite.gtlitecore.client.renderer.HaloRenderBehavior;
import gregtechlite.gtlitecore.client.renderer.handler.WrappedItemRenderer;
import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.model.IModelState;

public class HaloItemRenderer
extends WrappedItemRenderer {
    private final Random random = new Random();

    public HaloItemRenderer(IModelState state, IBakedModel model) {
        super(state, model);
    }

    public HaloItemRenderer(IModelState state, WrappedModelGetter getter) {
        super(state, getter);
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        if (stack.func_77973_b() instanceof MetaItem) {
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buffer = tess.func_178180_c();
            if (transformType == ItemCameraTransforms.TransformType.GUI) {
                MetaItem.MetaValueItem valueItem = ((MetaItem)stack.func_77973_b()).getItem(stack);
                HaloRenderBehavior hri = null;
                if (valueItem != null) {
                    hri = (HaloRenderBehavior)((CustomItemRenderer)valueItem).getRendererManager();
                }
                if (hri != null) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179097_i();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_179118_c();
                    if (hri.shouldDrawHalo()) {
                        Colour.glColourARGB((int)hri.getHaloColor());
                        TextureAtlasSprite sprite = hri.getHaloTexture();
                        double spread = (double)hri.getHaloSize() / 16.0;
                        double min = 0.0 - spread;
                        double max = 1.0 + spread;
                        float minU = sprite.func_94209_e();
                        float maxU = sprite.func_94212_f();
                        float minV = sprite.func_94206_g();
                        float maxV = sprite.func_94210_h();
                        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                        buffer.func_181662_b(max, max, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
                        buffer.func_181662_b(min, max, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
                        buffer.func_181662_b(min, min, 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
                        buffer.func_181662_b(max, min, 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
                        tess.func_78381_a();
                    }
                    if (hri.shouldDrawPulse()) {
                        GlStateManager.func_179094_E();
                        double scale = this.random.nextDouble() * 0.15 + 0.95;
                        double trans = (1.0 - scale) / 2.0;
                        GlStateManager.func_179137_b((double)trans, (double)trans, (double)0.0);
                        GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0001);
                        HaloItemRenderer.renderModel(this.wrapped, stack, 0.6f);
                        GlStateManager.func_179121_F();
                    }
                    HaloItemRenderer.renderModel(this.wrapped, stack);
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179091_B();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179121_F();
                } else {
                    HaloItemRenderer.renderModel(this.wrapped, stack);
                }
            } else {
                HaloItemRenderer.renderModel(this.wrapped, stack);
            }
        }
    }
}

