/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.client.renderer.handler;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.CCModelState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.util.TransformUtils;
import com.morphismmc.morphismlib.client.Games;
import gregtechlite.gtlitecore.common.item.DimensionDisplayItemBlock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.registry.IRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgregtechlite/gtlitecore/client/renderer/handler/DimensionDisplayItemRenderer;", "Lcodechicken/lib/render/item/IItemRenderer;", "location", "Lnet/minecraft/client/renderer/block/model/ModelResourceLocation;", "<init>", "(Lnet/minecraft/client/renderer/block/model/ModelResourceLocation;)V", "model", "Lnet/minecraft/client/renderer/block/model/IBakedModel;", "renderItem", "", "stack", "Lnet/minecraft/item/ItemStack;", "transformType", "Lnet/minecraft/client/renderer/block/model/ItemCameraTransforms$TransformType;", "getTransforms", "Lcodechicken/lib/render/CCModelState;", "isAmbientOcclusion", "", "isGui3d", "Companion", "gtlitecore"})
public final class DimensionDisplayItemRenderer
implements IItemRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private IBakedModel model;

    public DimensionDisplayItemRenderer(@NotNull ModelResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        ModelRegistryHelper.registerPreBakeCallback(arg_0 -> DimensionDisplayItemRenderer._init_$lambda$0(this, location, arg_0));
    }

    public void renderItem(@NotNull ItemStack stack, @Nullable ItemCameraTransforms.TransformType transformType) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.func_77973_b() instanceof DimensionDisplayItemBlock) {
            RenderItem renderItem = Games.renderItem();
            String dimension = DimensionDisplayItemBlock.Companion.getDimension(stack);
            if (dimension == null || transformType != ItemCameraTransforms.TransformType.GUI) {
                return;
            }
            renderItem.func_175042_a(stack, 0, 0);
            FontRenderer fontRenderer = Games.fontRenderer();
            float smallTextScale = 0.75f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
            GL11.glScalef((float)smallTextScale, (float)smallTextScale, (float)1.0f);
            long prefix = Companion.getPrefix(dimension);
            String tooltipPrefix = prefix != -1L ? "" + 'T' + prefix : "ERROR";
            fontRenderer.func_175065_a(tooltipPrefix, 0.0f, (float)((int)((float)16 / smallTextScale) - fontRenderer.field_78288_b + 1), 0xFFFFFF, true);
            GL11.glPopMatrix();
            GL11.glDisable((int)3008);
        }
    }

    @Nullable
    public CCModelState getTransforms() {
        return TransformUtils.DEFAULT_ITEM;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    private static final void _init_$lambda$0(DimensionDisplayItemRenderer this$0, ModelResourceLocation $location, IRegistry it) {
        IBakedModel iBakedModel = (IBakedModel)it.func_82594_a((Object)$location);
        if (iBakedModel == null) {
            throw new IllegalArgumentException("Model not found");
        }
        this$0.model = iBakedModel;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lgregtechlite/gtlitecore/client/renderer/handler/DimensionDisplayItemRenderer$Companion;", "", "<init>", "()V", "getPrefix", "", "dimName", "", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        public final long getPrefix(@NotNull String dimName) {
            long l;
            Intrinsics.checkNotNullParameter((Object)dimName, (String)"dimName");
            switch (dimName) {
                case "Ow": {
                    l = 1L;
                    break;
                }
                case "Ne": {
                    l = 2L;
                    break;
                }
                case "ED": {
                    l = 3L;
                    break;
                }
                default: {
                    l = 0L;
                }
            }
            return l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

