/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.client.event;

import gregtechlite.gtlitecore.api.translation.CommonI18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\u0018\u00002\u00020\u0001Be\u0012#\u0010\u0002\u001a\u001f0\u0003\u00a2\u0006\u001a\b\u0004\u0012\b\b\u0005\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b\u0006\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f\u0012#\u0010\u0007\u001a\u001f0\u0003\u00a2\u0006\u001a\b\u0004\u0012\b\b\u0005\u0012\u0004\b\u0004\u0010\u0002\u0012\f\b\u0006\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u0013J*\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\t\"\u00020\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017R.\u0010\u0002\u001a\u001f0\u0003\u00a2\u0006\u001a\b\u0004\u0012\b\b\u0005\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b\u0006\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR.\u0010\u0007\u001a\u001f0\u0003\u00a2\u0006\u001a\b\u0004\u0012\b\b\u0005\u0012\u0004\b\u0004\u0010\u0002\u0012\f\b\u0006\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgregtechlite/gtlitecore/client/event/GradientAnimation;", "", "step", "", "Lorg/jetbrains/annotations/Range;", "from", "to", "delay", "formats", "", "", "<init>", "(II[Ljava/lang/String;)V", "getStep", "()I", "getDelay", "", "with", "additions", "([Ljava/lang/String;)Lgregtechlite/gtlitecore/client/event/GradientAnimation;", "invoke", "text", "args", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nTextAnimations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextAnimations.kt\ngregtechlite/gtlitecore/client/event/GradientAnimation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,100:1\n1557#2:101\n1628#2,3:102\n37#3:105\n36#3,3:106\n*S KotlinDebug\n*F\n+ 1 TextAnimations.kt\ngregtechlite/gtlitecore/client/event/GradientAnimation\n*L\n80#1:101\n80#1:102,3\n80#1:105\n80#1:106,3\n*E\n"})
public final class GradientAnimation {
    private final int step;
    private final int delay;
    @NotNull
    private final List<String> formats;

    public GradientAnimation(int step, int delay, String ... formats) {
        Intrinsics.checkNotNullParameter((Object)formats, (String)"formats");
        this.step = step;
        this.delay = delay;
        this.formats = ArraysKt.toList((Object[])formats);
        if (!(this.step >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.delay >= 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getStep() {
        return this.step;
    }

    public final int getDelay() {
        return this.delay;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GradientAnimation with(String ... additions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)additions, (String)"additions");
        Iterable $this$map$iv = this.formats;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it + ArraysKt.joinToString$default((Object[])additions, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] newFormats = thisCollection$iv.toArray(new String[0]);
        return new GradientAnimation(this.step, this.delay, Arrays.copyOf(newFormats, newFormats.length));
    }

    @NotNull
    public final String invoke(@NotNull String text, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (StringsKt.isBlank((CharSequence)text) || this.formats.isEmpty()) {
            return text;
        }
        String translated = CommonI18n.format$default(text, Arrays.copyOf(args, args.length), null, 4, null);
        StringBuilder stringBuilder = new StringBuilder(translated.length() * 3);
        int offset = (int)(System.currentTimeMillis() / (long)this.delay % (long)this.formats.size());
        int n = translated.length();
        for (int i = 0; i < n; ++i) {
            char c = translated.charAt(i);
            int indexColorArray = (i * this.step + this.formats.size() - offset) % this.formats.size();
            stringBuilder.append(this.formats.get(indexColorArray));
            stringBuilder.append(c);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

