/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.worldgen.generator;

import gregtech.common.ConfigHolder;
import gregtechlite.gtlitecore.api.worldgen.condition.GenerateCondition;
import gregtechlite.gtlitecore.api.worldgen.generator.AbstractWorldGenerator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&J\b\u0010\u0011\u001a\u00020\u0003H&J \u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J&\u0010\u0015\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J6\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0016J&\u0010 \u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lgregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl;", "Lnet/minecraft/world/gen/feature/WorldGenerator;", "isNotified", "", "generator", "Lgregtechlite/gtlitecore/api/worldgen/generator/AbstractWorldGenerator;", "<init>", "(ZLgregtechlite/gtlitecore/api/worldgen/generator/AbstractWorldGenerator;)V", "getGenerator", "()Lgregtechlite/gtlitecore/api/worldgen/generator/AbstractWorldGenerator;", "scatter", "worldIn", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "rand", "Ljava/util/Random;", "configure", "generate", "pos", "Lnet/minecraft/util/math/BlockPos;", "setBlockAndUpdate", "", "blockState", "Lnet/minecraft/block/state/IBlockState;", "getAmountInChunk", "", "conditions", "", "Lgregtechlite/gtlitecore/api/worldgen/condition/GenerateCondition;", "chunkX", "chunkZ", "generateInChunk", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nCustomWorldGeneratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomWorldGeneratorImpl.kt\ngregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n295#2,2:109\n*S KotlinDebug\n*F\n+ 1 CustomWorldGeneratorImpl.kt\ngregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl\n*L\n43#1:109,2\n*E\n"})
public abstract class CustomWorldGeneratorImpl
extends WorldGenerator {
    @NotNull
    private final AbstractWorldGenerator generator;

    public CustomWorldGeneratorImpl(boolean isNotified, @NotNull AbstractWorldGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        super(isNotified);
        this.generator = generator;
    }

    @NotNull
    public final AbstractWorldGenerator getGenerator() {
        return this.generator;
    }

    public abstract boolean scatter(@Nullable World var1, @Nullable BlockPos.MutableBlockPos var2, @Nullable Random var3);

    public abstract boolean configure();

    public boolean func_180709_b(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.scatter(worldIn, new BlockPos.MutableBlockPos(pos), rand);
    }

    public void setBlockAndUpdate(@Nullable World worldIn, @Nullable BlockPos blockPos, @Nullable IBlockState blockState) {
        IBlockState blockWorldState;
        IBlockState iBlockState;
        World world = worldIn;
        if (world != null) {
            BlockPos blockPos2 = blockPos;
            Intrinsics.checkNotNull((Object)blockPos2);
            iBlockState = world.func_180495_p(blockPos2);
        } else {
            iBlockState = null;
        }
        IBlockState iBlockState2 = blockWorldState = iBlockState;
        Intrinsics.checkNotNull((Object)iBlockState2);
        if (iBlockState2.func_177230_c().canBeReplacedByLeaves(blockWorldState, (IBlockAccess)worldIn, blockPos)) {
            IBlockState iBlockState3 = blockState;
            Intrinsics.checkNotNull((Object)iBlockState3);
            this.func_175903_a(worldIn, blockPos, iBlockState3);
        }
    }

    public int getAmountInChunk(@NotNull List<GenerateCondition> conditions, int chunkX, int chunkZ, @NotNull World worldIn, @NotNull BlockPos blockPos) {
        Object v0;
        Biome biome;
        block6: {
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            biome = worldIn.func_180494_b(blockPos);
            Iterable $this$firstOrNull$iv = conditions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GenerateCondition it = (GenerateCondition)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)biome);
                if (!it.canGenerateIn(biome)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        GenerateCondition relevantCondition = v0;
        if (relevantCondition == null) {
            return 0;
        }
        double treeStrength = this.generator.getRandomStrength(chunkX, chunkZ);
        if (ConfigHolder.misc.debug) {
            Intrinsics.checkNotNull((Object)biome);
            if (relevantCondition.getPerlinCutoff(biome) < treeStrength) {
                this.generator.updateForPlaced(true);
                double perlinCutoff = relevantCondition.getPerlinCutoff(biome);
                int maxFeatures = relevantCondition.getMaxAmount();
                return (int)Math.ceil((double)maxFeatures - perlinCutoff * (double)maxFeatures);
            }
            this.generator.updateForPlaced(false);
        } else {
            Intrinsics.checkNotNull((Object)biome);
            if (relevantCondition.getPerlinCutoff(biome) < treeStrength) {
                double perlinCutoff = relevantCondition.getPerlinCutoff(biome);
                int maxFeatures = relevantCondition.getMaxAmount();
                return (int)Math.ceil((double)maxFeatures - perlinCutoff * (double)maxFeatures);
            }
        }
        return 0;
    }

    public final boolean generateInChunk(@NotNull World worldIn, @NotNull Random rand, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (!this.configure()) {
            return false;
        }
        Chunk chunk = worldIn.func_72964_e(chunkX, chunkZ);
        int seaLevel = chunk.func_177412_p().func_181545_F();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(chunk.func_76632_l().func_180331_a(8, seaLevel, 8));
        int count = this.getAmountInChunk(this.generator.getConditions(), chunkX, chunkZ, worldIn, (BlockPos)blockPos);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                blockPos.func_181079_c(chunk.field_76635_g * 16 + rand.nextInt(16) + 8, 255, chunk.field_76647_h * 16 + rand.nextInt(16) + 8);
                while (worldIn.func_175623_d((BlockPos)blockPos) && blockPos.func_177956_o() != 0) {
                    blockPos.func_185336_p(blockPos.func_177956_o() - 1);
                }
                blockPos.func_185336_p(blockPos.func_177956_o() + 1);
                if (this.scatter(chunk.func_177412_p(), blockPos, rand)) continue;
                --count;
            }
            return true;
        }
        return false;
    }
}

