/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.worldgen.generator;

import gregtech.api.util.random.XoShiRo256PlusPlusRandom;
import gregtechlite.gtlitecore.api.GTLiteLog;
import gregtechlite.gtlitecore.api.worldgen.CustomWorldGenerator;
import gregtechlite.gtlitecore.api.worldgen.condition.GenerateCondition;
import gregtechlite.gtlitecore.api.worldgen.generator.CustomWorldGeneratorImpl;
import gregtechlite.gtlitecore.common.worldgen.generator.WorldGeneratorRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JL\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2$\u0010\"\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010$\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0004\u0012\u00020&0#H&J\u0010\u0010'\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0016J\u0010\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lgregtechlite/gtlitecore/api/worldgen/generator/AbstractWorldGenerator;", "Lgregtechlite/gtlitecore/api/worldgen/CustomWorldGenerator;", "seed", "", "<init>", "(I)V", "conditions", "", "Lgregtechlite/gtlitecore/api/worldgen/condition/GenerateCondition;", "getConditions", "()Ljava/util/List;", "generatorSimplex", "Lnet/minecraft/world/gen/NoiseGeneratorSimplex;", "perlinScale", "", "getPerlinScale", "()D", "chunkCounter", "placedChunkCounter", "value", "Lgregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl;", "innerGenerator", "getInnerGenerator", "()Lgregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl;", "setInnerGenerator", "(Lgregtechlite/gtlitecore/api/worldgen/generator/CustomWorldGeneratorImpl;)V", "generate", "", "worldIn", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "rand", "Ljava/util/Random;", "notifier", "Lkotlin/Function3;", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/block/state/IBlockState;", "", "setWorld", "getRandomStrength", "chunkX", "chunkZ", "updateForPlaced", "isPlacedSuccess", "gtlitecore"})
public abstract class AbstractWorldGenerator
implements CustomWorldGenerator {
    private final int seed;
    @NotNull
    private final List<GenerateCondition> conditions;
    private NoiseGeneratorSimplex generatorSimplex;
    private final double perlinScale;
    private int chunkCounter;
    private int placedChunkCounter;
    @Nullable
    private CustomWorldGeneratorImpl innerGenerator;

    public AbstractWorldGenerator(int seed) {
        this.seed = seed;
        this.conditions = new ArrayList();
        this.perlinScale = 0.04;
        WorldGeneratorRegistry.INSTANCE.addGenerator(this);
    }

    @NotNull
    public List<GenerateCondition> getConditions() {
        return this.conditions;
    }

    public double getPerlinScale() {
        return this.perlinScale;
    }

    @Nullable
    public CustomWorldGeneratorImpl getInnerGenerator() {
        return this.innerGenerator;
    }

    protected void setInnerGenerator(@Nullable CustomWorldGeneratorImpl customWorldGeneratorImpl) {
        this.innerGenerator = customWorldGeneratorImpl;
    }

    @Override
    public abstract boolean generate(@Nullable World var1, @Nullable BlockPos.MutableBlockPos var2, @Nullable Random var3, @NotNull Function3<? super World, ? super BlockPos, ? super IBlockState, Unit> var4);

    public void setWorld(@NotNull World worldIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        this.generatorSimplex = new NoiseGeneratorSimplex((Random)new XoShiRo256PlusPlusRandom(worldIn.func_72905_C() + (long)this.seed));
    }

    public double getRandomStrength(int chunkX, int chunkZ) {
        NoiseGeneratorSimplex noiseGeneratorSimplex = this.generatorSimplex;
        if (noiseGeneratorSimplex == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatorSimplex");
            noiseGeneratorSimplex = null;
        }
        return noiseGeneratorSimplex.func_151605_a((double)chunkX * this.getPerlinScale(), (double)chunkZ * this.getPerlinScale());
    }

    public void updateForPlaced(boolean isPlacedSuccess) {
        int n = this.chunkCounter;
        this.chunkCounter = n + 1;
        if (isPlacedSuccess) {
            n = this.placedChunkCounter;
            this.placedChunkCounter = n + 1;
        }
        double chunkPercent = (double)this.placedChunkCounter / (double)(this.chunkCounter / 100);
        if (this.chunkCounter % 1000 == 0) {
            GTLiteLog.logger.info("The World Generator '" + this + "' has been placed successfully in chunk '" + chunkPercent + "' percent of time out of '" + this.chunkCounter + "' chunks checked");
        }
    }
}

