/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.worldgen.condition;

import gregtechlite.gtlitecore.api.worldgen.condition.GenerateCondition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgregtechlite/gtlitecore/api/worldgen/condition/ClimateCondition;", "Lgregtechlite/gtlitecore/api/worldgen/condition/GenerateCondition;", "maxAmount", "", "temperature", "", "rainfall", "range", "commonality", "<init>", "(IDDDD)V", "canGenerateIn", "", "biome", "Lnet/minecraft/world/biome/Biome;", "getPerlinCutoff", "gtlitecore"})
public final class ClimateCondition
extends GenerateCondition {
    private final double temperature;
    private final double rainfall;
    private final double range;
    private final double commonality;

    public ClimateCondition(int maxAmount, double temperature, double rainfall, double range, double commonality) {
        super(maxAmount);
        this.temperature = temperature;
        this.rainfall = rainfall;
        this.range = range;
        this.commonality = commonality;
    }

    @Override
    public boolean canGenerateIn(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        double biomeTemperature = (double)biome.func_185353_n() - this.temperature;
        double biomeRainfall = (double)biome.func_76727_i() - this.rainfall;
        return this.range - Math.sqrt(Math.pow(biomeTemperature, 2) + Math.pow(biomeRainfall, 2)) > 0.0;
    }

    @Override
    public double getPerlinCutoff(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        double biomeTemperature = (double)biome.func_185353_n() - this.temperature;
        double biomeRainfall = (double)biome.func_76727_i() - this.rainfall;
        return 1.0 - (this.range - Math.sqrt(Math.pow(biomeTemperature, 2) + Math.pow(biomeRainfall, 2)) * this.commonality);
    }
}

