/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.unification.material.properties;

import gregtech.api.GTValues;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.IngotProperty;
import gregtech.api.unification.material.properties.MaterialToolProperty;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.WireProperties;
import gregtechlite.gtlitecore.api.extension.MaterialExtKt;
import gregtechlite.gtlitecore.api.translation.CommonI18n;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lgregtechlite/gtlitecore/api/unification/material/properties/GTLiteMaterialProperties;", "", "<init>", "()V", "init", "", "setMaterialProperties", "setOreProperties", "setMaterialColors", "setChemicalFormula", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nGTLiteMaterialProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GTLiteMaterialProperties.kt\ngregtechlite/gtlitecore/api/unification/material/properties/GTLiteMaterialProperties\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,897:1\n13402#2,2:898\n13402#2,2:900\n13402#2,2:902\n13402#2,2:904\n13402#2,2:906\n*S KotlinDebug\n*F\n+ 1 GTLiteMaterialProperties.kt\ngregtechlite/gtlitecore/api/unification/material/properties/GTLiteMaterialProperties\n*L\n404#1:898,2\n407#1:900,2\n415#1:902,2\n419#1:904,2\n423#1:906,2\n*E\n"})
public final class GTLiteMaterialProperties {
    @NotNull
    public static final GTLiteMaterialProperties INSTANCE = new GTLiteMaterialProperties();

    private GTLiteMaterialProperties() {
    }

    public final void init() {
        this.setMaterialProperties();
        this.setOreProperties();
        this.setMaterialColors();
        this.setChemicalFormula();
    }

    public final void setMaterialProperties() {
        Material it;
        Material element$iv;
        int n;
        Material[] materialArray = new Material[]{Materials.Strontium, Materials.Rhenium, Materials.Uranium, Materials.Uranium235, Materials.Uranium238, Materials.Selenium, Materials.Tellurium, Materials.Lanthanum, Materials.Cerium, Materials.Praseodymium, Materials.Promethium, Materials.Gadolinium, Materials.Terbium, Materials.Dysprosium, Materials.Holmium, Materials.Erbium, Materials.Thulium, Materials.Ytterbium, Materials.Scandium, Materials.Germanium, Materials.Technetium, Materials.Cadmium, Materials.Dubnium, Materials.Rutherfordium, Materials.Curium, Materials.Seaborgium, Materials.Bohrium, Materials.Neptunium, Materials.Fermium, Materials.Rubidium, Materials.Calcium, Materials.Magnesium, Materials.Francium, Materials.Thallium, Materials.Barium, Materials.Lutetium, Materials.Californium, Materials.Radium, Materials.Polonium, Materials.Actinium, Materials.Protactinium, Materials.Berkelium, Materials.Einsteinium, Materials.Mendelevium, Materials.Astatine, Materials.Nobelium, Materials.Lawrencium, Materials.Roentgenium, Materials.Moscovium, Materials.Meitnerium, Materials.Copernicium, Materials.Nihonium, Materials.Livermorium, Materials.Tennessine, Materials.Sulfur};
        Material[] $this$forEach$iv = materialArray;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            MaterialExtKt.addIngot(it);
        }
        $this$forEach$iv = new Material[]{Materials.Iodine};
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            MaterialExtKt.addDust(it);
        }
        $this$forEach$iv = new Material[]{Materials.Bromine, Materials.Uranium238, Materials.Zircaloy4, Materials.Inconel718, Materials.SodiumBisulfate, Materials.Germanium, Materials.Rutherfordium, Materials.Dubnium, Materials.Curium, Materials.Seaborgium, Materials.Bohrium, Materials.Selenium, Materials.Francium, Materials.Thallium, Materials.Sodium, Materials.Californium, Materials.Radium, Materials.Scandium, Materials.Polonium, Materials.Actinium, Materials.Protactinium, Materials.Berkelium, Materials.Einsteinium, Materials.Mendelevium, Materials.Astatine, Materials.Nobelium, Materials.Lawrencium, Materials.Ytterbium, Materials.Rhenium, Materials.Roentgenium, Materials.Moscovium, Materials.Meitnerium, Materials.Copernicium, Materials.Nihonium, Materials.Livermorium, Materials.Tennessine, Materials.Thulium, Materials.Promethium, Materials.Barium, Materials.Tellurium, Materials.Holmium, Materials.Erbium, Materials.Gadolinium, Materials.EnderPearl};
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            MaterialExtKt.addLiquid(it);
        }
        $this$forEach$iv = new Material[]{Materials.Niobium, Materials.Zinc, Materials.Krypton, Materials.Xenon, Materials.Radon, Materials.Neon, Materials.Bismuth, Materials.Thorium, Materials.Silver, Materials.Titanium, Materials.Lead};
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            MaterialExtKt.addPlasma(it);
        }
        $this$forEach$iv = new Material[]{Materials.Neptunium, Materials.Fermium, Materials.Boron, Materials.Rubidium, Materials.Technetium, Materials.Calcium, Materials.Sulfur};
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            MaterialExtKt.addLiquidAndPlasma(it);
        }
        ((IngotProperty)GTLiteMaterials.INSTANCE.getChromiumGermaniumTelluride().getProperty(PropertyKey.INGOT)).setMagneticMaterial(GTLiteMaterials.INSTANCE.getChromiumGermaniumTellurideMagnetic());
        ((IngotProperty)Materials.Europium.getProperty(PropertyKey.INGOT)).setMagneticMaterial(GTLiteMaterials.INSTANCE.getMagnetium());
        Materials.Rhenium.setProperty(PropertyKey.BLAST, (IMaterialProperty)new BlastProperty(3459));
        ((BlastProperty)Materials.Rhenium.getProperty(PropertyKey.BLAST)).setDurationOverride(268);
        Materials.Uranium.setProperty(PropertyKey.BLAST, (IMaterialProperty)new BlastProperty(600));
        ((BlastProperty)Materials.Uranium.getProperty(PropertyKey.BLAST)).setEutOverride(GTValues.VA[2]);
        ((BlastProperty)Materials.Uranium.getProperty(PropertyKey.BLAST)).setDurationOverride(300);
        Materials.Germanium.setProperty(PropertyKey.BLAST, (IMaterialProperty)new BlastProperty(1211));
        Materials.Americium.setProperty(PropertyKey.BLAST, (IMaterialProperty)new BlastProperty(7500));
        ((BlastProperty)Materials.Americium.getProperty(PropertyKey.BLAST)).setEutOverride(GTValues.VA[7]);
        ((BlastProperty)Materials.Americium.getProperty(PropertyKey.BLAST)).setDurationOverride(240);
        ((BlastProperty)Materials.Americium.getProperty(PropertyKey.BLAST)).setVacuumEutOverride(GTValues.VA[6]);
        ((BlastProperty)Materials.Americium.getProperty(PropertyKey.BLAST)).setVacuumDurationOverride(360);
        Materials.Seaborgium.setProperty(PropertyKey.BLAST, (IMaterialProperty)new BlastProperty(8300));
        ((BlastProperty)Materials.Seaborgium.getProperty(PropertyKey.BLAST)).setEutOverride(GTValues.VA[7]);
        ((BlastProperty)Materials.Seaborgium.getProperty(PropertyKey.BLAST)).setDurationOverride(320);
        ((BlastProperty)Materials.Seaborgium.getProperty(PropertyKey.BLAST)).setVacuumEutOverride(GTValues.VA[5]);
        ((BlastProperty)Materials.Seaborgium.getProperty(PropertyKey.BLAST)).setVacuumDurationOverride(440);
        Materials.Bohrium.setProperty(PropertyKey.BLAST, (IMaterialProperty)new BlastProperty(8500));
        ((BlastProperty)Materials.Bohrium.getProperty(PropertyKey.BLAST)).setEutOverride(GTValues.VA[7]);
        ((BlastProperty)Materials.Bohrium.getProperty(PropertyKey.BLAST)).setDurationOverride(360);
        ((BlastProperty)Materials.Bohrium.getProperty(PropertyKey.BLAST)).setVacuumEutOverride(GTValues.VA[5]);
        ((BlastProperty)Materials.Bohrium.getProperty(PropertyKey.BLAST)).setVacuumDurationOverride(280);
        ((BlastProperty)Materials.RutheniumTriniumAmericiumNeutronate.getProperty(PropertyKey.BLAST)).setBlastTemperature(12100);
        ((BlastProperty)Materials.RutheniumTriniumAmericiumNeutronate.getProperty(PropertyKey.BLAST)).setEutOverride(GTValues.VA[9]);
        Materials.Fermium.setProperty(PropertyKey.BLAST, (IMaterialProperty)new BlastProperty(9500));
        ((BlastProperty)Materials.Fermium.getProperty(PropertyKey.BLAST)).setEutOverride(GTValues.VA[8]);
        ((BlastProperty)Materials.Fermium.getProperty(PropertyKey.BLAST)).setDurationOverride(440);
        ((BlastProperty)Materials.Fermium.getProperty(PropertyKey.BLAST)).setVacuumEutOverride(GTValues.VA[5]);
        ((BlastProperty)Materials.Fermium.getProperty(PropertyKey.BLAST)).setVacuumDurationOverride(240);
        Materials.Neptunium.setProperty(PropertyKey.BLAST, (IMaterialProperty)new BlastProperty(3440));
        ((BlastProperty)Materials.Neptunium.getProperty(PropertyKey.BLAST)).setEutOverride(GTValues.VA[4]);
        ((BlastProperty)Materials.Neptunium.getProperty(PropertyKey.BLAST)).setDurationOverride(280);
        ((BlastProperty)Materials.Neptunium.getProperty(PropertyKey.BLAST)).setVacuumEutOverride(GTValues.VA[2]);
        ((BlastProperty)Materials.Neptunium.getProperty(PropertyKey.BLAST)).setVacuumDurationOverride(125);
        Materials.Technetium.setProperty(PropertyKey.BLAST, (IMaterialProperty)new BlastProperty(2800));
        ((BlastProperty)Materials.Technetium.getProperty(PropertyKey.BLAST)).setEutOverride(GTValues.VA[5]);
        ((BlastProperty)Materials.Technetium.getProperty(PropertyKey.BLAST)).setDurationOverride(300);
        ((BlastProperty)Materials.Technetium.getProperty(PropertyKey.BLAST)).setVacuumEutOverride(GTValues.VA[3]);
        ((BlastProperty)Materials.Technetium.getProperty(PropertyKey.BLAST)).setVacuumDurationOverride(90);
        Materials.Inconel718.setProperty(PropertyKey.FLUID_PIPE, (IMaterialProperty)new FluidPipeProperties(2010, 175, true, true, true, false));
        Materials.RhodiumPlatedPalladium.setProperty(PropertyKey.FLUID_PIPE, (IMaterialProperty)new FluidPipeProperties(6120, 225, true, true, true, false));
        Materials.Rutherfordium.setProperty(PropertyKey.WIRE, (IMaterialProperty)new WireProperties((int)GTValues.V[7], 8, 2));
        Materials.Seaborgium.setProperty(PropertyKey.WIRE, (IMaterialProperty)new WireProperties((int)GTValues.V[10], 4, 16));
        Materials.Naquadah.setProperty(PropertyKey.TOOL, (IMaterialProperty)new MaterialToolProperty(20.0f, 8.0f, 2048, 4));
        Materials.Iridium.setProperty(PropertyKey.TOOL, (IMaterialProperty)new MaterialToolProperty(4.8f, 10.0f, 2560, 4));
    }

    public final void setOreProperties() {
        Materials.Andradite.setProperty(PropertyKey.ORE, (IMaterialProperty)new OreProperty());
        Materials.Biotite.setProperty(PropertyKey.ORE, (IMaterialProperty)new OreProperty());
        Materials.Uvarovite.setProperty(PropertyKey.ORE, (IMaterialProperty)new OreProperty());
        Materials.Plutonium239.setProperty(PropertyKey.ORE, (IMaterialProperty)new OreProperty());
        Materials.Uranium.setProperty(PropertyKey.ORE, (IMaterialProperty)new OreProperty());
        Materials.Plutonium241.setProperty(PropertyKey.ORE, (IMaterialProperty)new OreProperty());
        Materials.Chrome.setProperty(PropertyKey.ORE, (IMaterialProperty)new OreProperty());
        Materials.Cadmium.setProperty(PropertyKey.ORE, (IMaterialProperty)new OreProperty());
        OreProperty oreProp = (OreProperty)Materials.Andradite.getProperty(PropertyKey.ORE);
        Material[] materialArray = new Material[]{Materials.Andradite, Materials.Andradite, Materials.Calcium};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getDolomite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getDolomite(), Materials.Calcium, Materials.Magnesium};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getTanzanite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getTanzanite(), Materials.Opal, Materials.Aluminium};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getAzurite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Iron, Materials.Copper, Materials.Malachite};
        oreProp.setOreByProducts(materialArray);
        oreProp.setWashedIn(Materials.SodiumPersulfate);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getForsterite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getForsterite(), Materials.Magnesium, Materials.Manganese};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getAugite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Calcite, Materials.SiliconDioxide, GTLiteMaterials.INSTANCE.getKaolinite()};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getAlbite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getAlbite(), Materials.Sodium, Materials.Silicon};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getFluorite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getFluorite(), Materials.Calcium, Materials.Calcium};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getAnorthite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Calcium, Materials.Silicon, Materials.Aluminium};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getOligoclase().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getAnorthite(), GTLiteMaterials.INSTANCE.getOligoclase(), Materials.Aluminium};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getLabradorite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getAlbite(), Materials.Silicon, Materials.Aluminium};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getBytownite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getAnorthite(), Materials.Calcium, Materials.Aluminium};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getTenorite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Iron, Materials.Manganese, Materials.Malachite};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getCuprite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Iron, Materials.Antimony, Materials.Malachite};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getWollastonite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getWollastonite(), Materials.Calcium, Materials.Silicon};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getFluorapatite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getFluorapatite(), Materials.Apatite, Materials.Phosphorus};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getKaolinite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Clay, Materials.Clay, Materials.SiliconDioxide};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getCelestine().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getCelestine(), GTLiteMaterials.INSTANCE.getCelestine(), GTLiteMaterials.INSTANCE.getStrontiumOxide()};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getStrontianite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getStrontianite(), Materials.Calcite, GTLiteMaterials.INSTANCE.getStrontiumOxide()};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getMuscovite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Mica, GTLiteMaterials.INSTANCE.getMuscovite(), GTLiteMaterials.INSTANCE.getPhlogopite()};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getPhlogopite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getMuscovite(), GTLiteMaterials.INSTANCE.getPhlogopite(), Materials.Mica};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getBaddeleyite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getBaddeleyite(), GTLiteMaterials.INSTANCE.getBaddeleyite(), Materials.Zircon};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getNephelite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getNephelite(), GTLiteMaterials.INSTANCE.getAlbite(), Materials.Silicon};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getAegirine().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getAegirine(), GTLiteMaterials.INSTANCE.getFerrosilite(), Materials.Iron};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getCryolite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getAlumina(), GTLiteMaterials.INSTANCE.getAlumina(), Materials.Sodium};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getJade().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getJade(), GTLiteMaterials.INSTANCE.getJasper(), Materials.Emerald};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getJasper().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getJasper(), GTLiteMaterials.INSTANCE.getJade(), Materials.SiliconDioxide};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getPicotite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getPicotite(), Materials.Chrome, Materials.Chrome};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getOrpiment().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Sulfur, Materials.Antimony, Materials.Realgar};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)Materials.Biotite.getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getPhlogopite(), GTLiteMaterials.INSTANCE.getMuscovite(), Materials.Biotite};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)GTLiteMaterials.INSTANCE.getFerrosilite().getProperty(PropertyKey.ORE);
        materialArray = new Material[]{GTLiteMaterials.INSTANCE.getFerrosilite(), Materials.SiliconDioxide, Materials.Iron};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)Materials.Uvarovite.getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Quartzite, Materials.Uvarovite, GTLiteMaterials.INSTANCE.getLizardite()};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)Materials.Uranium.getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Uranium, Materials.Uranium238, Materials.Uranium235};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)Materials.Plutonium239.getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Plutonium239, Materials.Plutonium239, Materials.Plutonium241};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)Materials.Plutonium241.getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Plutonium241, Materials.Plutonium239, Materials.Plutonium241};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)Materials.Thorium.getProperty(PropertyKey.ORE);
        materialArray = new Material[]{Materials.Uraninite, Materials.Lead, Materials.Actinium};
        oreProp.setOreByProducts(materialArray);
        oreProp = (OreProperty)Materials.Molybdenite.getProperty(PropertyKey.ORE);
        oreProp.setDirectSmeltResult(null);
    }

    public final void setMaterialColors() {
        Materials.Promethium.setMaterialRGB(2405685);
        Materials.Dysprosium.setMaterialRGB(0xDD79DD);
        Materials.Erbium.setMaterialRGB(0xCC6633);
        Materials.Holmium.setMaterialRGB(12815919);
        Materials.Terbium.setMaterialRGB(10646690);
        Materials.Thulium.setMaterialRGB(5860290);
        Materials.Nobelium.setMaterialRGB(16168447);
        Materials.Lawrencium.setMaterialRGB(12535381);
        Materials.Tellurium.setMaterialRGB(14866625);
        Materials.RawGrowthMedium.setMaterialRGB(732690);
        Materials.Meitnerium.setMaterialRGB(10231381);
    }

    public final void setChemicalFormula() {
        Materials.Biotite.setFormula("KMg3Al2(AlSi3O10)F2", true);
        Materials.Mica.setFormula("KAl2(AlSi3O10)F2", true);
        Materials.Bauxite.setFormula("(Al2O3)3(TiO2)2(H2O)2?", true);
        Materials.Graphene.setFormula("C8", true);
        Materials.PalladiumRaw.setFormula("PdCl2", true);
        Materials.RarestMetalMixture.setFormula("IrOs?", true);
        Materials.IridiumMetalResidue.setFormula("Ir2O3", true);
        GTLiteMaterials.INSTANCE.getDegenerateRhenium().setFormula("\u00a7cR\u00a7de", true);
        GTLiteMaterials.INSTANCE.getDolomite().setFormula("CaMg(CO3)2", true);
        GTLiteMaterials.INSTANCE.getAzurite().setFormula("Cu3(CO3)2(OH)2", true);
        GTLiteMaterials.INSTANCE.getForsterite().setFormula("Mg2(SiO4)", true);
        GTLiteMaterials.INSTANCE.getAugite().setFormula("(Ca2MgFe)(MgFe)2(Si2O6)4", true);
        GTLiteMaterials.INSTANCE.getLizardite().setFormula("Mg3Si2O5(OH)4", true);
        GTLiteMaterials.INSTANCE.getMuscovite().setFormula("KAl2(AlSi3O10)(OH)2", true);
        GTLiteMaterials.INSTANCE.getClinochlore().setFormula("Mg5Al2Si3O10(OH)8", true);
        GTLiteMaterials.INSTANCE.getFluorapatite().setFormula("Ca5(PO4)3F", true);
        GTLiteMaterials.INSTANCE.getLignite().setFormula("C3(H2O)", true);
        GTLiteMaterials.INSTANCE.getFirestone().setFormula("(SiO2)3(FeS2)?", true);
        GTLiteMaterials.INSTANCE.getIron3Sulfate().setFormula("Fe2(SO4)3", true);
        GTLiteMaterials.INSTANCE.getPhlogopite().setFormula("KMg3(AlSi3O10)F2", true);
        GTLiteMaterials.INSTANCE.getNephelite().setFormula("KNa3(AlSiO4)4", true);
        GTLiteMaterials.INSTANCE.getHeavyAlkaliChloridesSolution().setFormula("(RbCl)(CsCl)2Cl3(H2O)2", true);
        GTLiteMaterials.INSTANCE.getAluminiumHydroxide().setFormula("Al(OH)3", true);
        GTLiteMaterials.INSTANCE.getAluminiumSulfate().setFormula("Al2(SO4)3", true);
        GTLiteMaterials.INSTANCE.getZSM5().setFormula("Na(Al2(SO4)3)(SiO2)2(H2O)2", true);
        GTLiteMaterials.INSTANCE.getJasper().setFormula("CaMg5(OH)2(Si4O11)2", true);
        GTLiteMaterials.INSTANCE.getLeadNitrate().setFormula("Pb(NO3)2", true);
        GTLiteMaterials.INSTANCE.getTitaniumNitrate().setFormula("Ti(NO3)4", true);
        GTLiteMaterials.INSTANCE.getPalladiumNitrate().setFormula("Pd(NO3)2", true);
        GTLiteMaterials.INSTANCE.getPalladiumAcetate().setFormula("Pd(CH3COOH)2", true);
        GTLiteMaterials.INSTANCE.getDimethylcadmium().setFormula("(CH3)2Cd", true);
        GTLiteMaterials.INSTANCE.getZBLANGlass().setFormula("(ZrF4)5(BaF2)2(LaF3)(AlF3)(NaF)2", true);
        GTLiteMaterials.INSTANCE.getErbiumDopedZBLANGlass().setFormula("(ZrF4)5(BaF2)2(LaF3)(AlF3)(NaF)2Er", true);
        GTLiteMaterials.INSTANCE.getPraseodymiumDopedZBLANGlass().setFormula("(ZrF4)5(BaF2)2(LaF3)(AlF3)(NaF)2Pr", true);
        GTLiteMaterials.INSTANCE.getCubicZirconia().setFormula("c-ZrO2", true);
        GTLiteMaterials.INSTANCE.getMagnetoResonatic().setFormula("(Bi2Te3)4((SiO2)5Fe)3(ZrO2)Fe", true);
        GTLiteMaterials.INSTANCE.getPlatinumGroupResidue().setFormula("RuRhIr2Os(HNO3)3", true);
        GTLiteMaterials.INSTANCE.getPlatinumGroupConcentrate().setFormula("AuPtPd(HCl)6", true);
        GTLiteMaterials.INSTANCE.getPurifiedPlatinumGroupConcentrate().setFormula("H2PtPdCl6", true);
        GTLiteMaterials.INSTANCE.getAmmoniumHexachloroplatinate().setFormula("(NH4)2PtCl6", true);
        GTLiteMaterials.INSTANCE.getAmmoniumHexachloropalladate().setFormula("(NH4)2PdCl6", true);
        GTLiteMaterials.INSTANCE.getYttriumNitrate().setFormula("Y(NO3)3", true);
        GTLiteMaterials.INSTANCE.getBariumNitrate().setFormula("Ba(NO3)2", true);
        GTLiteMaterials.INSTANCE.getCopperNitrate().setFormula("Cu(NO3)2", true);
        GTLiteMaterials.INSTANCE.getRoastedSphalerite().setFormula("(GeO2)?", true);
        GTLiteMaterials.INSTANCE.getZincRichSphalerite().setFormula("Zn2(GaGeO2)?", true);
        GTLiteMaterials.INSTANCE.getWaelzOxide().setFormula("(GeO2)Zn", true);
        GTLiteMaterials.INSTANCE.getWaelzSlag().setFormula("(ZnSO4)Ga", true);
        GTLiteMaterials.INSTANCE.getHydroxyquinolineAluminium().setFormula("(C9H7NO)Al", true);
        GTLiteMaterials.INSTANCE.getBariumHydroxide().setFormula("Ba(OH)2", true);
        GTLiteMaterials.INSTANCE.getAmmoniumNitrate().setFormula("NH4NO3", true);
        GTLiteMaterials.INSTANCE.getBismuthStrontiumCalciumCuprate().setFormula("Bi2Sr2CaCu2O8", true);
        GTLiteMaterials.INSTANCE.getAdamantiumUnstable().setFormula("Ad*", true);
        GTLiteMaterials.INSTANCE.getVibraniumUnstable().setFormula("Vb*", true);
        GTLiteMaterials.INSTANCE.getLithiumSodiumPotassiumFluorides().setFormula("F3LiNaK", true);
        GTLiteMaterials.INSTANCE.getLithiumBerylliumFluorides().setFormula("F3LiBe", true);
        GTLiteMaterials.INSTANCE.getFleroviumYtterbiumPlasma().setFormula("FlY?", true);
        GTLiteMaterials.INSTANCE.getSodiumAcetate().setFormula("C2H3NaO2", true);
        GTLiteMaterials.INSTANCE.getHexagonalBoronNitride().setFormula("h-BN", true);
        GTLiteMaterials.INSTANCE.getCubicBoronNitride().setFormula("c-BN", true);
        GTLiteMaterials.INSTANCE.getAmorphousBoronNitride().setFormula("a-BN", true);
        GTLiteMaterials.INSTANCE.getCubicHeterodiamond().setFormula("c-BC2N", true);
        GTLiteMaterials.INSTANCE.getCalciumHydroxide().setFormula("Ca(OH)2", true);
        GTLiteMaterials.INSTANCE.getAluminiumNitrate().setFormula("Al(NO3)3", true);
        GTLiteMaterials.INSTANCE.getChlorinatedSolvents().setFormula("(CH4)2Cl5", true);
        GTLiteMaterials.INSTANCE.getAluminaSolution().setFormula("(Al2O3)(CH2Cl2)(C12H27N)2", true);
        GTLiteMaterials.INSTANCE.getNdYAG().setFormula("Nd:YAG", true);
        GTLiteMaterials.INSTANCE.getPoloniumNitrate().setFormula("Po(NO3)4", true);
        GTLiteMaterials.INSTANCE.getSodiumPolonate().setFormula("Na2PoO4", true);
        GTLiteMaterials.INSTANCE.getUranylNitrateSolution().setFormula("(UO2)(NO3)2(H2O)?", true);
        GTLiteMaterials.INSTANCE.getThoriumNitrate().setFormula("Th(NO3)4", true);
        GTLiteMaterials.INSTANCE.getUranylNitrate().setFormula("UO2(NO3)2", true);
        GTLiteMaterials.INSTANCE.getActiniumOxalate().setFormula("Ac(CO2)4", true);
        GTLiteMaterials.INSTANCE.getSodiumFormate().setFormula("HCOONa", false);
        GTLiteMaterials.INSTANCE.getBETSPerrhenate().setFormula("(C10H8S4Se4)ReO4", true);
        GTLiteMaterials.INSTANCE.getSilicaGelBase().setFormula("(SiNa(OH)O2)(HCl)(H2O)", true);
        GTLiteMaterials.INSTANCE.getAmmoniumSulfate().setFormula("(NH4)2SO4", true);
        GTLiteMaterials.INSTANCE.getAmmoniumCarbonate().setFormula("(NH4)2CO3", true);
        GTLiteMaterials.INSTANCE.getAmmoniumAcetate().setFormula("NH4CH3CO2", true);
        GTLiteMaterials.INSTANCE.getAmmoniumPersulfate().setFormula("(NH4)2S2O8", true);
        GTLiteMaterials.INSTANCE.getPalladiumFullereneMatrix().setFormula("(C73H15NFe)Pd", true);
        GTLiteMaterials.INSTANCE.getLuTmYChloridesSolution().setFormula("(LuCl3)2(TmCl3)2(YCl3)6(H2O)15", true);
        GTLiteMaterials.INSTANCE.getLuTmDopedYttriumVanadateDeposition().setFormula("Lu/Tm:YVO?", false);
        GTLiteMaterials.INSTANCE.getLuTmYVO().setFormula("Lu/Tm:YVO", false);
        GTLiteMaterials.INSTANCE.getHexagonalSiliconNitride().setFormula("h-Si3N4", true);
        GTLiteMaterials.INSTANCE.getCubicSiliconNitride().setFormula("c-Si3N4", true);
        GTLiteMaterials.INSTANCE.getCeriumCarbonate().setFormula("Ce2(CO3)3", true);
        GTLiteMaterials.INSTANCE.getPlutoniumTrihydride().setFormula("PuH3", true);
        GTLiteMaterials.INSTANCE.getPlutoniumPhosphide().setFormula("PuP", true);
        GTLiteMaterials.INSTANCE.getLanthanumFullereneMixture().setFormula("(C60H30)2La2", true);
        GTLiteMaterials.INSTANCE.getLanthanumEmbeddedFullerene().setFormula("(C60)2La2", true);
        GTLiteMaterials.INSTANCE.getLanthanumFullereneNanotube().setFormula("C48C60La", true);
        GTLiteMaterials.INSTANCE.getPrHoYNitratesSolution().setFormula("(Pr(NO3)3)2(Ho(NO3)3)2(Y(NO3)3)6(H2O)15", true);
        GTLiteMaterials.INSTANCE.getPrHoYLF().setFormula("Pr/Ho:YLF", true);
        GTLiteMaterials.INSTANCE.getTrichlorocyclopentadienylTitanium().setFormula("(C5H5)2Cl3Ti", true);
        GTLiteMaterials.INSTANCE.getPhotopolymerSolution().setFormula("C149H97N10O2(TiBF20)", true);
        GTLiteMaterials.INSTANCE.getPotassiumFerrocyanideTrihydrate().setFormula("K4Fe(CN)6(H2O)3", true);
        GTLiteMaterials.INSTANCE.getPrussianBlue().setFormula("Fe4[Fe(CN)6]3", true);
        GTLiteMaterials.INSTANCE.getCopperArsenite().setFormula("Cu3(AsO4)2", true);
        GTLiteMaterials.INSTANCE.getThalliumThuliumDopedCaesiumIodide().setFormula("Tl/Tm:CsI", false);
        GTLiteMaterials.INSTANCE.getSodiumAlginate().setFormula("C5H7O4COONa", true);
        GTLiteMaterials.INSTANCE.getCalciumAlginate().setFormula("(C5H7O4COO)2Ca", true);
        GTLiteMaterials.INSTANCE.getChromaticGlass().setFormula("(SiO2)64", true);
        GTLiteMaterials.INSTANCE.getPlutoniumDioxide().setFormula("PuO2", true);
        GTLiteMaterials.INSTANCE.getMOX().setFormula("(PuO2)(UO2)2", true);
        GTLiteMaterials.INSTANCE.getKovar().setFormula("Fe10Ni5Co3", true);
        GTLiteMaterials.INSTANCE.getHalkoniteSteel().setFormula("SpNt2((FeW)8*Nq*7?4C4(VCrFe7)3Fr)2P8(((WC)(TiC)2)3(CaMg5(OH)2(Si4O11)2)3Tr2)If", true);
        GTLiteMaterials.INSTANCE.getTantalumHafniumSeaborgiumCarbide().setFormula("Ta12Hf3SgC16", true);
        GTLiteMaterials.INSTANCE.getActiniumGroupAlloyA().setFormula("AcThPaUNpPuAmCm", true);
        GTLiteMaterials.INSTANCE.getTransitionAlloy().setFormula("TiVCrMnFeCoNiCuAlZnGaGeCdInSnSb", true);
        GTLiteMaterials.INSTANCE.getRareEarthAlloy().setFormula("LaCePrNdPmSmEuGdTbDyHoErTmYbLuScYAcThPaUNpPuAmCmBkCfEsFmMdNoLr", true);
        GTLiteMaterials.INSTANCE.getPeriodicium().setFormula("HHeLiBeBCNOFNeNaMgAlSiPSClArKCaScTiVCrMnFeCoNiCuZnGaGeAsSeBrKrRbSrYZrNbMoTcRuRhPdAgCdInSnSbTeIXeCsBaLaCePrNdPmSmEuGdTbDyHoErTmYbLuHfTaWReOsIrPtAuHgTlPbBiPoAtRnFrRaAcThPaUNpPuAmCmBkCfEsFmMdNoLrRfDbSgBhHsMtDsRgCnNhFlMcLvTsOg");
        GTLiteMaterials.INSTANCE.getLimestone().setFormula("(CaCO3)4(CaMg(CO3)2)?", true);
        GTLiteMaterials.INSTANCE.getKomatiite().setFormula("(Mg2Fe(SiO2)2)2(MgCO3)(SiO2)?", true);
        GTLiteMaterials.INSTANCE.getGreenSchist().setFormula("(Ca2Al3Si3HO13)2(SiO2)2(Mg3Si4H2O12)?", true);
        GTLiteMaterials.INSTANCE.getBlueSchist().setFormula("(Cu3(CO3)2(OH)2)3(Al3Si3Na4Cl)2?", true);
        GTLiteMaterials.INSTANCE.getKimberlite().setFormula("(Mg2(SiO4))3((Ca2MgFe)(MgFe)2(Si2O6)4)3(Ca3Fe2Si3O12)2?", true);
        GTLiteMaterials.INSTANCE.getSlate().setFormula("(SiO2)5(KAl2(AlSi3O10)(OH)2)2(Mg5Al2Si3O10(OH)8)2?", true);
        GTLiteMaterials.INSTANCE.getShale().setFormula("(CaCO3)6(Na2LiAl2Si2(H2O)6)2(SiO2)(CaF2)?", true);
        GTLiteMaterials.INSTANCE.getGelidCryotheum().setFormula("((Si(FeS2)5(CrAl2O3)Hg3)(AgAu))(H2O)3", true);
        GTLiteMaterials.INSTANCE.getParaXylene().setFormula("C6H4(CH3)2", true);
        GTLiteMaterials.INSTANCE.getNitrotoluene().setFormula("C6H4CH3NO2", true);
        GTLiteMaterials.INSTANCE.getButanediol().setFormula("C4H8(OH)2", true);
        GTLiteMaterials.INSTANCE.getTetrahydrofuran().setFormula("(CH2)4O", true);
        GTLiteMaterials.INSTANCE.getDiethylhexylPhosphoricAcid().setFormula("(C8H7O)2PO2H", true);
        GTLiteMaterials.INSTANCE.getFormicAcid().setFormula("HCOOH", true);
        GTLiteMaterials.INSTANCE.getMethylFormate().setFormula("HCO2CH3", true);
        GTLiteMaterials.INSTANCE.getPhthalicAnhydride().setFormula("C6H4(CO)2O", true);
        GTLiteMaterials.INSTANCE.getEthylanthraquinone().setFormula("C6H4(CO)2C6H3Et", true);
        GTLiteMaterials.INSTANCE.getEthylanthrahydroquinone().setFormula("C6H4(CH2OH)2C6H3Et", true);
        GTLiteMaterials.INSTANCE.getDurene().setFormula("C6H2(CH3)4", true);
        GTLiteMaterials.INSTANCE.getPyromelliticDianhydride().setFormula("C6H2(C2O3)2", true);
        GTLiteMaterials.INSTANCE.getAniline().setFormula("C6H5NH2", true);
        GTLiteMaterials.INSTANCE.getOxydianiline().setFormula("O(C6H4NH2)2", true);
        GTLiteMaterials.INSTANCE.getKaptonK().setFormula("(C7H2N2O4)(O(C6H4)2)", true);
        GTLiteMaterials.INSTANCE.getBiphenylTetracarboxylicAcidDianhydride().setFormula("(C8H3O3)2", true);
        GTLiteMaterials.INSTANCE.getNitroaniline().setFormula("H2NC6H4NO2", true);
        GTLiteMaterials.INSTANCE.getParaPhenylenediamine().setFormula("H2NC6H4NH2", true);
        GTLiteMaterials.INSTANCE.getKaptonE().setFormula("O(C6H4NH2)2", true);
        GTLiteMaterials.INSTANCE.getEthyleneGlycol().setFormula("C2H4(OH)2", true);
        GTLiteMaterials.INSTANCE.getPolystyreneSulfonate().setFormula("C8H7SO3H", true);
        GTLiteMaterials.INSTANCE.getMethylamine().setFormula("CH3NH2", true);
        GTLiteMaterials.INSTANCE.getTrimethylamine().setFormula("(CH3)3N", true);
        GTLiteMaterials.INSTANCE.getTetramethylammoniumChloride().setFormula("N(CH3)4Cl", true);
        GTLiteMaterials.INSTANCE.getTetramethylammoniumHydroxide().setFormula("N(CH3)4OH", true);
        GTLiteMaterials.INSTANCE.getEthylenediamine().setFormula("C2H4(NH2)2", true);
        GTLiteMaterials.INSTANCE.getRawPolyphosphonitrileFluoroRubber().setFormula("(CH2CF3)6(CH2C3F7)2(C2F4)2(NPO)4O4", true);
        GTLiteMaterials.INSTANCE.getPolyphosphonitrileFluoroRubber().setFormula("(CH2CF3)6(CH2C3F7)2(C2F4)2(NPO)4O4", true);
        GTLiteMaterials.INSTANCE.getPolytetrahydrofuran().setFormula("(C4H8O)OH2", true);
        GTLiteMaterials.INSTANCE.getDiaminotoluene().setFormula("C6H3(NH2)2CH3", true);
        GTLiteMaterials.INSTANCE.getTolueneDiisocyanate().setFormula("CH3C6H3(NCO)2", true);
        GTLiteMaterials.INSTANCE.getTolueneTetramethylDiisocyanate().setFormula("(CONH)2(C6H4)2CH2(C4O)", true);
        GTLiteMaterials.INSTANCE.getRawPolytetramethyleneGlycolRubber().setFormula("(CONH)2(C6H4)2CH2(C4O)HO(CH2)4OH", true);
        GTLiteMaterials.INSTANCE.getPolytetramethyleneGlycolRubber().setFormula("(CONH)2(C6H4)2CH2(C4O)HO(CH2)4OH", true);
        GTLiteMaterials.INSTANCE.getDifluorobenzophenone().setFormula("(FC6H4)2CO", true);
        GTLiteMaterials.INSTANCE.getHydroquinone().setFormula("C6H4(OH)2", true);
        GTLiteMaterials.INSTANCE.getIsochloropropane().setFormula("CH3CHClCH3", true);
        GTLiteMaterials.INSTANCE.getDinitrodipropanyloxybenzene().setFormula("C12H16O2(NO2)2", true);
        GTLiteMaterials.INSTANCE.getTerephthalicAcid().setFormula("C6H4(CO2H)2", true);
        GTLiteMaterials.INSTANCE.getBistrichloromethylbenzene().setFormula("C6H4(CCl3)2", true);
        GTLiteMaterials.INSTANCE.getTerephthaloylChloride().setFormula("C6H4(COCl)2", true);
        GTLiteMaterials.INSTANCE.getKevlar().setFormula("(C6H4)2(CO)2(NH)2", true);
        GTLiteMaterials.INSTANCE.getTrimethylaluminium().setFormula("Al2(CH3)6", true);
        GTLiteMaterials.INSTANCE.getTrimethylgallium().setFormula("Ga(CH3)3", true);
        GTLiteMaterials.INSTANCE.getAmmoniumCyanate().setFormula("NH4CNO", true);
        GTLiteMaterials.INSTANCE.getButanol().setFormula("C4H9OH", true);
        GTLiteMaterials.INSTANCE.getTributylamine().setFormula("(C4H9)3N", true);
        GTLiteMaterials.INSTANCE.getDiethylEther().setFormula("(C2H5)2O", true);
        GTLiteMaterials.INSTANCE.getBenzylBromide().setFormula("C6H5CH2Br", true);
        GTLiteMaterials.INSTANCE.getBenzyltrimethylammoniumBromide().setFormula("C6H5CH2N(CH3)3Br", true);
        GTLiteMaterials.INSTANCE.getIndene().setFormula("C6H4C3H4", true);
        GTLiteMaterials.INSTANCE.getIndanone().setFormula("C6H4C3H4O", true);
        GTLiteMaterials.INSTANCE.getBromobutane().setFormula("C4H9Br", true);
        GTLiteMaterials.INSTANCE.getButyllithium().setFormula("C4H9Li", true);
        GTLiteMaterials.INSTANCE.getAcetylChloride().setFormula("CH3COCl", true);
        GTLiteMaterials.INSTANCE.getDimethylacetamide().setFormula("(CH3)2NC(O)CH3", true);
        GTLiteMaterials.INSTANCE.getSuccinicAnhydride().setFormula("(CH2CO)2O", true);
        GTLiteMaterials.INSTANCE.getNHydroxysuccinimide().setFormula("(CH2CO)2NOH", true);
        GTLiteMaterials.INSTANCE.getDimethylamineHydrochloride().setFormula("C2H8NCl", true);
        GTLiteMaterials.INSTANCE.getDimethylformamide().setFormula("(CH3)2NC(O)H", true);
        GTLiteMaterials.INSTANCE.getAcetonitrile().setFormula("CH3CN", true);
        GTLiteMaterials.INSTANCE.getAcetamide().setFormula("CH3CONH2", true);
        GTLiteMaterials.INSTANCE.getHexamethylenetetramine().setFormula("(CH2)6N4", true);
        GTLiteMaterials.INSTANCE.getTrimethyltinChloride().setFormula("(CH3)3SnCl", true);
        GTLiteMaterials.INSTANCE.getDimethylaminopyridine().setFormula("(CH3)2NC5H4N", true);
        GTLiteMaterials.INSTANCE.getTriphenylphosphine().setFormula("(C6H5)3P", true);
        GTLiteMaterials.INSTANCE.getDimethylSulfide().setFormula("(CH3)2S", true);
        GTLiteMaterials.INSTANCE.getFullerenePolymerMatrix().setFormula("(C153H36NO2)PdFe", true);
        GTLiteMaterials.INSTANCE.getMethyltrichlorosilane().setFormula("Si(CH3)Cl3", true);
        GTLiteMaterials.INSTANCE.getDiethylSulfide().setFormula("(C2H5)2S", true);
        GTLiteMaterials.INSTANCE.getPhenothiazine().setFormula("C12H9NS", true);
        GTLiteMaterials.INSTANCE.getIsopropylChloride().setFormula("(CH3)2CHCl", true);
        GTLiteMaterials.INSTANCE.getAmmoniumBifluoride().setFormula("NH4HF2", true);
        GTLiteMaterials.INSTANCE.getTetraethylammoniumBromide().setFormula("N(CH2CH3)4Br", true);
        GTLiteMaterials.INSTANCE.getPhenylsodium().setFormula("C6H5Na", true);
        GTLiteMaterials.INSTANCE.getTetrabromoindigo().setFormula("C16H6Br4N2O2", true);
        GTLiteMaterials.INSTANCE.getCyanIndigo().setFormula("(C16H10N2O2)2Br4", true);
        GTLiteMaterials.INSTANCE.getNaphthylamine().setFormula("C10H8NH", true);
        GTLiteMaterials.INSTANCE.getTrisaminoethylamine().setFormula("(NH2CH2CH2)3N", true);
        GTLiteMaterials.INSTANCE.getEthylamine().setFormula("C2H5NH2", true);
        GTLiteMaterials.INSTANCE.getDiethylthiourea().setFormula("(C2H5NH)2CS", true);
        GTLiteMaterials.INSTANCE.getBFGF().setFormula("bFGF", false);
        GTLiteMaterials.INSTANCE.getEGF().setFormula("EGF", false);
        GTLiteMaterials.INSTANCE.getCAT().setFormula("CAT", false);
        GTLiteMaterials.INSTANCE.getGreenhouseGas().setFormula("N78O21Ar9?", true);
        GTLiteMaterials.INSTANCE.getFat().setFormula("C57H110O6", true);
        GTLiteMaterials.INSTANCE.getSeaWater().setFormula("H2O?", true);
        GTLiteMaterials.INSTANCE.getAcidicSaltWater().setFormula("(H2O)(H2SO4)?", true);
        GTLiteMaterials.INSTANCE.getUnprocessedNdYAGSolution().setFormula("Nd:YAG?", false);
        GTLiteMaterials.INSTANCE.getAxinoFusedRedMatter().setFormula(CommonI18n.format("gtlitecore.material.axino_fused_red_matter.formula", "Hot Dark Matter formed by the Aggregation of Dark Matter and Supersymmetric Axions"));
    }
}

