/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.unification.material.properties;

import com.google.common.collect.ImmutableList;
import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.stack.MaterialStack;
import gregtechlite.gtlitecore.api.unification.material.info.GTLiteMaterialFlags;
import gregtechlite.gtlitecore.api.unification.material.properties.AlloyBlastProperty;
import gregtechlite.gtlitecore.api.unification.material.properties.GTLitePropertyKey;
import gregtechlite.gtlitecore.loader.recipe.producer.CustomAlloyBlastRecipeProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lgregtechlite/gtlitecore/api/unification/material/properties/AlloyBlastPropertyAdder;", "", "<init>", "()V", "preInitABSProperties", "", "initABSProperties", "addAlloyBlastProperty", "material", "Lgregtech/api/unification/material/Material;", "isMaterialStackFluidOnly", "", "materialStack", "Lgregtech/api/unification/stack/MaterialStack;", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nAlloyBlastPropertyAdder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlloyBlastPropertyAdder.kt\ngregtechlite/gtlitecore/api/unification/material/properties/AlloyBlastPropertyAdder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n774#2:55\n865#2,2:56\n1863#2,2:58\n774#2:60\n865#2,2:61\n*S KotlinDebug\n*F\n+ 1 AlloyBlastPropertyAdder.kt\ngregtechlite/gtlitecore/api/unification/material/properties/AlloyBlastPropertyAdder\n*L\n18#1:55\n18#1:56,2\n19#1:58,2\n42#1:60\n42#1:61,2\n*E\n"})
public final class AlloyBlastPropertyAdder {
    @NotNull
    public static final AlloyBlastPropertyAdder INSTANCE = new AlloyBlastPropertyAdder();

    private AlloyBlastPropertyAdder() {
    }

    /*
     * WARNING - void declaration
     */
    public final void preInitABSProperties() {
        void $this$filterTo$iv$iv;
        Collection collection = GregTechAPI.materialManager.getRegisteredMaterials();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredMaterials(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Material mat = (Material)element$iv$iv;
            boolean bl = false;
            if (!(!mat.hasFlag(GTLiteMaterialFlags.INSTANCE.getDISABLE_ALLOY_PROPERTY()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Material p0 = (Material)element$iv;
            boolean bl = false;
            this.addAlloyBlastProperty(p0);
        }
    }

    public final void initABSProperties() {
        AlloyBlastProperty property = (AlloyBlastProperty)Materials.NiobiumNitride.getProperty(GTLitePropertyKey.ALLOY_BLAST);
        property.setRecipeProducer(new CustomAlloyBlastRecipeProducer(1, 11, -1));
        property = (AlloyBlastProperty)Materials.IndiumTinBariumTitaniumCuprate.getProperty(GTLitePropertyKey.ALLOY_BLAST);
        property.setRecipeProducer(new CustomAlloyBlastRecipeProducer(-1, -1, 16));
    }

    /*
     * WARNING - void declaration
     */
    private final void addAlloyBlastProperty(Material material) {
        void $this$filterTo$iv$iv;
        ImmutableList components = material.getMaterialComponents();
        if (components.size() < 2) {
            return;
        }
        if (!material.hasProperty(PropertyKey.BLAST) || !material.hasProperty(PropertyKey.FLUID)) {
            return;
        }
        Intrinsics.checkNotNull((Object)components);
        Iterable $this$filter$iv = (Iterable)components;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MaterialStack p0 = (MaterialStack)element$iv$iv;
            boolean bl = false;
            if (!this.isMaterialStackFluidOnly(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (((Collection)CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)3)).size() > 2) {
            return;
        }
        material.setProperty(GTLitePropertyKey.ALLOY_BLAST, (IMaterialProperty)new AlloyBlastProperty(material.getBlastTemperature()));
    }

    private final boolean isMaterialStackFluidOnly(MaterialStack materialStack) {
        return !materialStack.material.hasProperty(PropertyKey.DUST) && materialStack.material.hasProperty(PropertyKey.FLUID);
    }
}

