/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.recipe.property;

import gregtech.api.recipes.properties.RecipeProperty;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0003R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lgregtechlite/gtlitecore/api/recipe/property/MobOnTopProperty;", "Lgregtech/api/recipes/properties/RecipeProperty;", "Lnet/minecraft/util/ResourceLocation;", "<init>", "()V", "playerEntity", "getPlayerEntity", "()Lnet/minecraft/util/ResourceLocation;", "serialize", "Lnet/minecraft/nbt/NBTTagString;", "value", "", "deserialize", "nbt", "Lnet/minecraft/nbt/NBTBase;", "drawInfo", "", "mc", "Lnet/minecraft/client/Minecraft;", "x", "", "y", "color", "getTranslationName", "", "location", "gtlitecore"})
public final class MobOnTopProperty
extends RecipeProperty<ResourceLocation> {
    @NotNull
    public static final MobOnTopProperty INSTANCE = new MobOnTopProperty();
    @NotNull
    private static final ResourceLocation playerEntity = new ResourceLocation("player");

    private MobOnTopProperty() {
        super("mob_on_top", ResourceLocation.class);
    }

    @NotNull
    public final ResourceLocation getPlayerEntity() {
        return playerEntity;
    }

    @NotNull
    public NBTTagString serialize(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new NBTTagString(((ResourceLocation)this.castValue(value)).toString());
    }

    @NotNull
    public ResourceLocation deserialize(@NotNull NBTBase nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        return new ResourceLocation(((NBTTagString)nbt).func_150285_a_());
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(@NotNull Minecraft mc, int x, int y, int color, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FontRenderer fontRenderer = mc.field_71466_p;
        Object[] objectArray = new Object[1];
        Object object = this.castValue(value);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"castValue(...)");
        objectArray[0] = this.getTranslationName((ResourceLocation)object);
        fontRenderer.func_78276_b(I18n.func_135052_a((String)"gtlitecore.recipe.accepted_entity", (Object[])objectArray), x, y, color);
    }

    @SideOnly(value=Side.CLIENT)
    private final String getTranslationName(ResourceLocation location) {
        String string;
        if (Intrinsics.areEqual((Object)location, (Object)playerEntity)) {
            String string2 = I18n.func_135052_a((String)"gtlitecore.recipe.entity_name.player", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        } else {
            String string3 = I18n.func_135052_a((String)("entity." + EntityList.func_191302_a((ResourceLocation)location) + ".name"), (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        }
        return string;
    }
}

