/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.recipe;

import gregtech.api.GTValues;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.GTRecipeHandler;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.GTRecipeOreInput;
import gregtech.api.unification.material.Materials;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtechlite.gtlitecore.api.extension.RecipeBuilderExtKt;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007\u00a2\u0006\u0002\u0010\rJ)\u0010\u000e\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u000e\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\u000e\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007\u00a2\u0006\u0002\u0010\rJ(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0001H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0001H\u0007J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0007\u00a8\u0006\u001a"}, d2={"Lgregtechlite/gtlitecore/api/recipe/GTLiteRecipeHandler;", "", "<init>", "()V", "removeChemicalRecipes", "", "itemInputs", "", "Lnet/minecraft/item/ItemStack;", "fluidInputs", "Lnet/minecraftforge/fluids/FluidStack;", "([Lnet/minecraft/item/ItemStack;[Lnet/minecraftforge/fluids/FluidStack;)V", "([Lnet/minecraft/item/ItemStack;)V", "([Lnet/minecraftforge/fluids/FluidStack;)V", "removeMixerRecipes", "addIOHatchRecipes", "tier", "", "input", "Lgregtech/api/metatileentity/MetaTileEntity;", "output", "extraInput", "getGTRecipeInput", "Lgregtech/api/recipes/ingredients/GTRecipeInput;", "getGTHatchFluidAmount", "offsetTier", "gtlitecore"})
public final class GTLiteRecipeHandler {
    @NotNull
    public static final GTLiteRecipeHandler INSTANCE = new GTLiteRecipeHandler();

    private GTLiteRecipeHandler() {
    }

    @JvmStatic
    public static final void removeChemicalRecipes(@NotNull ItemStack[] itemInputs, @NotNull FluidStack[] fluidInputs) {
        Intrinsics.checkNotNullParameter((Object)itemInputs, (String)"itemInputs");
        Intrinsics.checkNotNullParameter((Object)fluidInputs, (String)"fluidInputs");
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.CHEMICAL_RECIPES, (ItemStack[])itemInputs, (FluidStack[])fluidInputs);
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.LARGE_CHEMICAL_RECIPES, (ItemStack[])itemInputs, (FluidStack[])fluidInputs);
    }

    @JvmStatic
    public static final void removeChemicalRecipes(@NotNull ItemStack[] itemInputs) {
        Intrinsics.checkNotNullParameter((Object)itemInputs, (String)"itemInputs");
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.CHEMICAL_RECIPES, (ItemStack[])itemInputs, (FluidStack[])new FluidStack[0]);
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.LARGE_CHEMICAL_RECIPES, (ItemStack[])itemInputs, (FluidStack[])new FluidStack[0]);
    }

    @JvmStatic
    public static final void removeChemicalRecipes(@NotNull FluidStack[] fluidInputs) {
        Intrinsics.checkNotNullParameter((Object)fluidInputs, (String)"fluidInputs");
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.CHEMICAL_RECIPES, (ItemStack[])new ItemStack[0], (FluidStack[])fluidInputs);
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.LARGE_CHEMICAL_RECIPES, (ItemStack[])new ItemStack[0], (FluidStack[])fluidInputs);
    }

    @JvmStatic
    public static final void removeMixerRecipes(@NotNull ItemStack[] itemInputs, @NotNull FluidStack[] fluidInputs) {
        Intrinsics.checkNotNullParameter((Object)itemInputs, (String)"itemInputs");
        Intrinsics.checkNotNullParameter((Object)fluidInputs, (String)"fluidInputs");
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.MIXER_RECIPES, (ItemStack[])itemInputs, (FluidStack[])fluidInputs);
        GTRecipeHandler.removeRecipesByInputs(GTLiteRecipeMaps.LARGE_MIXER_RECIPES, (ItemStack[])itemInputs, (FluidStack[])fluidInputs);
    }

    @JvmStatic
    public static final void removeMixerRecipes(@NotNull ItemStack[] itemInputs) {
        Intrinsics.checkNotNullParameter((Object)itemInputs, (String)"itemInputs");
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.MIXER_RECIPES, (ItemStack[])itemInputs, (FluidStack[])new FluidStack[0]);
        GTRecipeHandler.removeRecipesByInputs(GTLiteRecipeMaps.LARGE_MIXER_RECIPES, (ItemStack[])itemInputs, (FluidStack[])new FluidStack[0]);
    }

    @JvmStatic
    public static final void removeMixerRecipes(@NotNull FluidStack[] fluidInputs) {
        Intrinsics.checkNotNullParameter((Object)fluidInputs, (String)"fluidInputs");
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.MIXER_RECIPES, (ItemStack[])new ItemStack[0], (FluidStack[])fluidInputs);
        GTRecipeHandler.removeRecipesByInputs(GTLiteRecipeMaps.LARGE_MIXER_RECIPES, (ItemStack[])new ItemStack[0], (FluidStack[])fluidInputs);
    }

    @JvmStatic
    public static final void addIOHatchRecipes(int tier, @NotNull MetaTileEntity input, @NotNull MetaTileEntity output, @NotNull Object extraInput) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)extraInput, (String)"extraInput");
        GTRecipeInput extra = GTLiteRecipeHandler.getGTRecipeInput(extraInput);
        if (tier <= 1) {
            int glueAmount = tier == 0 ? 250 : 500;
            RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(1)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(Materials.Glue.getFluid(glueAmount))).output(input);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[tier])).duration(300)).buildAndRegister();
            RecipeBuilder recipeBuilder2 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(2)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(Materials.Glue.getFluid(glueAmount))).output(output);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder2, GTValues.VA[tier])).duration(300)).buildAndRegister();
        }
        if (tier <= 3) {
            int plasticAmount = GTLiteRecipeHandler.getGTHatchFluidAmount(tier + 4);
            RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(1)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(Materials.Polyethylene.getFluid(plasticAmount))).output(input);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[tier])).duration(300)).buildAndRegister();
            RecipeBuilder recipeBuilder3 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(2)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(Materials.Polyethylene.getFluid(plasticAmount))).output(output);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder3, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder3, GTValues.VA[tier])).duration(300)).buildAndRegister();
        }
        if (tier <= 6) {
            int ptfeAmount = GTLiteRecipeHandler.getGTHatchFluidAmount(tier + 3);
            RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(1)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(Materials.Polytetrafluoroethylene.getFluid(ptfeAmount))).output(input);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[tier])).duration(300)).buildAndRegister();
            RecipeBuilder recipeBuilder4 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(2)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(Materials.Polytetrafluoroethylene.getFluid(ptfeAmount))).output(output);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder4, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder4, GTValues.VA[tier])).duration(300)).buildAndRegister();
        }
        if (tier <= 8) {
            int pbiAmount = GTLiteRecipeHandler.getGTHatchFluidAmount(tier);
            RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(1)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(Materials.Polybenzimidazole.getFluid(pbiAmount))).output(input);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[tier])).duration(300)).buildAndRegister();
            RecipeBuilder recipeBuilder5 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(2)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(Materials.Polybenzimidazole.getFluid(pbiAmount))).output(output);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder5, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder5, GTValues.VA[tier])).duration(300)).buildAndRegister();
        }
        if (tier <= 10) {
            int kevlarAmount = GTLiteRecipeHandler.getGTHatchFluidAmount(tier - 1);
            RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(1)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(GTLiteMaterials.INSTANCE.getKevlar().getFluid(kevlarAmount))).output(input);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[tier])).duration(300)).buildAndRegister();
            RecipeBuilder recipeBuilder6 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(2)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(GTLiteMaterials.INSTANCE.getKevlar().getFluid(kevlarAmount))).output(output);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder6, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder6, GTValues.VA[tier])).duration(300)).buildAndRegister();
        }
        if (tier <= 12) {
            int fpmAmount = GTLiteRecipeHandler.getGTHatchFluidAmount(tier - 2);
            RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(1)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(GTLiteMaterials.INSTANCE.getFullerenePolymerMatrix().getFluid(fpmAmount))).output(input);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[tier])).duration(300)).buildAndRegister();
            RecipeBuilder recipeBuilder7 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(2)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(GTLiteMaterials.INSTANCE.getFullerenePolymerMatrix().getFluid(fpmAmount))).output(output);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder7, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder7, GTValues.VA[tier])).duration(300)).buildAndRegister();
        }
        if (tier <= 14) {
            int cosmicFabricAmount = GTLiteRecipeHandler.getGTHatchFluidAmount(tier - 4);
            RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(1)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(GTLiteMaterials.INSTANCE.getCosmicFabric().getFluid(cosmicFabricAmount))).output(input);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[tier])).duration(300)).buildAndRegister();
            RecipeBuilder recipeBuilder8 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(2)).input((MetaTileEntity)MetaTileEntities.HULL[tier])).inputs(extra)).fluidInputs(GTLiteMaterials.INSTANCE.getCosmicFabric().getFluid(cosmicFabricAmount))).output(output);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder8, (String)"output(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder8, GTValues.VA[tier])).duration(300)).buildAndRegister();
        }
    }

    @JvmStatic
    @NotNull
    public static final GTRecipeInput getGTRecipeInput(@NotNull Object extraInput) {
        GTRecipeInput gTRecipeInput;
        Intrinsics.checkNotNullParameter((Object)extraInput, (String)"extraInput");
        Object object = extraInput;
        if (object instanceof ItemStack) {
            gTRecipeInput = (GTRecipeInput)new GTRecipeItemInput((ItemStack)extraInput);
        } else if (object instanceof MetaItem.MetaValueItem) {
            gTRecipeInput = (GTRecipeInput)new GTRecipeItemInput(((MetaItem.MetaValueItem)extraInput).getStackForm());
        } else if (object instanceof String) {
            gTRecipeInput = (GTRecipeInput)new GTRecipeOreInput((String)extraInput);
        } else {
            throw new IllegalArgumentException();
        }
        return gTRecipeInput;
    }

    @JvmStatic
    public static final int getGTHatchFluidAmount(int offsetTier) {
        int n;
        switch (offsetTier) {
            case 0: {
                n = 4;
                break;
            }
            case 1: {
                n = 9;
                break;
            }
            case 2: {
                n = 18;
                break;
            }
            case 3: {
                n = 36;
                break;
            }
            case 4: {
                n = 72;
                break;
            }
            case 5: {
                n = 144;
                break;
            }
            case 6: {
                n = 288;
                break;
            }
            case 7: {
                n = 432;
                break;
            }
            case 8: {
                n = 576;
                break;
            }
            case 9: {
                n = 720;
                break;
            }
            case 10: {
                n = 864;
                break;
            }
            case 11: {
                n = 1008;
                break;
            }
            case 12: {
                n = 1152;
                break;
            }
            case 13: {
                n = 1296;
                break;
            }
            case 14: {
                n = 1440;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }
}

