/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.pattern;

import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtechlite.gtlitecore.api.pattern.BlockPatternExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJM\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0015JE\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lgregtechlite/gtlitecore/api/pattern/BlockPatterns;", "", "<init>", "()V", "getMatchingShapes", "", "Lgregtech/api/pattern/MultiblockShapeInfo;", "blockPattern", "Lgregtech/api/pattern/BlockPattern;", "getMatchingShape", "index", "", "repetitionDFS", "", "pattern", "pages", "aisleRepetitions", "", "", "repetitionStack", "Ljava/util/Stack;", "(Lgregtech/api/pattern/BlockPattern;Ljava/util/List;[[ILjava/util/Stack;I)Ljava/util/List;", "(Lgregtech/api/pattern/BlockPattern;Ljava/util/List;[[ILjava/util/Stack;)Ljava/util/List;", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nBlockPatterns.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockPatterns.kt\ngregtechlite/gtlitecore/api/pattern/BlockPatterns\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1872#2,3:84\n1872#2,3:87\n*S KotlinDebug\n*F\n+ 1 BlockPatterns.kt\ngregtechlite/gtlitecore/api/pattern/BlockPatterns\n*L\n45#1:84,3\n68#1:87,3\n*E\n"})
public final class BlockPatterns {
    @NotNull
    public static final BlockPatterns INSTANCE = new BlockPatterns();

    private BlockPatterns() {
    }

    @NotNull
    public final List<MultiblockShapeInfo> getMatchingShapes(@NotNull BlockPattern blockPattern) {
        Intrinsics.checkNotNullParameter((Object)blockPattern, (String)"blockPattern");
        int[][] aisleRepetitions = blockPattern.aisleRepetitions;
        int maxPages = ((BlockPatternExtension)blockPattern).getPreviewPages();
        List list = new ArrayList();
        Intrinsics.checkNotNull((Object)aisleRepetitions);
        List<MultiblockShapeInfo> pages = this.repetitionDFS(blockPattern, list, aisleRepetitions, new Stack<Integer>());
        if (pages.size() < maxPages) {
            int i;
            int[] repetition = new int[((Object[])aisleRepetitions).length];
            int n = repetition.length;
            for (i = 0; i < n; ++i) {
                int[] nArray = aisleRepetitions[i];
                Intrinsics.checkNotNull((Object)nArray);
                repetition[i] = nArray[1];
            }
            for (i = pages.size(); i < maxPages; ++i) {
                pages.add(new MultiblockShapeInfo(((BlockPatternExtension)blockPattern).getPreview(repetition, i)));
            }
        }
        return pages;
    }

    @NotNull
    public final List<MultiblockShapeInfo> getMatchingShape(@NotNull BlockPattern blockPattern, int index) {
        Intrinsics.checkNotNullParameter((Object)blockPattern, (String)"blockPattern");
        int[][] aisleRepetitions = blockPattern.aisleRepetitions;
        List list = new ArrayList();
        Intrinsics.checkNotNull((Object)aisleRepetitions);
        return this.repetitionDFS(blockPattern, list, aisleRepetitions, new Stack<Integer>(), index);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MultiblockShapeInfo> repetitionDFS(BlockPattern pattern, List<MultiblockShapeInfo> pages, int[][] aisleRepetitions, Stack<Integer> repetitionStack, int index) {
        if (repetitionStack.size() == ((Object[])aisleRepetitions).length) {
            int[] repetition = new int[repetitionStack.size()];
            Iterable $this$forEachIndexed$iv = repetitionStack;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void i;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Integer n2 = (Integer)item$iv;
                int index2 = n;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)i);
                repetition[index2] = i.intValue();
            }
            Intrinsics.checkNotNull((Object)pattern, (String)"null cannot be cast to non-null type gregtechlite.gtlitecore.api.pattern.BlockPatternExtension");
            pages.add(new MultiblockShapeInfo(((BlockPatternExtension)pattern).getPreview(repetition, index)));
        } else {
            int n;
            int i = aisleRepetitions[repetitionStack.size()][0];
            if (i <= (n = aisleRepetitions[repetitionStack.size()][1])) {
                while (true) {
                    repetitionStack.push(i);
                    this.repetitionDFS(pattern, pages, aisleRepetitions, repetitionStack, index);
                    repetitionStack.pop();
                    if (i == n) break;
                    ++i;
                }
            }
        }
        return pages;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MultiblockShapeInfo> repetitionDFS(BlockPattern pattern, List<MultiblockShapeInfo> pages, int[][] aisleRepetitions, Stack<Integer> repetitionStack) {
        if (repetitionStack.size() == ((Object[])aisleRepetitions).length) {
            int[] repetition = new int[repetitionStack.size()];
            Iterable $this$forEachIndexed$iv = repetitionStack;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void i;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Integer n2 = (Integer)item$iv;
                int index = n;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)i);
                repetition[index] = i.intValue();
            }
            Intrinsics.checkNotNull((Object)pattern, (String)"null cannot be cast to non-null type gregtechlite.gtlitecore.api.pattern.BlockPatternExtension");
            pages.add(new MultiblockShapeInfo(((BlockPatternExtension)pattern).getPreview(repetition, pages.size())));
        } else {
            int n;
            int i = aisleRepetitions[repetitionStack.size()][0];
            if (i <= (n = aisleRepetitions[repetitionStack.size()][1])) {
                while (true) {
                    repetitionStack.push(i);
                    this.repetitionDFS(pattern, pages, aisleRepetitions, repetitionStack);
                    repetitionStack.pop();
                    if (i == n) break;
                    ++i;
                }
            }
        }
        return pages;
    }
}

