/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.metatileentity.multiblock;

import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.client.renderer.ICubeRenderer;
import gregtechlite.gtlitecore.api.capability.ModuleProvider;
import gregtechlite.gtlitecore.api.capability.ModuleReceiver;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0014J\b\u0010,\u001a\u00020)H$J\b\u0010-\u001a\u00020)H\u0016J\b\u0010.\u001a\u00020)H\u0016J\b\u0010/\u001a\u000200H$J\b\u00101\u001a\u00020)H\u0014J\b\u00102\u001a\u0004\u0018\u00010\u001cJ1\u00103\u001a\u0004\u0018\u0001H4\"\b\b\u0000\u00104*\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H4072\b\u00108\u001a\u0004\u0018\u000109H\u0016\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<H\u0016J\u0010\u0010>\u001a\u00020)2\u0006\u0010=\u001a\u00020<H\u0016J\u0010\u0010?\u001a\u00020)2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020)2\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010C\u001a\u00020)2\u0006\u0010D\u001a\u00020\b2\u0006\u0010@\u001a\u00020AH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010E\u001a\u00020)2\u0006\u0010F\u001a\u00020\"J\b\u0010G\u001a\u00020\bH\u0016J\u0018\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020\"2\u0006\u0010J\u001a\u00020\u001eH\u0004J\u0010\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020\"H\u0004J\b\u0010K\u001a\u00020LH%J\u0014\u0010M\u001a\u0004\u0018\u00010L2\b\u0010N\u001a\u0004\u0018\u00010OH'J\b\u0010P\u001a\u00020\"H\u0016J\b\u0010Q\u001a\u00020)H\u0016J\b\u0010R\u001a\u00020)H\u0016J\b\u0010'\u001a\u00020\"H\u0016J\u0010\u0010S\u001a\u00020)2\u0006\u0010T\u001a\u00020\"H\u0016J\b\u0010U\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\t\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\n\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001c8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\"8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00020\b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000eR\u0012\u0010'\u001a\u00020\"8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lgregtechlite/gtlitecore/api/metatileentity/multiblock/ModuleMultiblockBase;", "Lgregtech/api/metatileentity/multiblock/MultiblockWithDisplayBase;", "Lgregtechlite/gtlitecore/api/capability/ModuleReceiver;", "Lgregtech/api/capability/IWorkable;", "Lgregtech/api/capability/IControllable;", "metaTileEntityId", "Lnet/minecraft/util/ResourceLocation;", "tier", "", "moduleTier", "minCasingTier", "<init>", "(Lnet/minecraft/util/ResourceLocation;III)V", "getTier", "()I", "getModuleTier", "getMinCasingTier", "moduleProvider", "Lgregtechlite/gtlitecore/api/capability/ModuleProvider;", "getModuleProvider", "()Lgregtechlite/gtlitecore/api/capability/ModuleProvider;", "setModuleProvider", "(Lgregtechlite/gtlitecore/api/capability/ModuleProvider;)V", "displayCountName", "", "getDisplayCountName", "()Ljava/lang/String;", "energyContainer", "Lgregtech/api/capability/IEnergyContainer;", "energyConsumed", "", "getEnergyConsumed", "()J", "isActive", "", "maxProgress", "progress", "progressPercent", "getProgressPercent", "isWorkingEnabled", "formStructure", "", "context", "Lgregtech/api/pattern/PatternMatchContext;", "initializeAbilities", "checkStructurePattern", "invalidateStructure", "createStructurePattern", "Lgregtech/api/pattern/BlockPattern;", "updateFormedValid", "getEnergyContainer", "getCapability", "T", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "side", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "data", "readFromNBT", "writeInitialSyncData", "buf", "Lnet/minecraft/network/PacketBuffer;", "receiveInitialSyncData", "receiveCustomData", "dataId", "setActive", "active", "getProgress", "drainEnergy", "simulate", "energy", "getFrontOverlay", "Lgregtech/client/renderer/ICubeRenderer;", "getBaseTexture", "sourcePart", "Lgregtech/api/metatileentity/multiblock/IMultiblockPart;", "hasMaintenanceMechanics", "sentWorkingDisabled", "sentWorkingEnabled", "setWorkingEnabled", "workingEnabled", "getMaxProgress", "gtlitecore"})
public abstract class ModuleMultiblockBase
extends MultiblockWithDisplayBase
implements ModuleReceiver,
IWorkable,
IControllable {
    private final int tier;
    private final int moduleTier;
    private final int minCasingTier;
    @Nullable
    private ModuleProvider moduleProvider;
    @JvmField
    @NotNull
    protected IEnergyContainer energyContainer;
    private final long energyConsumed;
    @JvmField
    protected boolean isActive;
    @JvmField
    protected int maxProgress;
    @JvmField
    protected int progress;
    @JvmField
    protected boolean isWorkingEnabled;

    public ModuleMultiblockBase(@NotNull ResourceLocation metaTileEntityId, int tier, int moduleTier, int minCasingTier) {
        Intrinsics.checkNotNullParameter((Object)metaTileEntityId, (String)"metaTileEntityId");
        super(metaTileEntityId);
        this.tier = tier;
        this.moduleTier = moduleTier;
        this.minCasingTier = minCasingTier;
        this.energyConsumed = (long)(Math.pow(4.0, this.tier + 2) / (double)2);
        this.energyContainer = (IEnergyContainer)new EnergyContainerHandler((MetaTileEntity)this, (long)((double)160008000 * Math.pow(4.0, this.tier - 9)), this.energyConsumed, 1L, 0L, 0L);
    }

    protected final int getTier() {
        return this.tier;
    }

    protected final int getModuleTier() {
        return this.moduleTier;
    }

    protected final int getMinCasingTier() {
        return this.minCasingTier;
    }

    @Override
    @Nullable
    public ModuleProvider getModuleProvider() {
        return this.moduleProvider;
    }

    @Override
    public void setModuleProvider(@Nullable ModuleProvider moduleProvider) {
        this.moduleProvider = moduleProvider;
    }

    @Override
    @NotNull
    public String getDisplayCountName() {
        return this.getMetaName() + ".display_count";
    }

    protected final long getEnergyConsumed() {
        return this.energyConsumed;
    }

    public final int getProgressPercent() {
        return (int)(1.0f * (float)this.progress / (float)this.maxProgress * (float)100);
    }

    protected void formStructure(@Nullable PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    protected abstract void initializeAbilities();

    public void checkStructurePattern() {
        block1: {
            super.checkStructurePattern();
            ModuleProvider moduleProvider = this.getModuleProvider();
            if (moduleProvider == null) break block1;
            Integer n = moduleProvider.getCasingTier();
            int it = ((Number)n).intValue();
            boolean bl = false;
            if (it >= this.minCasingTier) {
                super.checkStructurePattern();
            }
        }
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.setModuleProvider(null);
    }

    @NotNull
    protected abstract BlockPattern createStructurePattern();

    protected void updateFormedValid() {
        if (this.getOffsetTimer() % (long)20 == 0L && this.getModuleProvider() != null) {
            if (this.energyContainer.getEnergyCapacity() != this.energyContainer.getEnergyStored()) {
                ModuleProvider moduleProvider = this.getModuleProvider();
                Intrinsics.checkNotNull((Object)moduleProvider);
                IEnergyContainer iEnergyContainer = moduleProvider.getSubEnergyContainer();
                Intrinsics.checkNotNull((Object)iEnergyContainer);
                if (iEnergyContainer.getEnergyStored() > this.energyConsumed * (long)20) {
                    long simulate = this.energyContainer.getEnergyCapacity() - this.energyContainer.getEnergyStored();
                    this.energyContainer.addEnergy(simulate);
                }
            }
        } else if (this.getModuleProvider() == null) {
            this.isWorkingEnabled = false;
        }
    }

    @Nullable
    public final IEnergyContainer getEnergyContainer() {
        ModuleProvider moduleProvider = this.getModuleProvider();
        return (moduleProvider != null ? moduleProvider.getSubEnergyContainer() : null) == null ? (IEnergyContainer)new EnergyContainerHandler((MetaTileEntity)this, 0L, 0L, 0L, 0L, 0L) : this.energyContainer;
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing side) {
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        if (capability == GregtechTileCapabilities.CAPABILITY_WORKABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_WORKABLE.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.writeToNBT(data);
        data.func_74768_a("progressTime", this.progress);
        data.func_74768_a("maxProgress", this.maxProgress);
        data.func_74757_a("isActive", this.isActive);
        data.func_74757_a("isWorkingEnabled", this.isWorkingEnabled);
        return data;
    }

    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super.readFromNBT(data);
        this.progress = data.func_74762_e("progressTime");
        this.maxProgress = data.func_74762_e("maxProgress");
        this.isActive = data.func_74767_n("isActive");
        this.isWorkingEnabled = data.func_74767_n("isWorkingEnabled");
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.writeInitialSyncData(buf);
        buf.writeInt(this.progress);
        buf.writeInt(this.maxProgress);
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.isWorkingEnabled);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveInitialSyncData(buf);
        this.progress = buf.readInt();
        this.maxProgress = buf.readInt();
        this.isActive = buf.readBoolean();
        this.isWorkingEnabled = buf.readBoolean();
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.setActive(buf.readBoolean());
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    public boolean isActive() {
        return this.isActive && this.isWorkingEnabled;
    }

    public final void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.markDirty();
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, arg_0 -> ModuleMultiblockBase.setActive$lambda$1(active, arg_0));
            }
        }
    }

    public int getProgress() {
        return this.progress;
    }

    protected final boolean drainEnergy(boolean simulate, long energy) {
        long result = this.energyContainer.getEnergyStored() - energy;
        if (result >= 0L && result <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.changeEnergy(-energy);
            }
            return true;
        }
        return false;
    }

    protected final boolean drainEnergy(boolean simulate) {
        long result = this.energyContainer.getEnergyStored() - this.energyContainer.getInputVoltage();
        if (result >= 0L && result <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.changeEnergy(-this.energyContainer.getInputVoltage());
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected abstract ICubeRenderer getFrontOverlay();

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public abstract ICubeRenderer getBaseTexture(@Nullable IMultiblockPart var1);

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    @Override
    public void sentWorkingDisabled() {
        this.isWorkingEnabled = false;
    }

    @Override
    public void sentWorkingEnabled() {
        this.isWorkingEnabled = true;
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        this.initializeAbilities();
        this.isWorkingEnabled = workingEnabled;
        this.markDirty();
        World world = this.getWorld();
        boolean bl = world != null ? !world.field_72995_K : false;
        if (bl) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, arg_0 -> ModuleMultiblockBase.setWorkingEnabled$lambda$2(this, arg_0));
        }
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    private static final void setActive$lambda$1(boolean $active, PacketBuffer buf) {
        PacketBuffer packetBuffer = buf;
        Intrinsics.checkNotNull((Object)packetBuffer);
        packetBuffer.writeBoolean($active);
    }

    private static final void setWorkingEnabled$lambda$2(ModuleMultiblockBase this$0, PacketBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.writeBoolean(this$0.isWorkingEnabled);
    }
}

