/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.item;

import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.MaterialToolProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lgregtechlite/gtlitecore/api/item/GTLiteToolHelper;", "", "<init>", "()V", "getMaxDurability", "", "material", "Lgregtech/api/unification/material/Material;", "getMaxCraftingDurability", "isItemHasFullDurability", "", "stack", "Lnet/minecraft/item/ItemStack;", "gtlitecore"})
public final class GTLiteToolHelper {
    @NotNull
    public static final GTLiteToolHelper INSTANCE = new GTLiteToolHelper();

    private GTLiteToolHelper() {
    }

    @JvmStatic
    public static final int getMaxDurability(@NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        if (!material.hasProperty(PropertyKey.TOOL)) {
            throw new IllegalArgumentException("Material " + material.getName() + " does not have ToolProperty!");
        }
        return ((MaterialToolProperty)material.getProperty(PropertyKey.TOOL)).getToolDurability();
    }

    @JvmStatic
    public static final int getMaxCraftingDurability(@NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        if (!material.hasProperty(PropertyKey.TOOL)) {
            throw new IllegalArgumentException("Material " + material.getName() + " does not have ToolProperty!");
        }
        return ((MaterialToolProperty)material.getProperty(PropertyKey.TOOL)).getToolDurability() / 2;
    }

    @JvmStatic
    public static final boolean isItemHasFullDurability(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Item item = stack.func_77973_b();
        return !item.isRepairable() || item.getDamage(stack) <= 0;
    }
}

