/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.extension;

import gregtech.api.fluids.FluidBuilder;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.MaterialToolProperty;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u001a#\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a#\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\r\u001a#\u0010\u000e\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\r\u001a#\u0010\u000f\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\r\u001a*\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004\u001aC\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\r\u001a\u001a\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a\u001a*\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004\u001a:\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004\u001a,\u0010\u001f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\b\b\u0002\u0010$\u001a\u00020%\u001a\u001a\u0010&\u001a\u00020\u0001*\u00020\u00012\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0012\u001aB\u0010)\u001a\u00020\u0001*\u00020\u00012\u0006\u0010*\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\b\b\u0002\u0010+\u001a\u00020%2\b\b\u0002\u0010,\u001a\u00020%2\b\b\u0002\u0010-\u001a\u00020%2\b\b\u0002\u0010.\u001a\u00020%\u001a\"\u0010/\u001a\u00020\u0001*\u00020\u00012\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0004\u00a8\u00062"}, d2={"colorAverage", "Lgregtech/api/unification/material/Material$Builder;", "inputs", "", "", "", "Lgregtech/api/unification/material/Material;", "(Lgregtech/api/unification/material/Material$Builder;[Lgregtech/api/unification/material/Material;)Lgregtech/api/unification/material/Material$Builder;", "liquid", "builder", "Lkotlin/Function1;", "Lgregtech/api/fluids/FluidBuilder;", "", "Lkotlin/ExtensionFunctionType;", "gas", "plasma", "toolProp", "harvestSpeed", "", "attackDamage", "durability", "harvestLevel", "Lgregtech/api/unification/material/properties/MaterialToolProperty$Builder;", "blastProp", "temperature", "gasTier", "Lgregtech/api/unification/material/properties/BlastProperty$GasTier;", "blastEUtOverride", "blastDurationOverride", "freezeEUtOverride", "freezeDurationOverride", "cableProp", "vol", "", "amp", "loss", "isSuperconductor", "", "itemPipeProp", "priority", "transferRate", "fluidPipeProp", "maxTemperature", "gasProof", "acidProof", "cryoProof", "plasmaProof", "rotorProp", "speed", "damage", "gtlitecore"})
public final class MaterialBuilderExtKt {
    @NotNull
    public static final Material.Builder colorAverage(@NotNull Material.Builder $this$colorAverage, int ... inputs) {
        Intrinsics.checkNotNullParameter((Object)$this$colorAverage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        int red = 0;
        int green = 0;
        int blue = 0;
        int n = inputs.length;
        for (int i = 0; i < n; ++i) {
            int input = inputs[i];
            red += input - input % (int)Math.pow(256.0, 2) >> 16;
            green += (input - input % 256 >> 8) % 256;
            blue += input % 256;
        }
        int divisor = inputs.length;
        int result = blue / divisor;
        result += green / divisor << 8;
        $this$colorAverage.color(result += red / divisor << 16);
        return $this$colorAverage;
    }

    @NotNull
    public static final Material.Builder colorAverage(@NotNull Material.Builder $this$colorAverage, Material ... inputs) {
        Intrinsics.checkNotNullParameter((Object)$this$colorAverage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        int red = 0;
        int green = 0;
        int blue = 0;
        int n = inputs.length;
        for (int i = 0; i < n; ++i) {
            Material input = inputs[i];
            int inputRGB = input.getMaterialRGB();
            red += inputRGB - inputRGB % (int)Math.pow(256.0, 2) >> 16;
            green += (inputRGB - inputRGB % 256 >> 8) % 256;
            blue += inputRGB % 256;
        }
        int divisor = inputs.length;
        int result = blue / divisor;
        result += green / divisor << 8;
        $this$colorAverage.color(result += red / divisor << 16);
        return $this$colorAverage;
    }

    @NotNull
    public static final Material.Builder liquid(@NotNull Material.Builder $this$liquid, @NotNull Function1<? super FluidBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)$this$liquid, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        FluidBuilder fluidBuilder = new FluidBuilder();
        builder.invoke((Object)fluidBuilder);
        $this$liquid.liquid(fluidBuilder);
        return $this$liquid;
    }

    @NotNull
    public static final Material.Builder gas(@NotNull Material.Builder $this$gas, @NotNull Function1<? super FluidBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)$this$gas, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        FluidBuilder fluidBuilder = new FluidBuilder();
        builder.invoke((Object)fluidBuilder);
        $this$gas.gas(fluidBuilder);
        return $this$gas;
    }

    @NotNull
    public static final Material.Builder plasma(@NotNull Material.Builder $this$plasma, @NotNull Function1<? super FluidBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)$this$plasma, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        FluidBuilder fluidBuilder = new FluidBuilder();
        builder.invoke((Object)fluidBuilder);
        $this$plasma.plasma(fluidBuilder);
        return $this$plasma;
    }

    @NotNull
    public static final Material.Builder toolProp(@NotNull Material.Builder $this$toolProp, float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$toolProp, (String)"<this>");
        $this$toolProp.toolStats(MaterialToolProperty.Builder.of((float)harvestSpeed, (float)attackDamage, (int)durability, (int)harvestLevel).build());
        return $this$toolProp;
    }

    @NotNull
    public static final Material.Builder toolProp(@NotNull Material.Builder $this$toolProp, float harvestSpeed, float attackDamage, int durability, int harvestLevel, @NotNull Function1<? super MaterialToolProperty.Builder, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)$this$toolProp, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        MaterialToolProperty.Builder builder2 = MaterialToolProperty.Builder.of((float)harvestSpeed, (float)attackDamage, (int)durability, (int)harvestLevel);
        builder.invoke((Object)builder2);
        $this$toolProp.toolStats(builder2.build());
        return $this$toolProp;
    }

    @NotNull
    public static final Material.Builder blastProp(@NotNull Material.Builder $this$blastProp, int temperature, @NotNull BlastProperty.GasTier gasTier) {
        Intrinsics.checkNotNullParameter((Object)$this$blastProp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gasTier, (String)"gasTier");
        $this$blastProp.blast(arg_0 -> MaterialBuilderExtKt.blastProp$lambda$0(temperature, gasTier, arg_0));
        return $this$blastProp;
    }

    @NotNull
    public static final Material.Builder blastProp(@NotNull Material.Builder $this$blastProp, int temperature, @NotNull BlastProperty.GasTier gasTier, int blastEUtOverride, int blastDurationOverride) {
        Intrinsics.checkNotNullParameter((Object)$this$blastProp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gasTier, (String)"gasTier");
        $this$blastProp.blast(arg_0 -> MaterialBuilderExtKt.blastProp$lambda$1(temperature, gasTier, blastEUtOverride, blastDurationOverride, arg_0));
        return $this$blastProp;
    }

    @NotNull
    public static final Material.Builder blastProp(@NotNull Material.Builder $this$blastProp, int temperature, @NotNull BlastProperty.GasTier gasTier, int blastEUtOverride, int blastDurationOverride, int freezeEUtOverride, int freezeDurationOverride) {
        Intrinsics.checkNotNullParameter((Object)$this$blastProp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gasTier, (String)"gasTier");
        $this$blastProp.blast(arg_0 -> MaterialBuilderExtKt.blastProp$lambda$2(temperature, gasTier, blastEUtOverride, blastDurationOverride, freezeEUtOverride, freezeDurationOverride, arg_0));
        return $this$blastProp;
    }

    @NotNull
    public static final Material.Builder cableProp(@NotNull Material.Builder $this$cableProp, long vol, int amp, int loss, boolean isSuperconductor) {
        Intrinsics.checkNotNullParameter((Object)$this$cableProp, (String)"<this>");
        $this$cableProp.cableProperties(vol, amp, loss, isSuperconductor);
        return $this$cableProp;
    }

    public static /* synthetic */ Material.Builder cableProp$default(Material.Builder builder, long l, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return MaterialBuilderExtKt.cableProp(builder, l, n, n2, bl);
    }

    @NotNull
    public static final Material.Builder itemPipeProp(@NotNull Material.Builder $this$itemPipeProp, int priority, float transferRate) {
        Intrinsics.checkNotNullParameter((Object)$this$itemPipeProp, (String)"<this>");
        $this$itemPipeProp.itemPipeProperties(priority, transferRate);
        return $this$itemPipeProp;
    }

    @NotNull
    public static final Material.Builder fluidPipeProp(@NotNull Material.Builder $this$fluidPipeProp, int maxTemperature, int transferRate, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
        Intrinsics.checkNotNullParameter((Object)$this$fluidPipeProp, (String)"<this>");
        $this$fluidPipeProp.fluidPipeProperties(maxTemperature, transferRate, gasProof, acidProof, cryoProof, plasmaProof);
        return $this$fluidPipeProp;
    }

    public static /* synthetic */ Material.Builder fluidPipeProp$default(Material.Builder builder, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x10) != 0) {
            bl3 = false;
        }
        if ((n3 & 0x20) != 0) {
            bl4 = false;
        }
        return MaterialBuilderExtKt.fluidPipeProp(builder, n, n2, bl, bl2, bl3, bl4);
    }

    @NotNull
    public static final Material.Builder rotorProp(@NotNull Material.Builder $this$rotorProp, float speed, float damage, int durability) {
        Intrinsics.checkNotNullParameter((Object)$this$rotorProp, (String)"<this>");
        $this$rotorProp.rotorStats(speed, damage, durability);
        return $this$rotorProp;
    }

    private static final BlastProperty.Builder blastProp$lambda$0(int $temperature, BlastProperty.GasTier $gasTier, BlastProperty.Builder b) {
        return b.temp($temperature, $gasTier);
    }

    private static final BlastProperty.Builder blastProp$lambda$1(int $temperature, BlastProperty.GasTier $gasTier, int $blastEUtOverride, int $blastDurationOverride, BlastProperty.Builder b) {
        return b.temp($temperature, $gasTier).blastStats($blastEUtOverride, $blastDurationOverride);
    }

    private static final BlastProperty.Builder blastProp$lambda$2(int $temperature, BlastProperty.GasTier $gasTier, int $blastEUtOverride, int $blastDurationOverride, int $freezeEUtOverride, int $freezeDurationOverride, BlastProperty.Builder b) {
        return b.temp($temperature, $gasTier).blastStats($blastEUtOverride, $blastDurationOverride).vacuumStats($freezeEUtOverride, $freezeDurationOverride);
    }
}

