/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.api.block.attribute;

import gregtechlite.gtlitecore.api.block.attribute.BlockAttributeRegistry;
import gregtechlite.gtlitecore.api.block.attribute.LazyValue;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.state.IBlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006j\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J9\u0010&\u001a\u00020\"2*\u0010'\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000)0(\"\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000)H\u0016\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000eH\u0016J\u0017\u0010,\u001a\u0004\u0018\u00018\u00002\u0006\u0010#\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010-J\u001d\u0010.\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00142\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\"H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001e\u00a8\u00061"}, d2={"Lgregtechlite/gtlitecore/api/block/attribute/DefaultBlockAttributeRegistry;", "T", "Lgregtechlite/gtlitecore/api/block/attribute/BlockAttributeRegistry;", "name", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(Ljava/lang/String;Ljava/util/Comparator;)V", "getName", "()Ljava/lang/String;", "attributeLookup", "", "Lnet/minecraft/block/state/IBlockState;", "blockLookup", "Ljava/util/NavigableMap;", "", "_ascendingBlocks", "Lgregtechlite/gtlitecore/api/block/attribute/LazyValue;", "", "_descendingBlocks", "ascendingBlocks", "getAscendingBlocks", "()Ljava/util/List;", "descendingBlocks", "getDescendingBlocks", "blockSize", "", "getBlockSize", "()I", "attributeSize", "getAttributeSize", "register", "", "state", "attribute", "(Lnet/minecraft/block/state/IBlockState;Ljava/lang/Object;)V", "registerAll", "pairs", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)V", "unregister", "getAttribute", "(Lnet/minecraft/block/state/IBlockState;)Ljava/lang/Object;", "getBlock", "(Ljava/lang/Object;)Ljava/util/List;", "invalidate", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nDefaultBlockAttributeRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultBlockAttributeRegistry.kt\ngregtechlite/gtlitecore/api/block/attribute/DefaultBlockAttributeRegistry\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,62:1\n13402#2,2:63\n*S KotlinDebug\n*F\n+ 1 DefaultBlockAttributeRegistry.kt\ngregtechlite/gtlitecore/api/block/attribute/DefaultBlockAttributeRegistry\n*L\n36#1:63,2\n*E\n"})
public final class DefaultBlockAttributeRegistry<T>
implements BlockAttributeRegistry<T> {
    @NotNull
    private final String name;
    @NotNull
    private final Map<IBlockState, T> attributeLookup;
    @NotNull
    private final NavigableMap<T, List<IBlockState>> blockLookup;
    @NotNull
    private LazyValue<List<IBlockState>> _ascendingBlocks;
    @NotNull
    private LazyValue<List<IBlockState>> _descendingBlocks;

    public DefaultBlockAttributeRegistry(@NotNull String name, @NotNull Comparator<? super T> comparator) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.name = name;
        this.attributeLookup = (Map)new Object2ObjectOpenHashMap();
        this.blockLookup = new TreeMap(comparator);
        this._ascendingBlocks = new LazyValue(() -> DefaultBlockAttributeRegistry._ascendingBlocks$lambda$0(this));
        this._descendingBlocks = new LazyValue(() -> DefaultBlockAttributeRegistry._descendingBlocks$lambda$1(this));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<IBlockState> getAscendingBlocks() {
        return this._ascendingBlocks.get();
    }

    @Override
    @NotNull
    public List<IBlockState> getDescendingBlocks() {
        return this._descendingBlocks.get();
    }

    @Override
    public int getBlockSize() {
        return this.attributeLookup.size();
    }

    @Override
    public int getAttributeSize() {
        return this.blockLookup.size();
    }

    @Override
    public void register(@NotNull IBlockState state, T attribute) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.attributeLookup.put(state, attribute);
        this.blockLookup.computeIfAbsent(attribute, arg_0 -> DefaultBlockAttributeRegistry.register$lambda$3(DefaultBlockAttributeRegistry::register$lambda$2, arg_0)).add(state);
        this.invalidate();
    }

    @Override
    public void registerAll(Pair<? extends IBlockState, ? extends T> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        Pair<? extends IBlockState, ? extends T>[] $this$forEach$iv = pairs;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair<? extends IBlockState, ? extends T> element$iv;
            Pair<? extends IBlockState, ? extends T> it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.register((IBlockState)it.getFirst(), it.getSecond());
        }
    }

    @Override
    public void unregister(@NotNull IBlockState state) {
        block1: {
            T t;
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            T t2 = this.attributeLookup.remove(state);
            if (t2 == null) break block1;
            T it = t = t2;
            boolean bl = false;
            List list = (List)this.blockLookup.get(it);
            if (list != null) {
                list.remove(state);
            }
        }
    }

    @Override
    @Nullable
    public T getAttribute(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.attributeLookup.get(state);
    }

    @Override
    @Nullable
    public List<IBlockState> getBlock(T attribute) {
        return (List)this.blockLookup.get(attribute);
    }

    private final void invalidate() {
        this._ascendingBlocks.invalidate();
        this._descendingBlocks.invalidate();
    }

    private static final List _ascendingBlocks$lambda$0(DefaultBlockAttributeRegistry this$0) {
        Collection collection = this$0.blockLookup.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.flatten((Iterable)collection);
    }

    private static final List _descendingBlocks$lambda$1(DefaultBlockAttributeRegistry this$0) {
        Collection collection = this$0.blockLookup.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.flatten((Iterable)CollectionsKt.reversed((Iterable)collection));
    }

    private static final List register$lambda$2(Object it) {
        return new ArrayList();
    }

    private static final List register$lambda$3(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

