/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util.cache;

import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CachedSupplier<T>
implements Supplier<T> {
    private final Supplier<T> delegate;
    @Nullable
    private volatile T cachedValue;

    public CachedSupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    public void invalidate() {
        this.cachedValue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T ret = this.cachedValue;
        if (ret == null) {
            CachedSupplier cachedSupplier = this;
            synchronized (cachedSupplier) {
                ret = this.cachedValue;
                if (ret == null) {
                    this.cachedValue = ret = this.delegate.get();
                    if (ret == null) {
                        throw new IllegalStateException("Value cannot be null, but supplier returned null: " + this.delegate);
                    }
                }
            }
        }
        return ret;
    }
}

