/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class CachedFunction<T, R>
implements Function<T, R> {
    private final Function<T, R> delegate;
    private final Map<T, R> cache = new ConcurrentHashMap<T, R>();

    public CachedFunction(Function<T, R> delegate) {
        this.delegate = delegate;
    }

    public void invalidate() {
        this.cache.clear();
    }

    @Override
    public R apply(T t) {
        return this.cache.computeIfAbsent(t, this.delegate);
    }
}

