/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util;

import com.morphismmc.morphismlib.collection.ListOps;
import com.morphismmc.morphismlib.util.BlockCoord;
import com.morphismmc.morphismlib.util.EntityUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.jetbrains.annotations.Nullable;

public final class WorldUtil {
    public static String getWorldName(World world) {
        return world.func_72912_H().func_76065_j();
    }

    public static int getDimension(World world) {
        return world.field_73011_w.getDimension();
    }

    @Nullable
    public static File getSaveLocation(World world) {
        File root = DimensionManager.getCurrentSaveRootDirectory();
        if (root == null) {
            return null;
        }
        String saveFolder = world.field_73011_w.getSaveFolder();
        return saveFolder != null ? new File(root, saveFolder) : root;
    }

    @Nullable
    public static File getSaveLocation(int dim) {
        WorldServer world = DimensionManager.getWorld((int)dim);
        return world != null ? WorldUtil.getSaveLocation((World)world) : null;
    }

    public static void fireBlockUpdate(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 3);
    }

    public static void fireBlockUpdate(TileEntity tileEntity) {
        WorldUtil.fireBlockUpdate(tileEntity.func_145831_w(), tileEntity.func_174877_v());
    }

    public static List<RayTraceResult> rayTraceAllBlocks(World world, Vec3d start, Vec3d end) {
        return WorldUtil.rayTraceAllBlocks(world, start, end, false);
    }

    public static List<RayTraceResult> rayTraceAllBlocks(World world, Vec3d start, Vec3d end, boolean includeLiquids) {
        return WorldUtil.rayTraceAllBlocks(world, start, end, includeLiquids, false);
    }

    public static List<RayTraceResult> rayTraceAllBlocks(World world, Vec3d start, Vec3d end, boolean includeLiquids, boolean ignoreBlockWithoutBoundingBox) {
        ArrayList<RayTraceResult> results = new ArrayList<RayTraceResult>();
        if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
            return results;
        }
        if (Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c)) {
            return results;
        }
        int endBlockX = MathHelper.func_76128_c((double)end.field_72450_a);
        int endBlockY = MathHelper.func_76128_c((double)end.field_72448_b);
        int endBlockZ = MathHelper.func_76128_c((double)end.field_72449_c);
        int currentBlockX = MathHelper.func_76128_c((double)start.field_72450_a);
        int currentBlockY = MathHelper.func_76128_c((double)start.field_72448_b);
        int currentBlockZ = MathHelper.func_76128_c((double)start.field_72449_c);
        BlockPos.PooledMutableBlockPos currentBlockPos = BlockPos.PooledMutableBlockPos.func_185339_c((int)currentBlockX, (int)currentBlockY, (int)currentBlockZ);
        IBlockState currentState = world.func_180495_p((BlockPos)currentBlockPos);
        if ((!ignoreBlockWithoutBoundingBox || currentState.func_185890_d((IBlockAccess)world, (BlockPos)currentBlockPos) != Block.field_185506_k) && currentState.func_177230_c().func_176209_a(currentState, includeLiquids)) {
            results.add(currentState.func_185910_a(world, (BlockPos)currentBlockPos, start, end));
        }
        int stepCount = 200;
        while (stepCount-- >= 0) {
            EnumFacing stepFacing;
            if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                return ListOps.of();
            }
            if (currentBlockX == endBlockX && currentBlockY == endBlockY && currentBlockZ == endBlockZ) {
                return results;
            }
            double boundaryX = 999.0;
            double factorX = 999.0;
            double directionX = end.field_72450_a - start.field_72450_a;
            if (endBlockX != currentBlockX && (factorX = ((boundaryX = endBlockX > currentBlockX ? (double)currentBlockX + 1.0 : (double)currentBlockX) - start.field_72450_a) / directionX) == -0.0) {
                factorX = -1.0E-4;
            }
            double boundaryY = 999.0;
            double factorY = 999.0;
            double directionY = end.field_72448_b - start.field_72448_b;
            if (endBlockY != currentBlockY && (factorY = ((boundaryY = endBlockY > currentBlockY ? (double)currentBlockY + 1.0 : (double)currentBlockY) - start.field_72448_b) / directionY) == -0.0) {
                factorY = -1.0E-4;
            }
            double boundaryZ = 999.0;
            double factorZ = 999.0;
            double directionZ = end.field_72449_c - start.field_72449_c;
            if (endBlockZ != currentBlockZ && (factorZ = ((boundaryZ = endBlockZ > currentBlockZ ? (double)currentBlockZ + 1.0 : (double)currentBlockZ) - start.field_72449_c) / directionZ) == -0.0) {
                factorZ = -1.0E-4;
            }
            if (factorX < factorY && factorX < factorZ) {
                stepFacing = endBlockX > currentBlockX ? EnumFacing.WEST : EnumFacing.EAST;
                start = new Vec3d(boundaryX, start.field_72448_b + directionY * factorX, start.field_72449_c + directionZ * factorX);
            } else if (factorY < factorZ) {
                stepFacing = endBlockY > currentBlockY ? EnumFacing.DOWN : EnumFacing.UP;
                start = new Vec3d(start.field_72450_a + directionX * factorY, boundaryY, start.field_72449_c + directionZ * factorY);
            } else {
                stepFacing = endBlockZ > currentBlockZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                start = new Vec3d(start.field_72450_a + directionX * factorZ, start.field_72448_b + directionY * factorZ, boundaryZ);
            }
            currentBlockX = MathHelper.func_76128_c((double)start.field_72450_a) - (stepFacing == EnumFacing.EAST ? 1 : 0);
            currentBlockY = MathHelper.func_76128_c((double)start.field_72448_b) - (stepFacing == EnumFacing.UP ? 1 : 0);
            currentBlockZ = MathHelper.func_76128_c((double)start.field_72449_c) - (stepFacing == EnumFacing.SOUTH ? 1 : 0);
            currentBlockPos.func_181079_c(currentBlockX, currentBlockY, currentBlockZ);
            currentState = world.func_180495_p((BlockPos)currentBlockPos);
            if (ignoreBlockWithoutBoundingBox && currentState.func_185904_a() != Material.field_151567_E && currentState.func_185890_d((IBlockAccess)world, (BlockPos)currentBlockPos) == Block.field_185506_k || !currentState.func_177230_c().func_176209_a(currentState, includeLiquids)) continue;
            results.add(currentState.func_185910_a(world, (BlockPos)currentBlockPos, start, end));
        }
        return results;
    }

    public static void dropItem(World world, ItemStack stack, BlockPos pos) {
        WorldUtil.dropItem(world, stack, pos, 0.5);
    }

    public static void dropItem(World world, ItemStack stack, BlockPos pos, double velocity) {
        WorldUtil.dropItem(world, stack, BlockCoord.getBottomCenter(pos), velocity);
    }

    public static void dropItem(World world, ItemStack stack, Vec3d pos, double velocity) {
        EntityItem entityitem;
        if (stack.func_190926_b()) {
            return;
        }
        if (velocity != 0.0) {
            double offsetX = (double)world.field_73012_v.nextFloat() * velocity + (1.0 - velocity) * 0.5;
            double offsetY = (double)world.field_73012_v.nextFloat() * velocity + (1.0 - velocity) * 0.5;
            double offsetZ = (double)world.field_73012_v.nextFloat() * velocity + (1.0 - velocity) * 0.5;
            entityitem = new EntityItem(world, pos.field_72450_a + offsetX, pos.field_72448_b + offsetY, pos.field_72449_c + offsetZ, stack);
            entityitem.func_174869_p();
        } else {
            entityitem = new EntityItem(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.0;
            entityitem.field_70179_y = 0.0;
            entityitem.func_174868_q();
        }
        world.func_72838_d((Entity)entityitem);
    }

    public static void dropItem(ItemStack stack, World world, Vec3d dropLocation) {
        EntityItem item = new EntityItem(world, dropLocation.field_72450_a, dropLocation.field_72448_b, dropLocation.field_72449_c, stack);
        item.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
        item.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + (double)0.2f;
        item.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
        world.func_72838_d((Entity)item);
    }

    public static void ejectItem(World world, ItemStack stack, BlockPos pos, EnumFacing dir) {
        WorldUtil.ejectItem(world, stack, BlockCoord.getCenter(pos), dir, 0.3);
    }

    public static void ejectItem(World world, ItemStack stack, BlockPos pos, EnumFacing dir, double velocity) {
        WorldUtil.ejectItem(world, stack, BlockCoord.getCenter(pos), dir, velocity);
    }

    public static void ejectItem(World world, ItemStack stack, Vec3d pos, EnumFacing dir, double velocity) {
        EntityItem entity = new EntityItem(world, pos.field_72450_a + (double)dir.func_82601_c(), pos.field_72448_b + (double)dir.func_96559_d(), pos.field_72449_c + (double)dir.func_82599_e(), stack);
        EntityUtil.setVelocity((Entity)entity, 0.0, 0.0, 0.0);
        EntityUtil.setVelocity((Entity)entity, (double)dir.func_82601_c() * velocity, (double)dir.func_96559_d() * velocity, (double)dir.func_82599_e() * velocity);
        entity.func_174869_p();
        world.func_72838_d((Entity)entity);
    }

    public static void dropExperience(World world, Vec3d pos, int experience) {
        while (experience > 0) {
            int frag = EntityXPOrb.func_70527_a((int)experience);
            experience -= frag;
            world.func_72838_d((Entity)new EntityXPOrb(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, frag));
        }
    }

    private WorldUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

