/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util;

import com.morphismmc.morphismlib.util.function.ThrowingBiConsumer;
import com.morphismmc.morphismlib.util.function.ThrowingBiFunction;
import com.morphismmc.morphismlib.util.function.ThrowingConsumer;
import com.morphismmc.morphismlib.util.function.ThrowingFunction;
import com.morphismmc.morphismlib.util.function.ThrowingRunnable;
import com.morphismmc.morphismlib.util.function.ThrowingSupplier;
import com.morphismmc.morphismlib.util.function.ThrowingTriConsumer;
import com.morphismmc.morphismlib.util.function.ThrowingTriFunction;
import com.morphismmc.morphismlib.util.function.TriFunction;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public final class Unchecks {
    public static <T> T cast(Object o) {
        return (T)o;
    }

    @Nullable
    public static <T> T assertNullable(T o) {
        return o;
    }

    public static <E extends Throwable> void throwSneaky(Throwable e) throws E {
        throw e;
    }

    public static Runnable runnable(ThrowingRunnable<?> runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable exception) {
                Unchecks.throwSneaky(exception);
            }
        };
    }

    public static <T> Supplier<T> supplier(ThrowingSupplier<T, ?> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Throwable exception) {
                Unchecks.throwSneaky(exception);
                return null;
            }
        };
    }

    public static <T> Consumer<T> consumer(ThrowingConsumer<T, ?> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Throwable exception) {
                Unchecks.throwSneaky(exception);
            }
        };
    }

    public static <T, U> BiConsumer<T, U> biConsumer(ThrowingBiConsumer<T, U, ?> biConsumer) {
        return (t, u) -> {
            try {
                biConsumer.accept(t, u);
            }
            catch (Throwable exception) {
                Unchecks.throwSneaky(exception);
            }
        };
    }

    public static <T, U, S> TriConsumer<T, U, S> triConsumer(ThrowingTriConsumer<T, U, S, ?> triConsumer) {
        return (t, u, s) -> {
            try {
                triConsumer.accept(t, u, s);
            }
            catch (Throwable exception) {
                Unchecks.throwSneaky(exception);
            }
        };
    }

    public static <T, U> Function<T, U> function(ThrowingFunction<T, U, ?> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Throwable exception) {
                Unchecks.throwSneaky(exception);
                return null;
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> biFunction(ThrowingBiFunction<T, U, R, ?> biFunction) {
        return (t, u) -> {
            try {
                return biFunction.apply(t, u);
            }
            catch (Throwable exception) {
                Unchecks.throwSneaky(exception);
                return null;
            }
        };
    }

    public static <T, U, R, S> TriFunction<T, U, R, S> triFunction(ThrowingTriFunction<T, U, R, S, ?> triFunction) {
        return (t, u, r) -> {
            try {
                return triFunction.apply(t, u, r);
            }
            catch (Throwable exception) {
                Unchecks.throwSneaky(exception);
                return null;
            }
        };
    }

    private Unchecks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

