/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.Nullable;

public final class Servers {
    @Nullable
    public static MinecraftServer getCurrent() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static MinecraftServer getCurrentOrThrow() {
        MinecraftServer server = Servers.getCurrent();
        if (server == null) {
            throw new IllegalStateException("There is no server!");
        }
        return server;
    }

    public static boolean isRunning() {
        MinecraftServer server = Servers.getCurrent();
        if (server != null) {
            return !server.func_71241_aa() && server.func_71278_l();
        }
        return false;
    }

    public static int tickCount() {
        return Servers.getCurrentOrThrow().func_71259_af();
    }

    @Nullable
    public static UUID getPlayerUUID(String username) {
        for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
            if (!((String)entry.getValue()).equalsIgnoreCase(username)) continue;
            return (UUID)entry.getKey();
        }
        return null;
    }

    @Nullable
    public static GameProfile getPlayerProfile(String username) {
        EntityPlayerMP player = Servers.getPlayer(username);
        if (player != null) {
            return player.func_146103_bH();
        }
        MinecraftServer server = Servers.getCurrentOrThrow();
        PlayerProfileCache profileCache = server.func_152358_ax();
        PlayerProfileCache.ProfileEntry cachedEntry = (PlayerProfileCache.ProfileEntry)profileCache.field_152661_c.get(username = username.toLowerCase(Locale.ROOT));
        if (cachedEntry != null) {
            return cachedEntry.func_152668_a();
        }
        return profileCache.func_152655_a(username);
    }

    @Nullable
    public static EntityPlayerMP getPlayer(String username) {
        return Servers.getCurrentOrThrow().func_184103_al().func_152612_a(username);
    }

    public static List<EntityPlayerMP> getPlayers() {
        return Servers.getCurrentOrThrow().func_184103_al().func_181057_v();
    }

    public static boolean isPlayerOP(UUID uuid) {
        MinecraftServer server = Servers.getCurrentOrThrow();
        GameProfile profile = server.func_152358_ax().func_152652_a(uuid);
        return profile != null && server.func_184103_al().func_152596_g(profile);
    }

    public static boolean isPlayerOP(String username) {
        GameProfile profile = Servers.getPlayerProfile(username);
        return profile != null && Servers.getCurrentOrThrow().func_184103_al().func_152596_g(profile);
    }

    public static boolean isPlayerOwner(String username) {
        MinecraftServer server = Servers.getCurrentOrThrow();
        return server.func_71264_H() && server.func_71214_G().equalsIgnoreCase(username);
    }

    private Servers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

