/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.Nullable;

public final class NBTUtils {
    public static boolean areEqual(@Nullable NBTBase that, @Nullable NBTBase other, boolean ignoreListOrder) {
        if (that == other) {
            return true;
        }
        if (that == null || other == null) {
            return false;
        }
        if (!that.getClass().equals(other.getClass())) {
            return false;
        }
        boolean thatEmpty = that.func_82582_d();
        boolean otherEmpty = other.func_82582_d();
        if (thatEmpty && otherEmpty) {
            return true;
        }
        if (thatEmpty != otherEmpty) {
            return false;
        }
        if (that instanceof NBTTagCompound) {
            NBTTagCompound thatCompound = (NBTTagCompound)that;
            NBTTagCompound otherCompound = (NBTTagCompound)other;
            if (thatCompound.func_186856_d() != otherCompound.func_186856_d()) {
                return false;
            }
            for (String key : thatCompound.func_150296_c()) {
                if (NBTUtils.areEqual(thatCompound.func_74781_a(key), otherCompound.func_74781_a(key), ignoreListOrder)) continue;
                return false;
            }
            return true;
        }
        if (that instanceof NBTTagList) {
            NBTTagList thatList = (NBTTagList)that;
            if (ignoreListOrder) {
                NBTTagList otherList = (NBTTagList)other;
                if (thatList.func_74745_c() != otherList.func_74745_c()) {
                    return false;
                }
                if (thatList.func_150303_d() != otherList.func_150303_d()) {
                    return false;
                }
                for (int i = 0; i < thatList.func_74745_c(); ++i) {
                    NBTBase tag = thatList.func_179238_g(i);
                    boolean found = false;
                    for (int j = 0; j < otherList.func_74745_c(); ++j) {
                        if (!NBTUtils.areEqual(tag, otherList.func_179238_g(j), true)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
        }
        return that.equals((Object)other);
    }

    private NBTUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

