/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util;

import com.google.common.base.Preconditions;
import com.morphismmc.morphismlib.mixins.minecraftforge.AccessorLoader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.objectweb.asm.Type;

public final class ModScanner {
    public static ASMDataTable getAllScanData() {
        return ((AccessorLoader)Loader.instance()).getDiscoverer().getASMTable();
    }

    public static void findAnnotatedClasses(Class<?> annotationClass, ClassAnnotationCallback callback) {
        ASMDataTable.ASMData data;
        Preconditions.checkArgument((boolean)annotationClass.isAnnotation(), (Object)"The class must be an annotation!");
        Iterator iterator = ModScanner.getAllScanData().getAll(annotationClass.getCanonicalName()).iterator();
        while (!(!iterator.hasNext() || (data = (ASMDataTable.ASMData)iterator.next()).getObjectName().contains(".") && callback.accept(ClassData.of(data), AnnotationData.of(data)))) {
        }
    }

    public static void findAnnotatedFields(Class<?> annotationClass, FieldAnnotationCallback callback) {
        ASMDataTable.ASMData data;
        String objectName;
        Preconditions.checkArgument((boolean)annotationClass.isAnnotation(), (Object)"The class must be an annotation!");
        Iterator iterator = ModScanner.getAllScanData().getAll(annotationClass.getCanonicalName()).iterator();
        while (iterator.hasNext() && ((objectName = (data = (ASMDataTable.ASMData)iterator.next()).getObjectName()).contains(".") || objectName.contains("(") || !callback.accept(FieldData.of(data), AnnotationData.of(data)))) {
        }
    }

    public static void findAnnotatedMethods(Class<?> annotationClass, MethodAnnotationCallback callback) {
        ASMDataTable.ASMData data;
        String objectName;
        Preconditions.checkArgument((boolean)annotationClass.isAnnotation(), (Object)"The class must be an annotation!");
        Iterator iterator = ModScanner.getAllScanData().getAll(annotationClass.getCanonicalName()).iterator();
        while (!(!iterator.hasNext() || (objectName = (data = (ASMDataTable.ASMData)iterator.next()).getObjectName()).contains("(") && callback.accept(MethodData.of(data), AnnotationData.of(data)))) {
        }
    }

    public static void findInterfaceImplementations(Class<?> interfaceClass, Predicate<ClassData> predicate) {
        ASMDataTable.ASMData data;
        Preconditions.checkArgument((boolean)interfaceClass.isInterface(), (Object)"The class must be an interface!");
        Iterator iterator = ModScanner.getAllScanData().getAll(interfaceClass.getCanonicalName()).iterator();
        while (iterator.hasNext() && !predicate.test(ClassData.of(data = (ASMDataTable.ASMData)iterator.next()))) {
        }
    }

    private ModScanner() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class ClassData {
        private final String name;

        public ClassData(String name) {
            this.name = name;
        }

        public static ClassData of(ASMDataTable.ASMData data) {
            return new ClassData(data.getClassName());
        }

        public Class<?> getClassObject() throws ClassNotFoundException {
            return Class.forName(this.name);
        }

        public String toString() {
            return "ClassData[" + "name=" + this.name + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(((ClassData)arg0).name, this.name);
            {
            }
        }

        public String name() {
            return this.name;
        }
    }

    public static final class AnnotationData {
        private final String name;
        private final Map<String, Object> info;

        public AnnotationData(String name, Map<String, Object> info) {
            this.name = name;
            this.info = info;
        }

        public static AnnotationData of(ASMDataTable.ASMData data) {
            return new AnnotationData(data.getAnnotationName(), data.getAnnotationInfo());
        }

        public String toString() {
            return "AnnotationData[" + "name=" + this.name + "," + "info=" + this.info + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.info != null ? this.info.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((AnnotationData)arg0).name, this.name)) {
                return false;
            }
            return Objects.equals(((AnnotationData)arg0).info, this.info);
            {
            }
        }

        public String name() {
            return this.name;
        }

        public Map<String, Object> info() {
            return this.info;
        }
    }

    @FunctionalInterface
    public static interface ClassAnnotationCallback {
        public boolean accept(ClassData var1, AnnotationData var2);
    }

    public static final class FieldData {
        private final String className;
        private final String fieldName;

        public FieldData(String className, String fieldName) {
            this.className = className;
            this.fieldName = fieldName;
        }

        public static FieldData of(ASMDataTable.ASMData data) {
            return new FieldData(data.getClassName(), data.getObjectName());
        }

        public Field getFieldObject() throws ClassNotFoundException, NoSuchFieldException {
            return Class.forName(this.className).getDeclaredField(this.fieldName);
        }

        public String toString() {
            return "FieldData[" + "className=" + this.className + "," + "fieldName=" + this.fieldName + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
            result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((FieldData)arg0).className, this.className)) {
                return false;
            }
            return Objects.equals(((FieldData)arg0).fieldName, this.fieldName);
            {
            }
        }

        public String className() {
            return this.className;
        }

        public String fieldName() {
            return this.fieldName;
        }
    }

    @FunctionalInterface
    public static interface FieldAnnotationCallback {
        public boolean accept(FieldData var1, AnnotationData var2);
    }

    public static final class MethodData {
        private final String className;
        private final String methodName;
        private final String[] argumentTypes;
        private final String returnType;

        public MethodData(String className, String methodName, String[] argumentTypes, String returnType) {
            this.className = className;
            this.methodName = methodName;
            this.argumentTypes = argumentTypes;
            this.returnType = returnType;
        }

        public static MethodData of(ASMDataTable.ASMData data) {
            String objectName = data.getObjectName();
            int index = objectName.indexOf(40);
            if (index > 0) {
                String methodName = objectName.substring(0, index);
                String methodDescriptor = objectName.substring(index);
                String[] argumentTypes = (String[])Arrays.stream(Type.getArgumentTypes((String)methodDescriptor)).map(Type::getClassName).toArray(String[]::new);
                String returnType = Type.getReturnType((String)methodDescriptor).getClassName();
                return new MethodData(data.getClassName(), methodName, argumentTypes, returnType);
            }
            return new MethodData(data.getClassName(), data.getClassName(), new String[0], Type.VOID_TYPE.getClassName());
        }

        public Method getMethodObject() throws ClassNotFoundException, NoSuchMethodException {
            Class[] paraTypes = new Class[this.argumentTypes.length];
            for (int i = 0; i < this.argumentTypes.length; ++i) {
                paraTypes[i] = Class.forName(this.argumentTypes[i]);
            }
            return Class.forName(this.className).getDeclaredMethod(this.methodName, paraTypes);
        }

        public String toString() {
            return "MethodData[" + "className=" + this.className + "," + "methodName=" + this.methodName + "," + "argumentTypes=" + this.argumentTypes + "," + "returnType=" + this.returnType + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
            result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.argumentTypes);
            result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((MethodData)arg0).className, this.className)) {
                return false;
            }
            if (!Objects.equals(((MethodData)arg0).methodName, this.methodName)) {
                return false;
            }
            if (!Objects.equals(((MethodData)arg0).argumentTypes, this.argumentTypes)) {
                return false;
            }
            return Objects.equals(((MethodData)arg0).returnType, this.returnType);
            {
            }
        }

        public String className() {
            return this.className;
        }

        public String methodName() {
            return this.methodName;
        }

        public String[] argumentTypes() {
            return this.argumentTypes;
        }

        public String returnType() {
            return this.returnType;
        }
    }

    @FunctionalInterface
    public static interface MethodAnnotationCallback {
        public boolean accept(MethodData var1, AnnotationData var2);
    }
}

