/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util;

import com.morphismmc.morphismlib.math.Vector3i;
import com.morphismmc.morphismlib.util.BlockCoord;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class LeafDecayUpdate {
    private static final byte SUSTAINS_LEAVES = 0;
    private static final byte NOT_SUSTAINS_LEAVES = -1;
    private static final byte IS_LEAVES = -2;
    private static final int BASE_RADIUS = 4;
    private static final int ARRAY_SIZE = 9;
    private static final int ARRAY_OFFSET = 4;
    private static final byte[][][] leafDecayGrid = new byte[9][9][9];
    private static final Vector3i[] CARDINAL_DIRS = new Vector3i[]{new Vector3i(1, 0, 0), new Vector3i(-1, 0, 0), new Vector3i(0, 1, 0), new Vector3i(0, -1, 0), new Vector3i(0, 0, 1), new Vector3i(0, 0, -1)};

    public static void leafDecay(Block leaves, World world, BlockPos pos) {
        if (world.field_72995_K || !world.func_175697_a(pos, 5)) {
            return;
        }
        IBlockState centerState = world.func_180495_p(pos);
        if (!LeafDecayUpdate.isDecayableLeaf(centerState)) {
            return;
        }
        LeafDecayUpdate.resetDecayGrid();
        LeafDecayUpdate.scanSurroundingBlocks(world, pos);
        LeafDecayUpdate.propagateSustainValues();
        LeafDecayUpdate.determineBlockFate(leaves, world, pos, centerState);
    }

    private static boolean isDecayableLeaf(IBlockState state) {
        return state.func_177230_c() instanceof BlockLeaves && (Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b) != false && (Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176237_a) != false;
    }

    private static void resetDecayGrid() {
        byte[][][] byArray = leafDecayGrid;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[][] layer;
            for (byte[] row : layer = byArray[i]) {
                Arrays.fill(row, (byte)-1);
            }
        }
    }

    private static void scanSurroundingBlocks(World world, BlockPos center) {
        for (BlockPos.MutableBlockPos pos : BlockCoord.getAllInBoxMutable(center, 4)) {
            int dx = pos.func_177958_n() - center.func_177958_n();
            int dy = pos.func_177956_o() - center.func_177956_o();
            int dz = pos.func_177952_p() - center.func_177952_p();
            IBlockState state = world.func_180495_p((BlockPos)pos);
            LeafDecayUpdate.leafDecayGrid[dx + 4][dy + 4][dz + 4] = LeafDecayUpdate.determineBlockValue(state.func_177230_c(), state, world, (BlockPos)pos);
        }
    }

    private static byte determineBlockValue(Block block, IBlockState state, World world, BlockPos pos) {
        if (block.canSustainLeaves(state, (IBlockAccess)world, pos)) {
            return 0;
        }
        return block.isLeaves(state, (IBlockAccess)world, pos) ? (byte)-2 : -1;
    }

    private static void propagateSustainValues() {
        for (int iteration = 1; iteration <= 8; ++iteration) {
            for (int x = 0; x < 9; ++x) {
                for (int y = 0; y < 9; ++y) {
                    for (int z = 0; z < 9; ++z) {
                        if (leafDecayGrid[x][y][z] != iteration - 1) continue;
                        LeafDecayUpdate.updateNeighbors(x, y, z, (byte)iteration);
                    }
                }
            }
        }
    }

    private static void updateNeighbors(int x, int y, int z, byte value) {
        for (Vector3i dir : CARDINAL_DIRS) {
            Vector3i neighbor = new Vector3i(x, y, z);
            neighbor.add(dir);
            if (!LeafDecayUpdate.isWithinBounds(neighbor) || leafDecayGrid[neighbor.x][neighbor.y][neighbor.z] != -2) continue;
            LeafDecayUpdate.leafDecayGrid[neighbor.x][neighbor.y][neighbor.z] = value;
        }
    }

    private static boolean isWithinBounds(Vector3i pos) {
        return pos.x >= 0 && pos.x < 9 && pos.y >= 0 && pos.y < 9 && pos.z >= 0 && pos.z < 9;
    }

    private static void determineBlockFate(Block leaves, World world, BlockPos pos, IBlockState state) {
        byte centerValue = leafDecayGrid[4][4][4];
        if (centerValue >= 0) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), 18);
        } else {
            leaves.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }
}

