/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util;

import com.morphismmc.morphismlib.mixins.minecraft.AccessorItemStack;
import com.morphismmc.morphismlib.util.Checks;
import com.morphismmc.morphismlib.util.NBTUtils;
import com.morphismmc.morphismlib.util.Unchecks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemUtil {
    public static ItemStack createPotion(PotionType type) {
        return PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)type);
    }

    public static ItemStack createSplashPotion(PotionType type) {
        return PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)type);
    }

    public static ItemStack copyWithSize(ItemStack stack, int size) {
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    public static int getItemDamage(ItemStack stack) {
        return ((AccessorItemStack)Unchecks.cast(stack)).getItemDamage();
    }

    public static int getBurnTime(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack);
    }

    public static boolean matchesOreDict(ItemStack stack, String oreDict) {
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)id).equals(oreDict)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFull(ItemStack stack) {
        return stack.func_190916_E() >= stack.func_77976_d();
    }

    public static boolean areItemEqual(ItemStack that, ItemStack other) {
        if (that == other) {
            return true;
        }
        if (that.func_190926_b() || other.func_190926_b()) {
            return false;
        }
        return that.func_77973_b() == other.func_77973_b();
    }

    public static boolean areItemTypeEqual(ItemStack that, ItemStack other) {
        if (that == other) {
            return true;
        }
        if (that.func_190926_b() || other.func_190926_b()) {
            return false;
        }
        if (that.func_77973_b().func_77614_k()) {
            return that.func_77969_a(other);
        }
        return that.func_77973_b() == other.func_77973_b();
    }

    public static boolean areCraftingTypeEqual(ItemStack that, ItemStack other) {
        if (that == other) {
            return true;
        }
        if (that.func_190926_b() || other.func_190926_b()) {
            return false;
        }
        int thatDamage = ItemUtil.getItemDamage(that);
        int otherDamage = ItemUtil.getItemDamage(other);
        return that.func_77973_b() == other.func_77973_b() && (thatDamage == otherDamage || thatDamage == Short.MAX_VALUE || otherDamage == Short.MAX_VALUE || !that.func_77973_b().func_77614_k());
    }

    public static boolean areItemDamageEqual(ItemStack that, ItemStack other) {
        return ItemStack.func_179545_c((ItemStack)that, (ItemStack)other);
    }

    public static boolean areItemTagsEqual(ItemStack that, ItemStack other, boolean useShareTag) {
        if (that == other) {
            return true;
        }
        if (that.func_190926_b() && other.func_190926_b()) {
            return true;
        }
        return !that.func_190926_b() && !other.func_190926_b() && that.func_77969_a(other) && ItemUtil.areTagsEqual(that, other, useShareTag);
    }

    public static boolean areEqual(ItemStack that, ItemStack other, boolean useShareTag) {
        if (that == other) {
            return true;
        }
        if (that.func_190926_b() && other.func_190926_b()) {
            return true;
        }
        return !that.func_190926_b() && !other.func_190926_b() && that.func_190916_E() == other.func_190916_E() && that.func_77969_a(other) && ItemUtil.areTagsEqual(that, other, useShareTag);
    }

    public static boolean canStack(ItemStack that, ItemStack other) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)that, (ItemStack)other);
    }

    public static boolean canStackRelaxed(ItemStack that, ItemStack other) {
        return ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)that, (ItemStack)other);
    }

    public static boolean areTagsEqual(ItemStack that, ItemStack other, boolean useShareTag) {
        return ItemUtil.areTagsEqual(that, other, useShareTag, false);
    }

    public static boolean areTagsEqual(ItemStack that, ItemStack other, boolean useShareTag, boolean ignoreListOrder) {
        return NBTUtils.areEqual((NBTBase)(useShareTag ? that.func_77973_b().getNBTShareTag(that) : that.func_77978_p()), (NBTBase)(useShareTag ? other.func_77973_b().getNBTShareTag(other) : other.func_77978_p()), ignoreListOrder) && (useShareTag || that.areCapsCompatible(other));
    }

    public static NBTTagCompound getOrCreateTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return Checks.notnullM(stack.func_77978_p(), new Object[0]);
    }

    private ItemUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

