/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util;

import com.morphismmc.morphismlib.collection.GameIterators;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public final class ItemHandlerUtil {
    public static void forEach(IInventory inventory, Predicate<ItemStack> predicate) {
        ItemStack stack;
        for (int i = 0; i < inventory.func_70302_i_() && ((stack = inventory.func_70301_a(i)).func_190926_b() || !predicate.test(stack)); ++i) {
        }
    }

    public static void forEach(IItemHandler handler, Predicate<ItemStack> predicate) {
        ItemStack stack;
        for (int i = 0; i < handler.getSlots() && ((stack = handler.getStackInSlot(i)).func_190926_b() || !predicate.test(stack)); ++i) {
        }
    }

    public static void setStackInSlot(IItemHandler handler, int slot, ItemStack stack) {
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handlerModifiable = (IItemHandlerModifiable)handler;
            handlerModifiable.setStackInSlot(slot, stack);
        } else {
            handler.extractItem(slot, Integer.MAX_VALUE, false);
            handler.insertItem(slot, stack, false);
        }
    }

    public static Iterable<ItemStack> getStacks(IItemHandler handler) {
        return () -> GameIterators.wrap(handler);
    }

    public static void clear(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemHandlerUtil.setStackInSlot(handler, i, ItemStack.field_190927_a);
        }
    }

    public static boolean isEmpty(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static void copy(IItemHandler from, IItemHandler to, boolean deepCopy) {
        for (int i = 0; i < Math.min(from.getSlots(), to.getSlots()); ++i) {
            ItemHandlerUtil.setStackInSlot(to, i, deepCopy ? from.getStackInSlot(i).func_77946_l() : from.getStackInSlot(i));
        }
    }

    public static void copy(IInventory from, IItemHandler to, boolean deepCopy) {
        for (int i = 0; i < Math.min(from.func_70302_i_(), to.getSlots()); ++i) {
            ItemHandlerUtil.setStackInSlot(to, i, deepCopy ? from.func_70301_a(i).func_77946_l() : from.func_70301_a(i));
        }
    }

    private ItemHandlerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

