/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util;

import com.morphismmc.morphismlib.util.FluidUtils;
import com.morphismmc.morphismlib.util.ItemUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public final class FluidHandlerUtil {
    public static FluidActionResult tryFillContainer(ItemStack container, FluidStack source, @Nullable EntityPlayer player, boolean doFill) {
        if (container.func_190926_b() || source.getFluid() == null || source.amount <= 0) {
            return FluidActionResult.FAILURE;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ItemUtil.copyWithSize(container, 1));
        if (handler == null) {
            return FluidActionResult.FAILURE;
        }
        int filledAmount = handler.fill(source.copy(), true);
        if (filledAmount <= 0) {
            return FluidActionResult.FAILURE;
        }
        if (doFill) {
            source.amount -= filledAmount;
            if (player != null) {
                SoundEvent soundevent = source.getFluid().getFillSound(source);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        return new FluidActionResult(handler.getContainer());
    }

    public static FluidActionResult tryEmptyContainer(ItemStack container, FluidStack destination, int maxAmount, @Nullable EntityPlayer player, boolean doDrain) {
        if (container.func_190926_b()) {
            return FluidActionResult.FAILURE;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ItemUtil.copyWithSize(container, 1));
        if (handler == null) {
            return FluidActionResult.FAILURE;
        }
        FluidStack drained = handler.drain(FluidUtils.copyWithSize(destination, maxAmount), true);
        if (drained == null || drained.amount <= 0) {
            return FluidActionResult.FAILURE;
        }
        if (doDrain) {
            destination.amount += drained.amount;
            if (player != null) {
                SoundEvent soundevent = destination.getFluid().getEmptySound(destination);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        return new FluidActionResult(handler.getContainer());
    }

    private FluidHandlerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

