/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util;

import com.morphismmc.morphismlib.mixins.minecraftforge.AccessorLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class FileUtil {
    private static final File GAME_DIR = (File)FMLInjectionData.data()[6];

    public static File getGameDir() {
        return GAME_DIR;
    }

    public static File getModsDir() {
        return ((AccessorLoader)Loader.instance()).getCanonicalModsDir();
    }

    public static File getConfigDir() {
        return Loader.instance().getConfigDir();
    }

    public static void writeUtf8(File file, String str) throws IOException {
        FileUtils.write((File)file, (CharSequence)str, (Charset)StandardCharsets.UTF_8);
    }

    public static void copyFromJar(Class<?> jarClass, String file, File to) throws IOException {
        URL url = jarClass.getResource("/assets/" + file);
        if (url == null) {
            throw new IOException("File " + file + " not found in jar");
        }
        FileUtils.copyURLToFile((URL)url, (File)to);
    }

    public static void extractZip(File zip, File to) throws IOException {
        if (to.isFile()) {
            throw new IOException("Cannot extract zip to a file");
        }
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File destPath = new File(to, entry.getName());
                if (entry.isDirectory()) {
                    FileUtils.forceMkdir((File)destPath);
                    continue;
                }
                InputStream input = zipFile.getInputStream(entry);
                try (FileOutputStream output = new FileOutputStream(destPath);){
                    IOUtils.copyLarge((InputStream)input, (OutputStream)output);
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
        }
    }

    private FileUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

