/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.util;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.morphismmc.morphismlib.util.Plane;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public final class BlockCoord {
    public static BlockPos get(TileEntity te) {
        return BlockCoord.get(te.func_174877_v());
    }

    public static BlockPos get(Entity e) {
        return BlockCoord.get(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public static BlockPos get(BlockPos pos) {
        return BlockCoord.get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static BlockPos get(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    public static BlockPos get(double x, double y, double z) {
        return BlockCoord.get(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public static BlockPos get(String x, String y, String z) {
        return BlockCoord.get(Strings.isNullOrEmpty((String)x) ? 0 : Integer.parseInt(x), Strings.isNullOrEmpty((String)y) ? 0 : Integer.parseInt(y), Strings.isNullOrEmpty((String)z) ? 0 : Integer.parseInt(z));
    }

    public static BlockPos get(RayTraceResult mop) {
        return BlockCoord.get(mop.func_178782_a());
    }

    public static BlockPos withX(BlockPos pos, int x) {
        return pos.func_177958_n() == x ? pos : BlockCoord.get(x, pos.func_177956_o(), pos.func_177952_p());
    }

    public static BlockPos withY(BlockPos pos, int y) {
        return pos.func_177956_o() == y ? pos : BlockCoord.get(pos.func_177958_n(), y, pos.func_177952_p());
    }

    public static BlockPos withZ(BlockPos pos, int z) {
        return pos.func_177952_p() == z ? pos : BlockCoord.get(pos.func_177958_n(), pos.func_177956_o(), z);
    }

    public static Vec3d getCenter(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static Vec3d getBottomCenter(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    public static int getDistanceSq(BlockPos a, BlockPos b) {
        int xDiff = a.func_177958_n() - b.func_177958_n();
        int yDiff = a.func_177956_o() - b.func_177956_o();
        int zDiff = a.func_177952_p() - b.func_177952_p();
        return xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
    }

    public static int getDistanceSq(BlockPos a, TileEntity other) {
        return BlockCoord.getDistanceSq(a, BlockCoord.get(other));
    }

    public static int getDistance(BlockPos a, BlockPos b) {
        double dsq = BlockCoord.getDistanceSq(a, b);
        return (int)Math.ceil(Math.sqrt(dsq));
    }

    public static int getDistanceM(BlockPos a, BlockPos b) {
        return Math.abs(a.func_177958_n() - b.func_177958_n()) + Math.abs(a.func_177956_o() - b.func_177956_o()) + Math.abs(a.func_177952_p() + b.func_177952_p());
    }

    public static int getDistance(BlockPos a, TileEntity other) {
        return BlockCoord.getDistance(a, BlockCoord.get(other));
    }

    public static Iterable<BlockPos> getAllInBox(BlockPos base, int radius) {
        return BlockPos.func_191532_a((int)(base.func_177958_n() - radius), (int)(base.func_177956_o() - radius), (int)(base.func_177952_p() - radius), (int)(base.func_177958_n() + radius), (int)(base.func_177956_o() + radius), (int)(base.func_177952_p() + radius));
    }

    public static Iterable<BlockPos.MutableBlockPos> getAllInBoxMutable(BlockPos base, int radius) {
        return BlockPos.func_191531_b((int)(base.func_177958_n() - radius), (int)(base.func_177956_o() - radius), (int)(base.func_177952_p() - radius), (int)(base.func_177958_n() + radius), (int)(base.func_177956_o() + radius), (int)(base.func_177952_p() + radius));
    }

    public static Iterable<BlockPos> getAllInPlane(BlockPos base, Plane plane, int radius) {
        Iterable iterable;
        switch (plane) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case VERTICAL_X: {
                iterable = BlockPos.func_191532_a((int)(base.func_177958_n() - radius), (int)(base.func_177956_o() - radius), (int)base.func_177952_p(), (int)(base.func_177958_n() + radius), (int)(base.func_177956_o() + radius), (int)base.func_177952_p());
                break;
            }
            case VERTICAL_Z: {
                iterable = BlockPos.func_191532_a((int)base.func_177958_n(), (int)(base.func_177956_o() - radius), (int)(base.func_177952_p() - radius), (int)base.func_177958_n(), (int)(base.func_177956_o() + radius), (int)(base.func_177952_p() + radius));
                break;
            }
            case HORIZONTAL: {
                iterable = BlockPos.func_191532_a((int)(base.func_177958_n() - radius), (int)base.func_177956_o(), (int)(base.func_177952_p() - radius), (int)(base.func_177958_n() + radius), (int)base.func_177956_o(), (int)(base.func_177952_p() + radius));
            }
        }
        return iterable;
    }

    public static Iterable<BlockPos.MutableBlockPos> getAllInPlaneMutable(BlockPos base, Plane plane, int radius) {
        Iterable iterable;
        switch (plane) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case VERTICAL_X: {
                iterable = BlockPos.func_191531_b((int)(base.func_177958_n() - radius), (int)(base.func_177956_o() - radius), (int)base.func_177952_p(), (int)(base.func_177958_n() + radius), (int)(base.func_177956_o() + radius), (int)base.func_177952_p());
                break;
            }
            case VERTICAL_Z: {
                iterable = BlockPos.func_191531_b((int)base.func_177958_n(), (int)(base.func_177956_o() - radius), (int)(base.func_177952_p() - radius), (int)base.func_177958_n(), (int)(base.func_177956_o() + radius), (int)(base.func_177952_p() + radius));
                break;
            }
            case HORIZONTAL: {
                iterable = BlockPos.func_191531_b((int)(base.func_177958_n() - radius), (int)base.func_177956_o(), (int)(base.func_177952_p() - radius), (int)(base.func_177958_n() + radius), (int)base.func_177956_o(), (int)(base.func_177952_p() + radius));
            }
        }
        return iterable;
    }

    public static Iterable<BlockPos> getAllInBoundingBox(AxisAlignedBB boundingBox) {
        return BlockPos.func_191532_a((int)MathHelper.func_76128_c((double)boundingBox.field_72340_a), (int)MathHelper.func_76128_c((double)boundingBox.field_72338_b), (int)MathHelper.func_76128_c((double)boundingBox.field_72339_c), (int)MathHelper.func_76128_c((double)(boundingBox.field_72336_d + 1.0)), (int)MathHelper.func_76128_c((double)(boundingBox.field_72337_e + 1.0)), (int)MathHelper.func_76128_c((double)(boundingBox.field_72334_f + 1.0)));
    }

    public static Iterable<BlockPos.MutableBlockPos> getAllInBoundingBoxMutable(AxisAlignedBB boundingBox) {
        return BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)boundingBox.field_72340_a), (int)MathHelper.func_76128_c((double)boundingBox.field_72338_b), (int)MathHelper.func_76128_c((double)boundingBox.field_72339_c), (int)MathHelper.func_76128_c((double)(boundingBox.field_72336_d + 1.0)), (int)MathHelper.func_76128_c((double)(boundingBox.field_72337_e + 1.0)), (int)MathHelper.func_76128_c((double)(boundingBox.field_72334_f + 1.0)));
    }

    public static Iterable<BlockPos> getNeighbors(BlockPos pos) {
        return BlockCoord.getNeighbors(pos, EnumFacing.field_82609_l);
    }

    public static Iterable<BlockPos> getHorizontalNeighbors(BlockPos pos) {
        return BlockCoord.getNeighbors(pos, EnumFacing.field_176754_o);
    }

    public static Iterable<BlockPos> getNeighbors(BlockPos pos, EnumFacing ... facings) {
        return () -> Iterators.transform((Iterator)Iterators.forArray((Object[])facings), arg_0 -> ((BlockPos)pos).func_177972_a(arg_0));
    }

    private BlockCoord() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

