/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.math;

import java.util.Random;

public final class MathUtil {
    public static int sampleBinomial(int n, double p, Random rand) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be non-negative");
        }
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p must be in [0,1]");
        }
        if (n == 0 || p == 0.0) {
            return 0;
        }
        if (p == 1.0) {
            return n;
        }
        double mean = (double)n * p;
        double failureMean = (double)n * (1.0 - p);
        if (n >= 1000) {
            return (int)Math.round(mean);
        }
        if (mean >= 10.0 && failureMean >= 10.0) {
            double stdDev = Math.sqrt(mean * (1.0 - p));
            return (int)Math.round(mean + rand.nextGaussian() * stdDev);
        }
        if (p <= 0.01 && n >= 100) {
            double l = Math.exp(-mean);
            int k = 0;
            double product = 1.0;
            do {
                ++k;
            } while ((product *= rand.nextDouble()) > l);
            return k - 1;
        }
        int successes = 0;
        for (int i = 0; i < n; ++i) {
            if (!(rand.nextDouble() < p)) continue;
            ++successes;
        }
        return successes;
    }

    public static long clamp(long num, long min, long max) {
        if (num < min) {
            return min;
        }
        return Math.min(num, max);
    }

    public static int wrap(int x, int min, int max) {
        if (max <= min) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        return Math.floorMod(x - min, max - min) + min;
    }

    public static long wrap(long x, long min, long max) {
        if (max <= min) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        return Math.floorMod(x - min, max - min) + min;
    }

    public static float wrap(float x, float min, float max) {
        if (max <= min) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        float range = max - min;
        return x - (float)Math.floor((x - min) / range) * range;
    }

    public static double wrap(double x, double min, double max) {
        if (max <= min) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        double range = max - min;
        return x - Math.floor((x - min) / range) * range;
    }

    private MathUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

